/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.reform;

import cn.smarthse.core.dao.reform.RefReformacceptanceMapper;
import cn.smarthse.core.dao.reform.RefReformfileMapper;
import cn.smarthse.core.dao.reform.RefReforminformMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.common.generator.SerialTool;
import cn.smarthse.core.model.reform.RefReformacceptance;
import cn.smarthse.core.model.reform.RefReformacceptanceExample;
import cn.smarthse.core.model.reform.RefReformacceptanceWithBLOBs;
import cn.smarthse.core.model.reform.RefReformfile;
import cn.smarthse.core.model.reform.RefReforminform;
import cn.smarthse.core.model.reform.RefReforminformExample;
import cn.smarthse.core.model.reform.RefReformitemWithBLOBs;
import cn.smarthse.core.model.reform.RefReformphase;
import cn.smarthse.core.model.reform.RefReformsolutionWithBLOBs;
import cn.smarthse.core.model.reform.RefReformworkflow;
import cn.smarthse.core.service.reform.ReformItemService;
import cn.smarthse.core.service.reform.ReformPhaseService;
import cn.smarthse.core.service.reform.ReformSolutionService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReformService {
    @Autowired
    private ReformItemService ReformItemService;
    @Autowired
    private ReformSolutionService ReformSolutionService;
    @Autowired
    private ReformPhaseService ReformPhaseService;
    @Autowired
    private RefReformacceptanceMapper RefReformacceptanceMapper;
    @Autowired
    private RefReformfileMapper RefReformfileMapper;
    @Autowired
    private RefReforminformMapper RefReforminformMapper;

    public int createRefItemAndSolution(RefReformitemWithBLOBs refItem, RefReformsolutionWithBLOBs refSolution) {
        refItem.setIsvalid(Constant.ACTIVE_YES);
        this.ReformItemService.createItem(refItem);
        refSolution.setItemid(refItem.getId());
        refSolution.setIsvalid(Constant.ACTIVE_YES);
        this.ReformSolutionService.createSolution(refSolution);
        return 0;
    }

    public int updateInform(RefReforminform record) {
        if (record.getId() == null) {
            return this.RefReforminformMapper.insertSelective(record);
        }
        return this.RefReforminformMapper.updateByPrimaryKeySelective(record);
    }

    public int updateAccept(RefReformacceptanceWithBLOBs record) {
        if (record.getId() == null) {
            return this.RefReformacceptanceMapper.insertSelective(record);
        }
        return this.RefReformacceptanceMapper.updateByPrimaryKeySelective(record);
    }

    public RefReformacceptanceWithBLOBs getHelperInfo(Integer id) {
        return this.RefReformacceptanceMapper.selectByPrimaryKey(id);
    }

    public RefReforminform getInformInfo(Integer itemId) {
        RefReforminform record = null;
        RefReforminformExample e = new RefReforminformExample();
        e.createCriteria().andItemidEqualTo(itemId).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<RefReforminform> list = this.RefReforminformMapper.selectByExample(e);
        if (list != null && list.size() == 1) {
            record = list.get(0);
        }
        RefReformacceptanceExample e2 = new RefReformacceptanceExample();
        e2.createCriteria().andItemidEqualTo((int)itemId).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<RefReformacceptanceWithBLOBs> list2 = this.RefReformacceptanceMapper.selectByExampleWithBLOBs(e2);
        int unreply = 0;
        int abnormal = 0;
        int total = list2.size();
        for (RefReformacceptance refReformacceptance : list2) {
            if (refReformacceptance.getFeedback() == null) {
                ++unreply;
            }
            if (refReformacceptance.getFeedback() == null || refReformacceptance.getFeedback().length() <= 1) continue;
            ++abnormal;
        }
        record.setTotal(total);
        record.setAbnormal(abnormal);
        record.setUnreply(unreply);
        return record;
    }

    public RefReforminform getSummaryInfo(Integer itemId) {
        RefReforminform record = null;
        RefReforminformExample e = new RefReforminformExample();
        e.createCriteria().andItemidEqualTo(itemId).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<RefReforminform> list = this.RefReforminformMapper.selectByExample(e);
        if (list != null && list.size() == 1) {
            record = list.get(0);
        }
        RefReformacceptanceExample e2 = new RefReformacceptanceExample();
        e2.createCriteria().andItemidEqualTo((int)itemId).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<RefReformacceptanceWithBLOBs> list2 = this.RefReformacceptanceMapper.selectByExampleWithBLOBs(e2);
        int unreply = 0;
        int total = list2.size();
        for (RefReformacceptance refReformacceptance : list2) {
            if (refReformacceptance.getIsfinish() != null && refReformacceptance.getIsfinish() != 0) continue;
            ++unreply;
        }
        record.setTotal(total);
        record.setUnreply(unreply);
        return record;
    }

    public int updateFile(RefReformfile record) {
        if (record.getId() == null) {
            record.setIsvalid(Constant.ACTIVE_YES);
            return this.RefReformfileMapper.insertSelective(record);
        }
        return this.RefReformfileMapper.updateByPrimaryKeySelective(record);
    }

    @Transactional
    public int start(RefReformworkflow record) {
        int count = 0;
        this.ReformPhaseService.updateWorkFlow(record);
        RefReformphase phase = this.ReformPhaseService.getByItemId(record.getItemid());
        if (phase != null) {
            phase.setIsreceive((byte)1);
            phase.setReceivetime(new Date());
            phase.setFeedbackno(SerialTool.generatorNo("Feedback"));
            count += this.ReformPhaseService.update(phase);
        }
        return count;
    }

    @Transactional
    public int feedback(RefReformitemWithBLOBs record, Integer uid) {
        int count = 0;
        List<RefReformfile> list = record.getFileList();
        if (list == null) {
            this.ReformPhaseService.updateWorkFlow(record.getFlow());
            RefReformphase phase = this.ReformPhaseService.getByItemId(record.getId());
            phase.setFeedbacker(uid);
            phase.setFeedbacktime(new Date());
            phase.setAcceptno(SerialTool.generatorNo("Accept"));
            return count += this.ReformPhaseService.update(phase);
        }
        int i = 0;
        while (i < list.size()) {
            RefReformfile a = list.get(i);
            if (a.getFile() != null) {
                a.setFiletype((byte)(11 + i));
                a.setItemid(record.getId());
                a.setIsvalid(Constant.ACTIVE_YES);
                count += this.updateFile(a);
            }
            ++i;
        }
        return count;
    }

    @Transactional
    public int accept(String idlist, List<Integer> managerList, List<Integer> helperList) {
        int count = 0;
        List<String> itemIdList = null;
        if (StringUtils.isNotEmpty((String)idlist)) {
            String[] arr = idlist.split(",");
            itemIdList = Arrays.asList(arr);
        }
        String informNo = SerialTool.RefInformNo();
        for (String itemid : itemIdList) {
            RefReformacceptanceWithBLOBs a;
            RefReformitemWithBLOBs record = new RefReformitemWithBLOBs();
            record.setId(Integer.valueOf(itemid));
            ArrayList<RefReformacceptanceWithBLOBs> acceptList = new ArrayList<RefReformacceptanceWithBLOBs>();
            for (Integer id : managerList) {
                a = new RefReformacceptanceWithBLOBs();
                a.setRole((byte)1);
                a.setFeedback("1");
                a.setAccepter(id);
                acceptList.add(a);
            }
            for (Integer id : helperList) {
                a = new RefReformacceptanceWithBLOBs();
                a.setRole((byte)2);
                a.setAccepter(id);
                acceptList.add(a);
            }
            record.setAcceptList(acceptList);
            RefReforminform inform = new RefReforminform();
            inform.setItemid(Integer.valueOf(itemid));
            RefReforminformExample e = new RefReforminformExample();
            e.createCriteria().andItemidEqualTo(inform.getItemid()).andIsvalidEqualTo(Constant.ACTIVE_YES);
            List<RefReforminform> informList = this.RefReforminformMapper.selectByExample(e);
            if (informList.size() < 1) {
                inform.setInformno(informNo);
                inform.setInformtime(new Date());
                inform.setIsvalid(Constant.ACTIVE_YES);
                count += this.RefReforminformMapper.insertSelective(inform);
            }
            count += this.accept(record);
            RefReformphase phase = this.ReformPhaseService.getByItemId(record.getId());
            phase.setAcceptor(managerList.get(0));
            phase.setAcceptmanager(managerList.get(0));
            phase.setAccepttime(new Date());
            phase.setResultno(SerialTool.generatorNo("Result"));
            count += this.ReformPhaseService.update(phase);
        }
        return count;
    }

    @Transactional
    public int accept(RefReformitemWithBLOBs record) {
        List<RefReformacceptanceWithBLOBs> list = record.getAcceptList();
        RefReformacceptanceExample e = new RefReformacceptanceExample();
        e.createCriteria().andItemidEqualTo(record.getId()).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<RefReformacceptance> oldlist = this.RefReformacceptanceMapper.selectByExample(e);
        int count = 0;
        if (list == null) {
            return count;
        }
        int i = 0;
        while (i < list.size()) {
            RefReformacceptanceWithBLOBs a = list.get(i);
            a.setItemid(record.getId());
            a.setIsvalid(Constant.ACTIVE_YES);
            boolean flag = false;
            for (RefReformacceptance b : oldlist) {
                if (!b.getItemid().equals(a.getItemid()) || !b.getAccepter().equals(a.getAccepter())) continue;
                flag = true;
                break;
            }
            if (!flag) {
                count += this.updateAccept(a);
            }
            ++i;
        }
        return count;
    }

    @Transactional
    public int acceptHelper(String idlist, Integer helperId, String feedback) {
        int count = 0;
        List<String> itemIdList = null;
        if (StringUtils.isNotEmpty((String)idlist)) {
            String[] arr = idlist.split(",");
            itemIdList = Arrays.asList(arr);
        }
        for (String itemid : itemIdList) {
            RefReformacceptanceExample e = new RefReformacceptanceExample();
            e.createCriteria().andItemidEqualTo(Integer.valueOf(itemid)).andAccepterEqualTo(helperId).andIsvalidEqualTo(Constant.ACTIVE_YES);
            List<RefReformacceptance> list = this.RefReformacceptanceMapper.selectByExample(e);
            if (list == null || list.size() != 1) continue;
            Integer id = list.get(0).getId();
            RefReformacceptanceWithBLOBs record = new RefReformacceptanceWithBLOBs();
            record.setId(id);
            record.setFeedback(feedback);
            count += this.RefReformacceptanceMapper.updateByPrimaryKeySelective(record);
        }
        return count;
    }

    @Transactional
    public int summary(RefReformitemWithBLOBs record) {
        RefReformacceptanceWithBLOBs accept = record.getAccept();
        this.updateAccept(accept);
        RefReformitemWithBLOBs child = record.getChild();
        if (child != null && accept.getOpinion() == 0) {
            child.setIsvalid(Constant.ACTIVE_YES);
            child.setPid(record.getId());
            child.setCid(record.getCid());
            child.setItemtype(record.getItemtype());
            this.ReformItemService.updateItem(child);
            RefReformphase phase = child.getPhase();
            phase.setCid(record.getCid());
            phase.setIsvalid(Constant.ACTIVE_YES);
            phase.setItemid(child.getId());
            phase.setInformno(SerialTool.generatorNo("RefInform"));
            phase.setInformtime(new Date());
            this.ReformPhaseService.update(phase);
            RefReformworkflow flow = new RefReformworkflow();
            flow.setItemid(child.getId());
            flow.setPhase(1);
            flow.setStatus(Constant.STATUS_EDIT.intValue());
            this.ReformPhaseService.updateWorkFlow(flow);
        }
        return 0;
    }

    public int finish(RefReformitemWithBLOBs record) {
        RefReformphase phase = record.getPhase();
        return this.ReformPhaseService.update(phase);
    }
}

