/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.reform;

import cn.smarthse.core.dao.reform.RefReformphaseMapper;
import cn.smarthse.core.dao.reform.RefReformworkflowMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.reform.RefReformacceptanceWithBLOBs;
import cn.smarthse.core.model.reform.RefReformitem;
import cn.smarthse.core.model.reform.RefReformitemWithBLOBs;
import cn.smarthse.core.model.reform.RefReformphase;
import cn.smarthse.core.model.reform.RefReformphaseExample;
import cn.smarthse.core.model.reform.RefReformsolutionWithBLOBs;
import cn.smarthse.core.model.reform.RefReformworkflow;
import cn.smarthse.core.model.vo.QueryReformParam;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.reform.ReformItemService;
import cn.smarthse.core.service.reform.ReformService;
import cn.smarthse.core.service.reform.ReformSolutionService;
import cn.smarthse.core.service.workflow.IWorkflowService;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReformPhaseService
implements IWorkflowService {
    @Autowired
    private ReformService ReformService;
    @Autowired
    private ReformItemService ReformItemService;
    @Autowired
    private ReformSolutionService ReformSolutionService;
    @Autowired
    private RefReformphaseMapper RefReformphaseMapper;
    @Autowired
    private RefReformworkflowMapper RefReformworkflowMapper;

    public int create(RefReformphase record) {
        record.setIsvalid(Constant.ACTIVE_YES);
        this.RefReformphaseMapper.insertSelective(record);
        return record.getId();
    }

    public int delete(Integer id) {
        RefReformphase a = new RefReformphase();
        a.setId(id);
        a.setIsvalid(Constant.ACTIVE_NO);
        return this.RefReformphaseMapper.updateByPrimaryKeySelective(a);
    }

    public int update(RefReformphase record) {
        if (record.getId() == null) {
            record.setIsvalid(Constant.ACTIVE_YES);
            return this.RefReformphaseMapper.insertSelective(record);
        }
        return this.RefReformphaseMapper.updateByPrimaryKeySelective(record);
    }

    public RefReformphase get(int id) {
        return this.RefReformphaseMapper.selectByPrimaryKey(id);
    }

    public RefReformphase getByItemId(Integer itemId) {
        RefReformphaseExample e = new RefReformphaseExample();
        e.createCriteria().andItemidEqualTo(itemId).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<RefReformphase> list = this.RefReformphaseMapper.selectByExample(e);
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    public List<RefReformphase> queryList(QueryReformParam param) {
        RefReformitem item;
        RefReformphase a;
        Iterator<RefReformphase> it;
        RefReformphaseExample e = new RefReformphaseExample();
        RefReformphaseExample.Criteria c = e.createCriteria();
        c.andCidEqualTo(param.getCid()).andIsvalidEqualTo(Constant.ACTIVE_YES);
        if (param.getBegin() != null) {
            c.andFeedbacktimeGreaterThanOrEqualTo(param.getBegin());
        }
        if (param.getEnd() != null) {
            c.andFeedbacktimeLessThanOrEqualTo(param.getEnd());
        }
        if (param.getAcceptor() != null) {
            c.andAcceptmanagerEqualTo(param.getAcceptor());
        }
        List<RefReformphase> list = this.RefReformphaseMapper.selectByExample(e);
        if (param.getManager() != null) {
            it = list.iterator();
            while (it.hasNext()) {
                a = it.next();
                item = a.getItem();
                if (item.getManager().equals(param.getManager())) continue;
                it.remove();
            }
        }
        if (param.getType() != null) {
            if (param.getType() == 1) {
                it = list.iterator();
                while (it.hasNext()) {
                    a = it.next();
                    item = a.getItem();
                    if (item.getItemstatus().equals(3)) continue;
                    it.remove();
                }
            }
            if (param.getType() == 2) {
                it = list.iterator();
                while (it.hasNext()) {
                    a = it.next();
                    item = a.getItem();
                    if (item.getItemstatus().equals(2)) continue;
                    it.remove();
                }
            }
            if (param.getType() == 3) {
                it = list.iterator();
                while (it.hasNext()) {
                    a = it.next();
                    item = a.getItem();
                    if (item.getItemstatus().equals(5)) continue;
                    it.remove();
                }
            }
        }
        return list;
    }

    @Transactional
    public void updateWorkFlow(RefReformworkflow record, String idlist) {
        if (idlist == null) {
            RefReformitemWithBLOBs item = new RefReformitemWithBLOBs();
            item.setId(record.getItemid());
            item.setItemstatus(record.getPhase());
            this.ReformItemService.updateItem(item);
            if (record.getId() == null) {
                this.RefReformworkflowMapper.insertSelective(record);
            } else {
                this.RefReformworkflowMapper.updateByPrimaryKeySelective(record);
            }
        } else {
            String[] arr;
            String[] stringArray = arr = idlist.split(",");
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                RefReformitemWithBLOBs item = this.ReformItemService.getItem(Integer.valueOf(id));
                item.setItemstatus(record.getPhase());
                this.ReformItemService.updateItem(item);
                if (record.getId() == null) {
                    this.RefReformworkflowMapper.insertSelective(record);
                } else {
                    this.RefReformworkflowMapper.updateByPrimaryKeySelective(record);
                }
                ++n2;
            }
        }
    }

    @Transactional
    public void updateWorkFlow(RefReformworkflow record) {
        this.updateWorkFlow(record, null);
    }

    @Transactional
    public void batchStop(List<Integer> idList) {
        for (Integer id : idList) {
            RefReformworkflow a = new RefReformworkflow();
            a.setItemid(id);
            a.setPhase(-1);
            this.updateWorkFlow(a);
        }
    }

    @Override
    public void workflow(WorkFlowParam param, Integer orderId) {
        RefReformitemWithBLOBs record = this.ReformItemService.getItem(param.getBusinessId());
        RefReformphase phase = record.getPhase();
        String solution = "@solution";
        if (param.getBusinessName().contains(solution)) {
            RefReformsolutionWithBLOBs s = record.getSolution();
            RefReformsolutionWithBLOBs updateRecord = new RefReformsolutionWithBLOBs();
            updateRecord.setId(s.getId());
            updateRecord.setApprovetime(new Date());
            updateRecord.setApprover(Integer.valueOf(param.getApprover()));
            this.ReformSolutionService.updateSolution(updateRecord);
            return;
        }
        RefReformworkflow oldflow = record.getFlow();
        RefReformworkflow flow = new RefReformworkflow();
        flow.setItemid(param.getBusinessId());
        flow.setWorkflowid(orderId);
        if (oldflow == null) {
            flow.setPhase(1);
            flow.setStatus((int)Constant.STATUS_EDIT);
        } else {
            flow.setPhase(oldflow.getPhase());
            flow.setStatus(oldflow.getStatus());
        }
        if (param.getNeedfeedback() != null && param.getNeedfeedback().booleanValue()) {
            List<RefReformacceptanceWithBLOBs> list = record.getAcceptList();
            for (RefReformacceptanceWithBLOBs a : list) {
                if (!a.getAccepter().equals(Integer.valueOf(param.getReceiver()))) continue;
                a.setFeedback(param.getRemark());
                this.ReformService.updateAccept(a);
                flow.setStatus((int)Constant.STATUS_FINISH);
                this.updateWorkFlow(flow);
                break;
            }
            return;
        }
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            switch (flow.getPhase().byteValue()) {
                case 1: {
                    break;
                }
                case 2: {
                    flow.setPhase(3);
                    phase.setFeedbackapprover(Integer.valueOf(param.getApprover()));
                    phase.setFeedbackapprovetime(new Date());
                    this.update(phase);
                    break;
                }
                case 3: {
                    flow.setPhase(4);
                    phase.setAcceptapprover(Integer.valueOf(param.getApprover()));
                    phase.setAcceptapprovetime(new Date());
                    this.update(phase);
                    break;
                }
                case 4: {
                    flow.setPhase(5);
                    phase.setResultapprover(Integer.valueOf(param.getApprover()));
                    phase.setResultapprovetime(new Date());
                    this.update(phase);
                    break;
                }
                case 5: {
                    flow.setPhase(6);
                    break;
                }
            }
        }
        this.updateWorkFlow(flow);
    }

    public String getBusinessPath(String businessIdList, Integer type) {
        String[] idlist = businessIdList.split(",");
        Integer businessId = Integer.valueOf(idlist[0]);
        RefReformitemWithBLOBs record = this.ReformItemService.getItem(businessId);
        switch (type) {
            case 0: {
                switch (record.getFlow().getPhase()) {
                    case 1: {
                        return "forward:/reform/start?approve=0&id=" + businessId;
                    }
                    case 2: {
                        return "forward:/reform/feedback?approve=0&idlist=" + businessIdList;
                    }
                    case 3: {
                        return "forward:/check/accept?approve=0&idlist=" + businessIdList;
                    }
                    case 4: {
                        return "forward:/check/summary?approve=0&id=" + businessId;
                    }
                    case 5: {
                        return "forward:/check/finish?approve=0&id=" + businessId;
                    }
                }
                return "/commons/404";
            }
            case 1: {
                switch (record.getFlow().getPhase()) {
                    case 1: {
                        return "forward:/reform/start?approve=1&id=" + businessId;
                    }
                    case 2: {
                        return "forward:/reform/feedback?approve=1&idlist=" + businessIdList;
                    }
                    case 3: {
                        return "forward:/check/accept?approve=1&idlist=" + businessIdList;
                    }
                    case 4: {
                        return "forward:/check/summary?approve=1&id=" + businessId;
                    }
                    case 5: {
                        return "forward:/check/finish?approve=1&id=" + businessId;
                    }
                }
                return "/commons/404";
            }
            case 2: {
                switch (record.getFlow().getPhase()) {
                    case 1: {
                        return "forward:/reform/start?approve=2&id=" + businessId;
                    }
                    case 2: {
                        return "forward:/reform/feedback?approve=2&idlist=" + businessIdList;
                    }
                    case 3: {
                        return "forward:/check/accept?approve=2&idlist=" + businessIdList;
                    }
                    case 4: {
                        return "forward:/check/summary?approve=2&id=" + businessId;
                    }
                    case 5: {
                        return "forward:/check/finish?approve=2&id=" + businessId;
                    }
                }
                return "/commons/404";
            }
        }
        return "/commons/404";
    }

    public String getInformPath(String businessIdList) {
        return "forward:/check/accept?idlist=" + businessIdList;
    }

    @Override
    public String doTask(Integer businessId, String taskName) {
        if ("inform".equals(taskName)) {
            return "forward:/harmfactor/inform?id=" + businessId;
        }
        if ("read".equals(taskName)) {
            return "forward:/harmfactor/inform?id=" + businessId;
        }
        if ("apply".equals(taskName)) {
            return this.getBusinessPath(businessId.toString(), 0);
        }
        if ("approve".equals(taskName)) {
            return this.getBusinessPath(businessId.toString(), 1);
        }
        return this.getBusinessPath(businessId.toString(), 2);
    }

    @Override
    public String doApproveTask(Integer businessId) {
        return null;
    }

    @Override
    public int terminateTask(Integer businessId) {
        return 0;
    }

    @Override
    public String addWorkUrl() {
        return null;
    }

    @Override
    public String workflowInform(WorkFlowParam param, Integer orderId) {
        return null;
    }
}

