/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.reform;

import cn.smarthse.core.dao.reform.RefReformitemMapper;
import cn.smarthse.core.dao.reform.RefReformregularcheckMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.common.generator.SerialTool;
import cn.smarthse.core.model.reform.RefReformfile;
import cn.smarthse.core.model.reform.RefReformitem;
import cn.smarthse.core.model.reform.RefReformitemExample;
import cn.smarthse.core.model.reform.RefReformitemWithBLOBs;
import cn.smarthse.core.model.reform.RefReformphase;
import cn.smarthse.core.model.reform.RefReformregularcheck;
import cn.smarthse.core.model.reform.RefReformregularcheckExample;
import cn.smarthse.core.model.reform.RefReformsolutionWithBLOBs;
import cn.smarthse.core.model.vo.QueryReformParam;
import cn.smarthse.core.service.reform.ReformPhaseService;
import cn.smarthse.core.service.reform.ReformService;
import cn.smarthse.core.service.reform.ReformSolutionService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReformItemService {
    @Autowired
    private RefReformitemMapper RefReformitemMapper;
    @Autowired
    private ReformService ReformService;
    @Autowired
    private ReformPhaseService ReformPhaseService;
    @Autowired
    private ReformSolutionService ReformSolutionService;
    @Autowired
    private RefReformregularcheckMapper RefReformregularcheckMapper;

    public List<RefReformitem> queryList(QueryReformParam param) {
        return this.RefReformitemMapper.queryItemList(param);
    }

    public List<RefReformitem> getItemList(Integer cid, Integer status) {
        RefReformitemExample e = new RefReformitemExample();
        e.createCriteria().andCidEqualTo(cid).andItemstatusEqualTo(status).andIsvalidEqualTo(Constant.ACTIVE_YES);
        return this.RefReformitemMapper.selectByExample(e);
    }

    public int createItem(RefReformitemWithBLOBs record) {
        record.setIsvalid(Constant.ACTIVE_YES);
        this.RefReformitemMapper.insertSelective(record);
        return record.getId();
    }

    public int deleteItem(Integer id) {
        RefReformitemWithBLOBs a = new RefReformitemWithBLOBs();
        a.setId(id);
        a.setIsvalid(Constant.ACTIVE_NO);
        return this.RefReformitemMapper.updateByPrimaryKeySelective(a);
    }

    public int updateItem(RefReformitemWithBLOBs record) {
        List<RefReformfile> list = record.getFileList();
        boolean isFileUpload = false;
        if (list != null) {
            for (RefReformfile f : list) {
                if (f.getFile() == null) continue;
                isFileUpload = true;
                break;
            }
        }
        if (!isFileUpload) {
            RefReformsolutionWithBLOBs solution;
            if (record.getId() == null) {
                record.setItemno(SerialTool.ReformNo());
                record.setIsvalid(Constant.ACTIVE_YES);
                record.setItemstatus(-2);
                this.RefReformitemMapper.insertSelective(record);
            } else {
                this.RefReformitemMapper.updateByPrimaryKeySelective(record);
            }
            RefReformphase phase = record.getPhase();
            if (phase != null) {
                phase.setItemid(record.getId());
                phase.setUpdatetime(new Date());
                this.ReformPhaseService.update(phase);
            }
            if ((solution = record.getSolution()) != null) {
                solution.setCid(record.getCid());
                solution.setItemid(record.getId());
                this.ReformSolutionService.updateSolution(solution);
            }
            return record.getId();
        }
        int i = 0;
        while (i < list.size()) {
            RefReformfile a = list.get(i);
            if (a.getFile() != null) {
                a.setItemid(record.getId());
                a.setIsvalid(Constant.ACTIVE_YES);
                this.ReformService.updateFile(a);
            }
            ++i;
        }
        return record.getId();
    }

    public List<RefReformitemWithBLOBs> getItemList(List<String> idlist) {
        ArrayList<RefReformitemWithBLOBs> list = new ArrayList<RefReformitemWithBLOBs>();
        for (String id : idlist) {
            RefReformitemWithBLOBs a = this.getItem(Integer.valueOf(id));
            list.add(a);
        }
        return list;
    }

    public RefReformitemWithBLOBs getItem(int id) {
        return this.RefReformitemMapper.selectDetail(id);
    }

    public List<RefReformregularcheck> getRegularCheckByItem(Integer itemId) {
        RefReformregularcheckExample e = new RefReformregularcheckExample();
        e.createCriteria().andItemidEqualTo(itemId).andIsvalidEqualTo(Constant.ACTIVE_YES);
        return this.RefReformregularcheckMapper.selectByExample(e);
    }

    public RefReformregularcheck getRegularCheckByItem(Integer itemId, Date date) {
        RefReformregularcheckExample e = new RefReformregularcheckExample();
        e.createCriteria().andItemidEqualTo(itemId).andUpdatetimeEqualTo(date).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<RefReformregularcheck> list = this.RefReformregularcheckMapper.selectByExample(e);
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    public RefReformregularcheck getRegularCheck(int id) {
        return this.RefReformregularcheckMapper.selectByPrimaryKey(id);
    }

    public int updateRegularCheck(RefReformregularcheck record) {
        return this.RefReformregularcheckMapper.updateByPrimaryKeySelective(record);
    }

    public int insertRegularCheck(RefReformregularcheck record) {
        return this.RefReformregularcheckMapper.insertSelective(record);
    }
}

