/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.physicalcheck.diseasers;

import cn.smarthse.core.dao.PhysicalCheck.diseasers.PhcSuspectedOccupationalDiseasersResultManagerMapper;
import cn.smarthse.core.dao.PhysicalCheck.diseasers.PhcSuspectedOccupationalDiseasersResultMapper;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcSuspectedOccupationalDiseasersResult;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcSuspectedOccupationalDiseasersResultExample;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcSuspectedOccupationalDiseasersResultManager;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcSuspectedOccupationalDiseasersResultManagerExample;
import cn.smarthse.core.service.physicalcheck.diseasers.PhcSuspectedOccupationalDiseasersService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhcSuspectedOccupationalDiseasersResultService {
    @Autowired
    PhcSuspectedOccupationalDiseasersResultMapper resultMapper;
    @Autowired
    PhcSuspectedOccupationalDiseasersResultManagerMapper managerMapper;
    @Autowired
    PhcSuspectedOccupationalDiseasersService diseasersService;

    public PhcSuspectedOccupationalDiseasersResult get(Integer id) {
        PhcSuspectedOccupationalDiseasersResult result = this.resultMapper.selectByPrimaryKey(id);
        this.setChildren(result);
        return result;
    }

    public void setChildren(PhcSuspectedOccupationalDiseasersResult info) {
        if (info == null) {
            return;
        }
        info.setResultManagers(this.getResultManagers(info.getId()));
    }

    private List<PhcSuspectedOccupationalDiseasersResultManager> getResultManagers(Integer pid) {
        PhcSuspectedOccupationalDiseasersResultManagerExample example = new PhcSuspectedOccupationalDiseasersResultManagerExample();
        example.createCriteria().andResultIdEqualTo(pid);
        return this.managerMapper.selectByExample(example);
    }

    private void updateManagers(Integer pid, List<PhcSuspectedOccupationalDiseasersResultManager> managers) {
        if (managers == null || managers.size() == 0) {
            return;
        }
        PhcSuspectedOccupationalDiseasersResultManagerExample example = new PhcSuspectedOccupationalDiseasersResultManagerExample();
        example.createCriteria().andResultIdEqualTo(pid);
        this.managerMapper.deleteByExample(example);
        for (PhcSuspectedOccupationalDiseasersResultManager manager : managers) {
            if (manager.getManagerId() == null) continue;
            manager.setResultId(pid);
            this.managerMapper.insert(manager);
        }
    }

    public void update(PhcSuspectedOccupationalDiseasersResult result) {
        this.resultMapper.updateByPrimaryKeySelective(result);
        this.updateChildren(result);
    }

    public void updateChildren(PhcSuspectedOccupationalDiseasersResult result) {
        this.updateManagers(result.getId(), result.getResultManagers());
    }

    public List<PhcSuspectedOccupationalDiseasersResult> listByPid(Integer id) {
        PhcSuspectedOccupationalDiseasersResultExample example = new PhcSuspectedOccupationalDiseasersResultExample();
        example.createCriteria().andDiseaserIdEqualTo(id);
        return this.resultMapper.selectByExample(example);
    }

    public PhcSuspectedOccupationalDiseasersResult getByPid(Integer id) {
        List<PhcSuspectedOccupationalDiseasersResult> results = this.listByPid(id);
        if (results == null || results.size() == 0) {
            return new PhcSuspectedOccupationalDiseasersResult();
        }
        return results.get(0);
    }

    public void insert(PhcSuspectedOccupationalDiseasersResult result) {
        this.resultMapper.insert(result);
    }

    public void updateByPid(Integer pid, PhcSuspectedOccupationalDiseasersResult result) {
        result.setDiseaserId(pid);
        if (result.getId() != null) {
            this.resultMapper.updateByPrimaryKeySelective(result);
        } else {
            this.resultMapper.insert(result);
        }
    }

    public void deleteByPid(Integer pid) {
        PhcSuspectedOccupationalDiseasersResultExample example = new PhcSuspectedOccupationalDiseasersResultExample();
        example.createCriteria().andDiseaserIdEqualTo(pid);
        this.resultMapper.deleteByExample(example);
    }
}

