/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.physicalcheck.diseasers;

import cn.smarthse.core.dao.PhysicalCheck.diseasers.PhcCheckResultDetailMapper;
import cn.smarthse.core.dao.PhysicalCheck.diseasers.PhcSuspectedOccupationalDiseasersResultManagerMapper;
import cn.smarthse.core.model.PhysicalCheck.PhcSuspectedCheckResultVO;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcCheckResult;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcCheckResultDetail;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcCheckResultDetailDeptGroup;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcCheckResultDetailExample;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcCheckResultDetailStaffGroup;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcCheckResultDetailWorkRoleGroup;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcSuspectedOccupationalDiseasersResultManager;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcSuspectedOccupationalDiseasersResultManagerExample;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhcCheckResultDetailService {
    @Autowired
    PhcCheckResultDetailMapper mapper;
    @Autowired
    PhcSuspectedOccupationalDiseasersResultManagerMapper managerMapper;

    public List<PhcCheckResultDetail> list(PhcCheckResultDetail info) {
        PhcCheckResultDetailExample example = new PhcCheckResultDetailExample();
        PhcCheckResultDetailExample.Criteria criteria = example.createCriteria();
        if (info.getCheckResultId() != null) {
            criteria.andCheckResultIdEqualTo(info.getCheckResultId());
        }
        if (info.getStaffId() != null) {
            criteria.andStaffIdEqualTo(info.getStaffId());
        }
        return this.mapper.selectByExample(example);
    }

    public PhcCheckResultDetail getByCheckResultId(Integer checkResultId) {
        PhcCheckResultDetail info = new PhcCheckResultDetail();
        info.setCheckResultId(checkResultId);
        List<PhcCheckResultDetail> details = this.list(info);
        if (details == null || details.size() == 0) {
            return info;
        }
        info = details.get(0);
        info.setResultManagers(this.getResultManagers(info.getId()));
        return info;
    }

    public void insertOrUpdate(PhcCheckResultDetail detail) {
        if (detail.getId() != null) {
            this.mapper.updateByPrimaryKey(detail);
        } else {
            this.mapper.insert(detail);
        }
        this.updateManagers(detail.getId(), detail.getResultManagers());
    }

    private List<PhcSuspectedOccupationalDiseasersResultManager> getResultManagers(Integer pid) {
        PhcSuspectedOccupationalDiseasersResultManagerExample example = new PhcSuspectedOccupationalDiseasersResultManagerExample();
        example.createCriteria().andResultIdEqualTo(pid);
        return this.managerMapper.selectByExample(example);
    }

    private void updateManagers(Integer pid, List<PhcSuspectedOccupationalDiseasersResultManager> managers) {
        if (managers == null || managers.size() == 0) {
            return;
        }
        PhcSuspectedOccupationalDiseasersResultManagerExample example = new PhcSuspectedOccupationalDiseasersResultManagerExample();
        example.createCriteria().andResultIdEqualTo(pid);
        this.managerMapper.deleteByExample(example);
        for (PhcSuspectedOccupationalDiseasersResultManager manager : managers) {
            if (manager.getManagerId() == null) continue;
            manager.setResultId(pid);
            this.managerMapper.insert(manager);
        }
    }

    public List<Integer> selectDiseasers(PhcSuspectedCheckResultVO vo) {
        return this.mapper.selectDiseasers(vo);
    }

    public List<PhcCheckResultDetail> listDiseasers(List<Integer> diseasers) {
        PhcCheckResultDetailExample example = new PhcCheckResultDetailExample();
        PhcCheckResultDetailExample.Criteria criteria = example.createCriteria();
        if (diseasers != null && diseasers.size() > 0) {
            criteria.andStaffIdIn((List)diseasers);
        }
        return this.mapper.selectByExample(example);
    }

    public Map<Integer, PhcCheckResultDetailStaffGroup> getDiseasersGroup(List<Integer> diseasers) {
        HashMap<Integer, PhcCheckResultDetailStaffGroup> staffMap = new HashMap<Integer, PhcCheckResultDetailStaffGroup>();
        List<PhcCheckResultDetail> details = this.listDiseasers(diseasers);
        if (details == null || details.size() == 0) {
            return staffMap;
        }
        for (PhcCheckResultDetail detail : details) {
            PhcCheckResultDetailWorkRoleGroup deptGroup;
            PhcCheckResultDetailDeptGroup staffDept;
            Integer staffId = detail.getStaffId();
            Integer deptId = detail.getCheckDeptId();
            Integer workRoleId = detail.getCheckWorkRoleId();
            PhcCheckResultDetailStaffGroup staff = (PhcCheckResultDetailStaffGroup)staffMap.get(detail.getStaffId());
            if (staff == null) {
                staff = new PhcCheckResultDetailStaffGroup();
                staff.setStaffId(staffId);
                staff.setStaffName(detail.getStaffName());
                staff.setStaffWorkNo(detail.getStaffWorkNo());
                staff.setCheckDepts(new HashMap<Integer, PhcCheckResultDetailDeptGroup>());
            }
            if ((staffDept = staff.getCheckDepts().get(deptId)) == null) {
                staffDept = new PhcCheckResultDetailDeptGroup();
                staffDept.setDeptId(detail.getCheckDeptId());
                staffDept.setDeptName(detail.getCheckDeptName());
                staffDept.setWorkRoles(new HashMap<Integer, PhcCheckResultDetailWorkRoleGroup>());
            }
            if ((deptGroup = staffDept.getWorkRoles().get(workRoleId)) == null) {
                deptGroup = new PhcCheckResultDetailWorkRoleGroup();
                deptGroup.setCheckDetail(new ArrayList<PhcCheckResultDetail>());
                deptGroup.setWorkRoleId(detail.getCheckWorkRoleId());
                deptGroup.setWorkRoleName(detail.getCheckWorkRoleName());
            }
            deptGroup.getCheckDetail().add(detail);
            staffDept.getWorkRoles().put(workRoleId, deptGroup);
            staff.getCheckDepts().put(deptId, staffDept);
            staffMap.put(staffId, staff);
        }
        return staffMap;
    }

    public PhcCheckResultDetail get(Integer id) {
        PhcCheckResultDetail detail = this.mapper.selectByPrimaryKey(id);
        detail.setResultManagers(this.getResultManagers(id));
        return detail;
    }

    public void delete(Integer id) {
        this.mapper.deleteByPrimaryKey(id);
    }

    public void updateInfo(PhcCheckResult data) {
        if (data == null) {
            return;
        }
        List<PhcCheckResultDetail> details = data.getDetails();
        if (details == null || details.size() == 0) {
            return;
        }
        for (PhcCheckResultDetail detail : details) {
            if (detail.getCheckResultId() != null || detail.getCheckType() == null) continue;
            detail.setStaffId(data.getStaffId());
            detail.setStaffName(data.getStaffName());
            detail.setStaffWorkNo(data.getStaffWorkNo());
            detail.setIsDisease("1");
            this.insertOrUpdate(detail);
        }
    }
}

