/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.physicalcheck;

import cn.smarthse.core.dao.PhysicalCheck.PhcPhysicalcheckMapper;
import cn.smarthse.core.dao.PhysicalCheck.PhcPhysicalcheckdataMapper;
import cn.smarthse.core.dao.PhysicalCheck.PhcPhysicalcheckdeptMapper;
import cn.smarthse.core.dao.PhysicalCheck.PhcPhysicalcheckfileMapper;
import cn.smarthse.core.dao.PhysicalCheck.PhcPhysicalcheckinformMapper;
import cn.smarthse.core.dao.PhysicalCheck.PhcPhysicalcheckworkflowMapper;
import cn.smarthse.core.dao.PhysicalCheck.PhcResultcomfirmMapper;
import cn.smarthse.core.dao.PhysicalCheck.PhcResultreportMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.framework.enums.PhysicalCheckFlow;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheck;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckExample;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckdata;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckdataExample;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckdataWithBLOBs;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckdept;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckdeptExample;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckfile;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckfileExample;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckinform;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckinformExample;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckworkflow;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckworkflowExample;
import cn.smarthse.core.model.PhysicalCheck.PhcResultcomfirm;
import cn.smarthse.core.model.PhysicalCheck.PhcResultcomfirmExample;
import cn.smarthse.core.model.PhysicalCheck.PhcResultreport;
import cn.smarthse.core.model.PhysicalCheck.PhcResultreportExample;
import cn.smarthse.core.model.PhysicalCheck.PhysicalCheckDataInfo;
import cn.smarthse.core.model.PhysicalCheck.PhysicalCheckDataVO;
import cn.smarthse.core.model.basic.Staff;
import cn.smarthse.core.model.flow.WfModularsWorkflow;
import cn.smarthse.core.model.flow.WfModularsWorkflowExample;
import cn.smarthse.core.model.vo.QueryPhysicalCheckParam;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.basic.staff.StaffService;
import cn.smarthse.core.service.workflow.IWorkflowService;
import cn.smarthse.core.service.workflow.ModularsWorkflowService;
import cn.smarthse.core.service.workflow.SnakerEngineFacets;
import cn.smarthse.core.util.LoginUtil;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PhysicalCheckService
implements IWorkflowService {
    @Autowired
    private PhcPhysicalcheckMapper PhcPhysicalcheckMapper;
    @Autowired
    private PhcPhysicalcheckdeptMapper PhcPhysicalcheckdeptMapper;
    @Autowired
    private PhcPhysicalcheckworkflowMapper PhcPhysicalcheckworkflowMapper;
    @Autowired
    private PhcPhysicalcheckdataMapper PhcPhysicalcheckdataMapper;
    @Autowired
    private PhcResultcomfirmMapper PhcResultcomfirmMapper;
    @Autowired
    private PhcResultreportMapper PhcResultreportMapper;
    @Autowired
    private PhcPhysicalcheckfileMapper PhcPhysicalcheckfileMapper;
    @Autowired
    private ModularsWorkflowService workflowService;
    @Autowired
    private PhcPhysicalcheckinformMapper informMapper;
    @Autowired
    private StaffService staffService;
    @Autowired
    private SnakerEngineFacets facets;

    public PhcPhysicalcheck get(int id) {
        PhcPhysicalcheck check = this.PhcPhysicalcheckMapper.selectWithDetail(id);
        List<PhcPhysicalcheckworkflow> list = check.getFlowList();
        if (list.isEmpty()) {
            PhcPhysicalcheckworkflow flow = new PhcPhysicalcheckworkflow();
            flow.setPhase(PhysicalCheckFlow.plan.getValue());
            flow.setStatus(1);
            check.setFlow(flow);
        } else {
            PhcPhysicalcheckworkflow f = list.get(list.size() - 1);
            check.setFlow(f);
        }
        return check;
    }

    public int create(PhcPhysicalcheck record) {
        record.setUpdatetime(new Date());
        record.setIsvalid(Constant.ACTIVE_YES);
        this.PhcPhysicalcheckMapper.insertSelective(record);
        PhcPhysicalcheckworkflow flow = new PhcPhysicalcheckworkflow();
        flow.setCheckid(record.getId());
        flow.setStatus(1);
        flow.setPhase(1);
        this.updateWorkFlow(flow);
        this.updatePhysicalcheckdept(record);
        this.updatePhysicalcheckfile(record);
        return record.getId();
    }

    public int delete(Integer id) {
        PhcPhysicalcheck a = new PhcPhysicalcheck();
        a.setId(id);
        a.setUpdatetime(new Date());
        a.setIsvalid(Constant.ACTIVE_NO);
        return this.PhcPhysicalcheckMapper.updateByPrimaryKeySelective(a);
    }

    public int update(PhcPhysicalcheck record) {
        PhcPhysicalcheckdeptExample e = new PhcPhysicalcheckdeptExample();
        e.or().andCheckidEqualTo(record.getId());
        this.updatePhysicalcheckdept(record);
        this.updatePhysicalcheckfile(record);
        record.setUpdatetime(new Date());
        return this.PhcPhysicalcheckMapper.updateByPrimaryKeySelective(record);
    }

    private void updatePhysicalcheckdept(PhcPhysicalcheck record) {
        PhcPhysicalcheckdeptExample example = new PhcPhysicalcheckdeptExample();
        PhcPhysicalcheckdeptExample.Criteria criteria = example.createCriteria();
        criteria.andCheckidEqualTo(record.getId());
        this.PhcPhysicalcheckdeptMapper.deleteByExample(example);
        List<PhcPhysicalcheckdept> list = record.getCheckDeptList();
        if (list != null) {
            for (PhcPhysicalcheckdept a : list) {
                if (a.getDeptid() == null) continue;
                a.setCheckid(record.getId());
                this.PhcPhysicalcheckdeptMapper.insertSelective(a);
            }
        }
    }

    private void updatePhysicalcheckfile(PhcPhysicalcheck record) {
        PhcPhysicalcheckfileExample example = new PhcPhysicalcheckfileExample();
        PhcPhysicalcheckfileExample.Criteria criteria = example.createCriteria();
        criteria.andCheckidEqualTo(record.getId());
        this.PhcPhysicalcheckfileMapper.deleteByExample(example);
        List<PhcPhysicalcheckfile> list = record.getCheckFiles();
        if (list != null && list.size() > 0) {
            for (PhcPhysicalcheckfile a : list) {
                if (a.getType() == null) continue;
                a.setCheckid(record.getId());
                this.PhcPhysicalcheckfileMapper.insertSelective(a);
            }
        }
    }

    @Transactional(readOnly=false)
    public int updateDept(PhcPhysicalcheckdept record) {
        if (record.getId() == null) {
            return this.PhcPhysicalcheckdeptMapper.insertSelective(record);
        }
        return this.PhcPhysicalcheckdeptMapper.updateByPrimaryKeySelective(record);
    }

    public List<PhcPhysicalcheck> list(QueryPhysicalCheckParam param) {
        List<PhcPhysicalcheck> checkList = this.PhcPhysicalcheckMapper.list(param);
        for (PhcPhysicalcheck a : checkList) {
            PhcPhysicalcheckworkflow flow;
            List<PhcPhysicalcheckworkflow> list = a.getFlowList();
            if (list.isEmpty()) {
                flow = new PhcPhysicalcheckworkflow();
                flow.setPhase(1);
                flow.setStatus((int)Constant.STATUS_EDIT);
                a.setFlow(flow);
                continue;
            }
            flow = list.get(list.size() - 1);
            a.setFlow(flow);
        }
        return checkList;
    }

    public List<PhcPhysicalcheck> queryCheck(QueryPhysicalCheckParam param) {
        PhcPhysicalcheckExample e = new PhcPhysicalcheckExample();
        PhcPhysicalcheckExample.Criteria c = e.createCriteria();
        c.andCidEqualTo(param.getCid());
        if (param.getBegin() != null) {
            c.andEndtimeGreaterThanOrEqualTo(param.getBegin());
        }
        if (param.getEnd() != null) {
            c.andBegintimeLessThanOrEqualTo(param.getEnd());
        }
        if (StringUtils.isNotEmpty(param.getCheckNo())) {
            c.andChecknoLike("%" + param.getCheckNo() + "%");
        }
        if (param.getType() != null) {
            c.andTypeLike("%" + param.getType() + "%");
        }
        if (param.getDocbegin() != null) {
            c.andUpdatetimeGreaterThanOrEqualTo(param.getDocbegin());
        }
        if (param.getEnd() != null) {
            c.andUpdatetimeLessThanOrEqualTo(param.getEnd());
        }
        e.setOrderByClause("updateTime desc");
        List<PhcPhysicalcheck> checkList = this.PhcPhysicalcheckMapper.selectByExampleWithDetail(e);
        if (param.getDeptList() != null) {
            for (PhcPhysicalcheck a : checkList) {
                List<PhcPhysicalcheckdept> deptList = a.getCheckDeptList();
                boolean flag = false;
                for (PhcPhysicalcheckdept b : deptList) {
                    if (!param.getDeptList().contains(b.getDeptid())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                checkList.remove(a);
            }
        }
        if (param.getStatus() != null) {
            for (PhcPhysicalcheck a : checkList) {
                PhcPhysicalcheckworkflow flow = null;
                List<PhcPhysicalcheckworkflow> flowList = a.getFlowList();
                if (flowList.isEmpty()) continue;
                flow = flowList.get(flowList.size() - 1);
                boolean flag = flow.getStatus().equals(param.getStatus());
                if (param.getStatus().equals(Constant.STATUS_UNFINISH) && !flow.getStatus().equals(Constant.STATUS_FINISH)) {
                    flag = true;
                }
                if (flag) continue;
                checkList.remove(a);
            }
        }
        for (PhcPhysicalcheck a : checkList) {
            List<PhcPhysicalcheckworkflow> list = a.getFlowList();
            if (list.isEmpty()) {
                PhcPhysicalcheckworkflow flow = new PhcPhysicalcheckworkflow();
                flow.setPhase(1);
                flow.setStatus((int)Constant.STATUS_EDIT);
                a.setFlow(flow);
                continue;
            }
            PhcPhysicalcheckworkflow flow = list.get(list.size() - 1);
            a.setFlow(flow);
        }
        return checkList;
    }

    public List<PhcPhysicalcheck> queryCheck(Integer cid, Boolean finish) {
        QueryPhysicalCheckParam p = new QueryPhysicalCheckParam();
        p.setCid(cid);
        if (finish != null && !finish.booleanValue()) {
            p.setStatus((int)Constant.STATUS_UNFINISH);
        } else {
            p.setStatus((int)Constant.STATUS_FINISH);
        }
        return this.queryCheck(p);
    }

    public List<PhcPhysicalcheck> queryCheck(Integer cid, Boolean finish, Integer pageNum, Integer pageSize) {
        QueryPhysicalCheckParam p = new QueryPhysicalCheckParam();
        p.setCid(cid);
        if (finish == null || !finish.booleanValue()) {
            p.setStatus((int)Constant.STATUS_UNFINISH);
        } else {
            p.setStatus((int)Constant.STATUS_FINISH);
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return this.queryCheck(p);
    }

    public List<PhcPhysicalcheck> queryCheck(QueryPhysicalCheckParam p, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return this.list(p);
    }

    public List<PhcPhysicalcheck> listByQuery(QueryPhysicalCheckParam p) {
        return this.list(p);
    }

    public List<PhcResultcomfirm> queryConfirm(QueryPhysicalCheckParam param) {
        QueryPhysicalCheckParam p = new QueryPhysicalCheckParam();
        p.setCid(param.getCid());
        p.setCheckNo(param.getCheckNo());
        List<PhcPhysicalcheck> checkList = this.queryCheck(p);
        ArrayList<Integer> checkIdList = new ArrayList<Integer>();
        for (PhcPhysicalcheck a : checkList) {
            checkIdList.add(a.getId());
        }
        if (checkIdList.size() == 0) {
            return new ArrayList<PhcResultcomfirm>();
        }
        PhcPhysicalcheckdataExample e2 = new PhcPhysicalcheckdataExample();
        e2.or().andCheckidIn(checkIdList);
        List<PhcPhysicalcheckdata> dataList = this.PhcPhysicalcheckdataMapper.selectByExample(e2);
        ArrayList<Integer> dataIdList = new ArrayList<Integer>();
        for (PhcPhysicalcheckdata a : dataList) {
            dataIdList.add(a.getId());
        }
        if (dataIdList.size() == 0) {
            return new ArrayList<PhcResultcomfirm>();
        }
        PhcResultcomfirmExample e3 = new PhcResultcomfirmExample();
        PhcResultcomfirmExample.Criteria c3 = e3.createCriteria();
        c3.andDataidIn(dataIdList);
        if (param.getBegin() != null) {
            c3.andConfirmtimeGreaterThanOrEqualTo(param.getBegin());
        }
        if (param.getEnd() != null) {
            c3.andConfirmtimeLessThanOrEqualTo(param.getEnd());
        }
        List<PhcResultcomfirm> comfirmList = this.PhcResultcomfirmMapper.selectByExample(e3);
        return comfirmList;
    }

    public PhcResultreport getReport(int id) {
        return this.PhcResultreportMapper.selectByPrimaryKey(id);
    }

    public int createReport(PhcResultreport record) {
        record.setIsvalid(Constant.ACTIVE_YES);
        record.setReporttime(new Date());
        this.PhcResultreportMapper.insertSelective(record);
        return record.getId();
    }

    public int deleteReport(Integer id) {
        PhcResultreport a = new PhcResultreport();
        a.setId(id);
        a.setIsvalid(Constant.ACTIVE_NO);
        return this.PhcResultreportMapper.updateByPrimaryKeySelective(a);
    }

    public int updateReport(PhcResultreport record) {
        record.setUpdatetime(new Date());
        return this.PhcResultreportMapper.updateByPrimaryKeySelective(record);
    }

    public List<PhcResultreport> queryReport(QueryPhysicalCheckParam param) {
        List<PhcPhysicalcheck> checkList = this.queryCheck(param);
        ArrayList<Integer> checkIdList = new ArrayList<Integer>();
        for (PhcPhysicalcheck a : checkList) {
            checkIdList.add(a.getId());
        }
        if (checkIdList.size() == 0) {
            return new ArrayList<PhcResultreport>();
        }
        PhcResultreportExample e = new PhcResultreportExample();
        PhcResultreportExample.Criteria c = e.createCriteria();
        c.andIsvalidEqualTo(Constant.ACTIVE_YES).andCheckidIn(checkIdList);
        return this.PhcResultreportMapper.selectByExample(e);
    }

    public List<PhcResultreport> queryReport(QueryPhysicalCheckParam param, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return this.queryReport(param);
    }

    public List<PhcResultreport> queryReport(Integer cid, Integer pageNum, Integer pageSize) {
        QueryPhysicalCheckParam p = new QueryPhysicalCheckParam();
        p.setCid(cid);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return this.queryReport(p);
    }

    public List<PhcResultreport> getAllReport(Integer cid) {
        QueryPhysicalCheckParam p = new QueryPhysicalCheckParam();
        p.setCid(cid);
        return this.queryReport(p);
    }

    public int updateWorkFlow(PhcPhysicalcheckworkflow record) {
        if (record.getId() == null) {
            return this.PhcPhysicalcheckworkflowMapper.insertSelective(record);
        }
        return this.PhcPhysicalcheckworkflowMapper.updateByPrimaryKeySelective(record);
    }

    private PhcPhysicalcheckworkflow setStatus(PhcPhysicalcheckworkflow flow) {
        switch (flow.getPhase().byteValue()) {
            case 1: {
                flow.setPhase(2);
                flow.setStatus(1);
                break;
            }
            case 2: {
                flow.setPhase(2);
                flow.setStatus(1);
                break;
            }
            case 3: {
                flow.setPhase(4);
                flow.setStatus(1);
                break;
            }
            case 4: {
                flow.setPhase(5);
                flow.setStatus(1);
                break;
            }
            case 5: {
                flow.setPhase(6);
                flow.setStatus(1);
                break;
            }
            case 6: {
                flow.setPhase(6);
                flow.setStatus(2);
                break;
            }
        }
        return flow;
    }

    @Override
    public void workflow(WorkFlowParam param, Integer orderId) {
        PhcPhysicalcheck record = this.get(param.getBusinessId());
        PhcPhysicalcheckworkflow flow = record.getFlow();
        if (flow == null) {
            flow = new PhcPhysicalcheckworkflow();
            flow.setPhase(2);
            flow.setStatus(1);
        }
        flow.setCheckid(param.getBusinessId());
        flow.setWorkflowid(orderId);
        if (param.getNeedfeedback() != null && param.getNeedfeedback().booleanValue()) {
            List<PhcPhysicalcheckdept> list = record.getCheckDeptList();
            for (PhcPhysicalcheckdept a : list) {
                if (!a.getDeptmanager().equals(Integer.valueOf(param.getReceiver()))) continue;
                a.setFeedbacktime(new Date());
                a.setSuggestion(param.getRemark());
                if (param.getApproved().booleanValue()) {
                    a.setIsagreed((byte)1);
                } else {
                    a.setIsagreed((byte)0);
                }
                this.updateDept(a);
                this.setStatus(flow);
                this.updateWorkFlow(flow);
                break;
            }
            return;
        }
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            this.setStatus(flow);
        }
        this.updateWorkFlow(flow);
    }

    public String getBusinessPath(Integer businessId, Boolean isApprove) {
        PhcPhysicalcheck record = this.get(businessId);
        Integer phase = (int)record.getFlow().getPhase();
        PhysicalCheckFlow phaseFlow = PhysicalCheckFlow.getPhysicalCheckFlowByValue(phase);
        String code = "plan";
        if (phaseFlow != null && StringUtils.isNotEmpty(phaseFlow.getCode())) {
            code = phaseFlow.getCode();
        }
        if (isApprove.booleanValue()) {
            return "forward:/phc/" + code + "?approve=1" + "&id=" + businessId;
        }
        return "forward:/phc/" + code + "?approve=0" + "&id=" + businessId;
    }

    public String getInformPath(Integer businessId) {
        return "forward:/phc/inform?id=" + businessId;
    }

    public void finish(PhcPhysicalcheck detail) {
        this.PhcPhysicalcheckMapper.finish(detail);
    }

    public void endFlow(String checkids) {
        List<Integer> ids = StringUtils.parseToIntegerList(checkids);
        if (ids == null || ids.size() == 0) {
            return;
        }
        PhcPhysicalcheckworkflowExample example = new PhcPhysicalcheckworkflowExample();
        PhcPhysicalcheckworkflowExample.Criteria criteria = example.createCriteria();
        criteria.andCheckidIn((List)ids);
        PhcPhysicalcheckworkflow flow = new PhcPhysicalcheckworkflow();
        flow.setStatus(2);
        this.PhcPhysicalcheckworkflowMapper.updateByExampleSelective(flow, example);
    }

    public boolean isCheckPassed(Integer businessId, String businessType, Byte stageId, Byte stageStatus) {
        boolean flag = false;
        WfModularsWorkflowExample example = new WfModularsWorkflowExample();
        WfModularsWorkflowExample.Criteria criteria = example.createCriteria();
        criteria.andBusinessidEqualTo(businessId);
        criteria.andBusinesstypeEqualTo(businessType);
        criteria.andStageIdEqualTo(stageId);
        criteria.andProcessstateEqualTo(stageStatus);
        List<WfModularsWorkflow> flows = this.workflowService.getWfModularsWorkflowListByExample(example);
        if (flows != null && flows.size() > 0) {
            flag = true;
        }
        return flag;
    }

    public void deleteInform(Integer checkid) {
        this.informMapper.deleteByCheckId(checkid);
    }

    public void addInform(Integer staffid, Integer checkid, Integer orderId) {
        PhcPhysicalcheckinform record = new PhcPhysicalcheckinform();
        record.setDeptmanager(staffid);
        record.setInformtime(new Date());
        record.setCheckid(checkid);
        this.informMapper.insert(record);
    }

    @Transactional(readOnly=false)
    public void updateForInitiateInform(WorkFlowParam param, Integer orderId) {
        String[] recover = param.getReceiver().split(",");
        this.deleteInform(param.getBusinessId());
        if (recover != null) {
            String[] stringArray = recover;
            int n = recover.length;
            int n2 = 0;
            while (n2 < n) {
                Staff staff;
                String rec = stringArray[n2];
                if (StringUtils.isNumber(rec) && (staff = this.staffService.get(Integer.valueOf(rec))) != null) {
                    this.addInform(staff.getId(), param.getBusinessId(), orderId);
                }
                ++n2;
            }
        }
        if (!param.getNeedfeedback().booleanValue()) {
            PhcPhysicalcheckworkflow record = new PhcPhysicalcheckworkflow();
            record.setCheckid(param.getBusinessId());
            record.setPhase(3);
            record.setStatus(1);
            record.setWorkflowid(orderId);
            this.updateWorkFlow(record);
        }
    }

    @Transactional(readOnly=false)
    public void InitiateFeedback(WorkFlowParam param, PhcPhysicalcheckinform feedback) {
        Map<String, Object> paramMap = param.getparamMap();
        Staff staff = this.staffService.selectByUserId(Integer.valueOf(param.getReceiver()));
        if (staff != null) {
            PhcPhysicalcheckinformExample example = new PhcPhysicalcheckinformExample();
            PhcPhysicalcheckinformExample.Criteria criteria = example.createCriteria();
            criteria.andCheckidEqualTo(param.getBusinessId());
            criteria.andDeptmanagerEqualTo(staff.getId());
            feedback.setFeedbacktime(new Date());
            this.informMapper.updateByExampleSelective(feedback, example);
        }
        this.facets.execute(param.getTaskId(), "" + LoginUtil.getInstance().getLoginStaffInfo().getId(), paramMap);
    }

    public List<PhcPhysicalcheckinform> getInforms(Integer checkid) {
        PhcPhysicalcheckinformExample example = new PhcPhysicalcheckinformExample();
        PhcPhysicalcheckinformExample.Criteria criteria = example.createCriteria();
        criteria.andCheckidEqualTo(checkid);
        return this.informMapper.selectByExample(example);
    }

    public List<PhysicalCheckDataInfo> selectDetailsByQuery(PhysicalCheckDataVO vo) {
        return this.PhcPhysicalcheckdataMapper.selectDetailsByQuery(vo);
    }

    public List<PhcPhysicalcheckdataWithBLOBs> selectDataDetailByCheckId(PhysicalCheckDataVO vo) {
        return this.PhcPhysicalcheckdataMapper.selectDataDetailByCheckId(vo);
    }

    @Override
    public String workflowInform(WorkFlowParam param, Integer orderId) {
        String[] recover = param.getReceiver().split(",");
        this.deleteInform(param.getBusinessId());
        if (recover != null) {
            String[] stringArray = recover;
            int n = recover.length;
            int n2 = 0;
            while (n2 < n) {
                Staff staff;
                String rec = stringArray[n2];
                if (StringUtils.isNumber(rec) && (staff = this.staffService.get(Integer.valueOf(rec))) != null) {
                    this.addInform(staff.getId(), param.getBusinessId(), orderId);
                }
                ++n2;
            }
        }
        if (!param.getNeedfeedback().booleanValue()) {
            PhcPhysicalcheckworkflow record = new PhcPhysicalcheckworkflow();
            record.setCheckid(param.getBusinessId());
            record.setPhase(3);
            record.setStatus(1);
            record.setWorkflowid(orderId);
            this.updateWorkFlow(record);
        }
        return null;
    }

    @Override
    public String doTask(Integer businessId, String taskName) {
        if ("approve".equals(taskName)) {
            return this.getBusinessPath(businessId, true);
        }
        return this.getBusinessPath(businessId, true);
    }

    @Override
    public String doApproveTask(Integer businessId) {
        return null;
    }

    @Override
    public int terminateTask(Integer businessId) {
        return 0;
    }

    @Override
    public String addWorkUrl() {
        return null;
    }
}

