/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.physicalcheck;

import cn.smarthse.core.dao.PhysicalCheck.PhcPhysicalcheckresultMapper;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckresult;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckresultExample;
import cn.smarthse.core.model.PhysicalCheck.PhcSuspectedCheckResult;
import cn.smarthse.core.model.PhysicalCheck.PhcSuspectedCheckResultDetail;
import cn.smarthse.core.model.PhysicalCheck.PhcSuspectedCheckResultVO;
import cn.smarthse.core.model.PhysicalCheck.PhysicalCheckDataResult;
import cn.smarthse.core.model.PhysicalCheck.PhysicalCheckDataResultCount;
import cn.smarthse.core.model.PhysicalCheck.PhysicalCheckDataVO;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcSuspectedOccupationalDiseasers;
import cn.smarthse.core.model.PhysicalCheck.diseasers.PhcSuspectedOccupationalDiseasersResult;
import cn.smarthse.core.service.physicalcheck.diseasers.PhcCheckResultDetailService;
import cn.smarthse.core.service.physicalcheck.diseasers.PhcSuspectedOccupationalDiseasersResultService;
import cn.smarthse.core.service.physicalcheck.diseasers.PhcSuspectedOccupationalDiseasersService;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhysicalCheckResultService {
    @Autowired
    private PhcPhysicalcheckresultMapper mapper;
    @Autowired
    private PhcSuspectedOccupationalDiseasersService diseasersService;
    @Autowired
    private PhcSuspectedOccupationalDiseasersResultService resultService;
    @Autowired
    private PhcCheckResultDetailService detalService;

    public PhcPhysicalcheckresult get(int id) {
        PhcPhysicalcheckresult check = this.mapper.selectByPrimaryKey(id);
        return check;
    }

    public List<PhcPhysicalcheckresult> list(PhcPhysicalcheckresult result) {
        PhcPhysicalcheckresultExample example = new PhcPhysicalcheckresultExample();
        PhcPhysicalcheckresultExample.Criteria criteria = example.createCriteria();
        if (result.getDataid() != null) {
            criteria.andDataidEqualTo(result.getDataid());
        }
        if (result.getExamresult() != null) {
            criteria.andExamresultEqualTo(result.getExamresult());
        }
        return this.mapper.selectByExample(example);
    }

    public int create(PhcPhysicalcheckresult record) {
        this.mapper.insertSelective(record);
        return record.getId();
    }

    public List<PhcPhysicalcheckresult> queryListByDataIdAndExamResult(Integer dataId, Byte examResult) {
        PhcPhysicalcheckresultExample example = new PhcPhysicalcheckresultExample();
        PhcPhysicalcheckresultExample.Criteria criteria = example.createCriteria();
        if (dataId != null) {
            criteria.andDataidEqualTo(dataId);
        }
        if (examResult != null) {
            criteria.andExamresultEqualTo(examResult);
        }
        return this.mapper.selectByExample(example);
    }

    public int update(PhcPhysicalcheckresult record) {
        this.mapper.updateByPrimaryKeySelective(record);
        return 1;
    }

    public void copyResultToSuspectedOccupationalDiseasers(Integer dataId) {
        this.diseasersService.deleteByCheckDataId(dataId);
        List<PhcPhysicalcheckresult> resultList = this.queryListByDataIdAndExamResult(dataId, (byte)3);
        if (resultList == null || resultList.size() == 0) {
            return;
        }
        List<PhcSuspectedOccupationalDiseasers> diseasers = this.mapper.selectDiseasersInfoByDataId(dataId);
        if (diseasers == null || diseasers.size() == 0) {
            return;
        }
        PhcSuspectedOccupationalDiseasers diseaser = diseasers.get(0);
        diseaser.setPhase("1");
        diseaser.setStatus("0");
        this.addDiseaserResults(diseaser, resultList);
    }

    private void addDiseaserResults(PhcSuspectedOccupationalDiseasers diseaser, List<PhcPhysicalcheckresult> resultList) {
        for (PhcPhysicalcheckresult result : resultList) {
            this.diseasersService.insert(diseaser);
            PhcSuspectedOccupationalDiseasersResult diseaserResult = new PhcSuspectedOccupationalDiseasersResult();
            diseaserResult.setDiseaserId(diseaser.getId());
            diseaserResult.setCheckResultId(result.getId());
            diseaserResult.setSuspectedName(result.getHarmdesc());
            diseaserResult.setHarmYear(result.getHarmyear());
            diseaserResult.setHarm(String.valueOf(result.getHarmfactor()));
            diseaserResult.setIsSure(String.valueOf(result.getIssure()));
            this.resultService.insert(diseaserResult);
        }
    }

    public List<PhcPhysicalcheckresult> selectCheckResultByResult(PhcPhysicalcheckresult result) {
        return this.mapper.selectCheckResultByResult(result);
    }

    public void deleteByIds(List<Integer> idList) {
        if (idList == null || idList.size() == 0) {
            return;
        }
        PhcPhysicalcheckresultExample example = new PhcPhysicalcheckresultExample();
        PhcPhysicalcheckresultExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)idList);
        this.mapper.deleteByExample(example);
    }

    public void deleteByInfo(PhcPhysicalcheckresult result) {
        PhcPhysicalcheckresultExample example = new PhcPhysicalcheckresultExample();
        PhcPhysicalcheckresultExample.Criteria criteria = example.createCriteria();
        if (result.getDataid() != null) {
            criteria.andDataidEqualTo(result.getDataid());
        }
        this.mapper.deleteByExample(example);
    }

    public void setSure(Integer id, Byte issure) {
        PhcPhysicalcheckresult record = new PhcPhysicalcheckresult();
        record.setId(id);
        record.setIssure(issure);
        this.mapper.updateByPrimaryKeySelective(record);
    }

    public List<PhysicalCheckDataResult> selectDetailsByQuery(PhysicalCheckDataVO vo) {
        return this.mapper.selectDetailsByQuery(vo);
    }

    public PhysicalCheckDataResultCount countSelectDetails(PhysicalCheckDataVO vo) {
        PhysicalCheckDataResultCount count = new PhysicalCheckDataResultCount();
        List<PhysicalCheckDataResult> results = this.selectDetailsByQuery(vo);
        if (results == null) {
            return count;
        }
        HashMap<Integer, String> suspectedStaff = new HashMap<Integer, String>();
        HashMap<Integer, String> sureStaff = new HashMap<Integer, String>();
        for (PhysicalCheckDataResult result : results) {
            if (!"3".equals(result.getExamResult())) continue;
            if (result.getIsSure() == 0) {
                suspectedStaff.put(result.getStaffId(), result.getUserName());
                continue;
            }
            sureStaff.put(result.getStaffId(), result.getUserName());
        }
        count.setSureStaff(sureStaff);
        count.setSuspectedStaff(suspectedStaff);
        return count;
    }

    public List<PhcSuspectedCheckResult> selectSuspectedCheckResult(PhcSuspectedCheckResultVO vo) {
        return this.mapper.selectSuspectedCheckResult(vo);
    }

    public PhcSuspectedCheckResultDetail selectSuspectedCheckResultDetail(Integer id) {
        PhcSuspectedCheckResultDetail result = this.mapper.selectSuspectedCheckResultDetail(id);
        result.setResultDetail(this.detalService.getByCheckResultId(id));
        return result;
    }
}

