/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.physicalcheck;

import cn.smarthse.core.dao.PhysicalCheck.PhcPhysicalcheckdataMapper;
import cn.smarthse.core.dao.PhysicalCheck.PhcPhysicalcheckdeptMapper;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckdata;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckdataExample;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckdataWithBLOBs;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckdept;
import cn.smarthse.core.model.PhysicalCheck.PhcPhysicalcheckdeptExample;
import cn.smarthse.core.model.PhysicalCheck.PhysicalCheckDataInfo;
import cn.smarthse.core.model.PhysicalCheck.PhysicalCheckDataVO;
import cn.smarthse.core.model.basic.Staff;
import cn.smarthse.core.model.basic.Staffworkrole;
import cn.smarthse.core.service.basic.staff.StaffService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PhysicalCheckDataService {
    @Autowired
    PhcPhysicalcheckdataMapper PhcPhysicalcheckdataMapper;
    @Autowired
    PhcPhysicalcheckdeptMapper PhcPhysicalcheckdeptMapper;
    @Autowired
    StaffService staffService;

    public PhcPhysicalcheckdataWithBLOBs get(int id) {
        PhcPhysicalcheckdataWithBLOBs check = this.PhcPhysicalcheckdataMapper.selectByPrimaryKey(id);
        return check;
    }

    public int create(PhcPhysicalcheckdataWithBLOBs record) {
        this.PhcPhysicalcheckdataMapper.insertSelective(record);
        return record.getId();
    }

    @Transactional
    public int create(List<Integer> staffList, Integer checkid, Byte type) {
        int count = 0;
        for (Integer staffid : staffList) {
            PhcPhysicalcheckdataWithBLOBs a = new PhcPhysicalcheckdataWithBLOBs();
            a.setStaffid(staffid);
            a.setCheckid(checkid);
            a.setChecktype(type);
            a.setIsfinished((byte)1);
            Staff staff = this.staffService.get(staffid);
            if (staff != null) {
                Staffworkrole staffworkrole = staff.getStaffworkrole();
                if (staffworkrole != null) {
                    a.setStaffworkroleid(staffworkrole.getRid());
                }
                a.setStaffDeptId(staff.getOrgid());
            }
            count += this.PhcPhysicalcheckdataMapper.insertSelective(a);
        }
        return count;
    }

    public int update(PhcPhysicalcheckdataWithBLOBs record) {
        return this.PhcPhysicalcheckdataMapper.updateByPrimaryKeySelective(record);
    }

    public Map<String, Object> getInformTotal(int checkid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long total = 0L;
        Long unfeedback = 0L;
        Long disagree = 0L;
        List<Map<String, Object>> list = this.PhcPhysicalcheckdeptMapper.selectInformTotal(checkid);
        for (Map<String, Object> m : list) {
            total = total + (Long)m.get("total");
            if (m.get("isAgreed") == null) {
                unfeedback = unfeedback + (Long)m.get("total");
                continue;
            }
            if (!m.get("isAgreed").equals("0")) continue;
            disagree = disagree + (Long)m.get("total");
        }
        map.put("informTime", list.get(0).get("informTime"));
        map.put("beginTime", list.get(0).get("beginTime"));
        map.put("endTime", list.get(0).get("endTime"));
        map.put("total", total.toString());
        map.put("unfeedback", unfeedback.toString());
        map.put("disagree", disagree.toString());
        return map;
    }

    public List<PhcPhysicalcheckdept> getInformDetail(Integer checkid, Integer isAgreed) {
        PhcPhysicalcheckdeptExample e = new PhcPhysicalcheckdeptExample();
        PhcPhysicalcheckdeptExample.Criteria c = e.createCriteria();
        c.andCheckidEqualTo(checkid);
        if (isAgreed == null) {
            c.andIsagreedIsNull();
        } else {
            if (isAgreed == 1) {
                c.andIsagreedEqualTo((byte)1);
            }
            if (isAgreed == 0) {
                c.andIsagreedEqualTo((byte)0);
            }
        }
        return this.PhcPhysicalcheckdeptMapper.selectByExample(e);
    }

    public List<PhcPhysicalcheckdataWithBLOBs> selectByExampleWithBLOBs(PhcPhysicalcheckdata data) {
        PhcPhysicalcheckdataExample example = new PhcPhysicalcheckdataExample();
        PhcPhysicalcheckdataExample.Criteria criteria = example.createCriteria();
        if (data.getCheckid() != null) {
            criteria.andCheckidEqualTo(data.getCheckid());
        }
        if (data.getChecktype() != null) {
            criteria.andChecktypeEqualTo(data.getChecktype());
        }
        if (data.getIsfinished() != null) {
            criteria.andIsfinishedEqualTo(data.getIsfinished());
        }
        return this.PhcPhysicalcheckdataMapper.selectByExampleWithBLOBs(example);
    }

    public List<PhcPhysicalcheckdataWithBLOBs> selectByQuery(PhysicalCheckDataVO vo) {
        return this.PhcPhysicalcheckdataMapper.selectByQuery(vo);
    }

    public List<PhysicalCheckDataInfo> selectDetailsByQuery(PhysicalCheckDataVO vo) {
        return this.PhcPhysicalcheckdataMapper.selectDetailsByQuery(vo);
    }

    public void deleteByIds(List<Integer> idList) {
        if (idList == null || idList.size() == 0) {
            return;
        }
        PhcPhysicalcheckdataExample example = new PhcPhysicalcheckdataExample();
        PhcPhysicalcheckdataExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)idList);
        this.PhcPhysicalcheckdataMapper.deleteByExample(example);
    }

    public void deleteByInfo(List<Integer> staffIdList, Integer checkid, Byte type) {
        if (staffIdList == null || staffIdList.size() == 0) {
            return;
        }
        PhcPhysicalcheckdataExample example = new PhcPhysicalcheckdataExample();
        PhcPhysicalcheckdataExample.Criteria criteria = example.createCriteria();
        criteria.andStaffidIn((List)staffIdList);
        criteria.andCheckidEqualTo(checkid);
        criteria.andChecktypeEqualTo(type);
        this.PhcPhysicalcheckdataMapper.deleteByExample(example);
    }

    public void setCheck(List<Integer> ids, Byte isfinished) {
        PhcPhysicalcheckdataExample example = new PhcPhysicalcheckdataExample();
        PhcPhysicalcheckdataExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)ids);
        PhcPhysicalcheckdataWithBLOBs record = new PhcPhysicalcheckdataWithBLOBs();
        record.setIsfinished(isfinished);
        this.PhcPhysicalcheckdataMapper.updateByExampleSelective(record, example);
    }
}

