/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.physicalcheck;

import cn.smarthse.core.dao.PhysicalCheck.PhcSuspectedOccupationalDiseaseManagerMapper;
import cn.smarthse.core.dao.PhysicalCheck.PhcSuspectedOccupationalDiseaseReportMapper;
import cn.smarthse.core.dao.PhysicalCheck.PhcSuspectedOccupationalDiseaserMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.model.PhysicalCheck.PhcSuspectedOccupationalDiseaseManager;
import cn.smarthse.core.model.PhysicalCheck.PhcSuspectedOccupationalDiseaseManagerExample;
import cn.smarthse.core.model.PhysicalCheck.PhcSuspectedOccupationalDiseaseReport;
import cn.smarthse.core.model.PhysicalCheck.PhcSuspectedOccupationalDiseaseReportExample;
import cn.smarthse.core.model.PhysicalCheck.PhcSuspectedOccupationalDiseaseReportVO;
import cn.smarthse.core.model.PhysicalCheck.PhcSuspectedOccupationalDiseaser;
import cn.smarthse.core.model.PhysicalCheck.PhcSuspectedOccupationalDiseaserExample;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhcSuspectedOccupationalDiseaseReportService {
    @Autowired
    PhcSuspectedOccupationalDiseaseReportMapper mapper;
    @Autowired
    PhcSuspectedOccupationalDiseaserMapper diseaserMapper;
    @Autowired
    PhcSuspectedOccupationalDiseaseManagerMapper managerMapper;

    public List<PhcSuspectedOccupationalDiseaseReport> list(PhcSuspectedOccupationalDiseaseReportVO vo) {
        PhcSuspectedOccupationalDiseaseReportExample example = new PhcSuspectedOccupationalDiseaseReportExample();
        PhcSuspectedOccupationalDiseaseReportExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty(vo.getCreateByName())) {
            criteria.andCreateByNameLike("%" + vo.getCreateByName() + "%");
        }
        if (vo.getReportTimeBegin() != null && vo.getReportTimeEnd() != null) {
            criteria.andReportTimeBetween(vo.getReportTimeBegin(), vo.getReportTimeEnd());
        }
        if (vo.getCheckBeginTime() != null) {
            criteria.andCheckBeginTimeLessThanOrEqualTo(vo.getCheckBeginTime());
        }
        if (vo.getCheckEndTime() != null) {
            criteria.andCheckEndTimeGreaterThanOrEqualTo(vo.getCheckEndTime());
        }
        return this.mapper.selectByExample(example);
    }

    public PhcSuspectedOccupationalDiseaseReport get(Integer id) {
        return this.mapper.selectDetailById(id);
    }

    public void updateChildren(PhcSuspectedOccupationalDiseaseReport report) {
        this.updateDiseasers(report.getId(), report.getDiseasers());
        this.updateManagers(report.getId(), report.getManagers());
    }

    public void updateDiseasers(Integer reportId, List<PhcSuspectedOccupationalDiseaser> diseasers) {
        this.deleteDiseasers(reportId);
        if (diseasers == null || diseasers.size() == 0) {
            return;
        }
        for (PhcSuspectedOccupationalDiseaser d : diseasers) {
            if (d.getDiseaserId() == null) continue;
            d.setReportId(reportId);
            this.diseaserMapper.insert(d);
        }
    }

    public void deleteDiseasers(Integer reportId) {
        PhcSuspectedOccupationalDiseaserExample example = new PhcSuspectedOccupationalDiseaserExample();
        example.createCriteria().andReportIdEqualTo(reportId);
        this.diseaserMapper.deleteByExample(example);
    }

    public void updateManagers(Integer reportId, List<PhcSuspectedOccupationalDiseaseManager> managers) {
        this.deleteManagers(reportId);
        if (managers == null || managers.size() == 0) {
            return;
        }
        for (PhcSuspectedOccupationalDiseaseManager m : managers) {
            if (m.getManagerId() == null) continue;
            m.setReportId(reportId);
            this.managerMapper.insert(m);
        }
    }

    public void deleteManagers(Integer reportId) {
        PhcSuspectedOccupationalDiseaseManagerExample example = new PhcSuspectedOccupationalDiseaseManagerExample();
        example.createCriteria().andReportIdEqualTo(reportId);
        this.managerMapper.deleteByExample(example);
    }

    public void deleteReport(Integer id) {
        this.mapper.deleteByPrimaryKey(id);
        this.deleteDiseasers(id);
        this.deleteManagers(id);
    }

    public void update(PhcSuspectedOccupationalDiseaseReport report) {
        this.mapper.updateReportByPrimaryKey(report);
        this.updateChildren(report);
    }

    public void insert(PhcSuspectedOccupationalDiseaseReport report) {
        this.mapper.insert(report);
        this.updateChildren(report);
    }
}

