/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.mywork;

import cn.smarthse.core.dao.mywork.PlanYearDetailMapper;
import cn.smarthse.core.dao.mywork.PlanYearExpendMapper;
import cn.smarthse.core.dao.mywork.PlanYearMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.enums.Modulars;
import cn.smarthse.core.model.flow.WfModularsWorkflow;
import cn.smarthse.core.model.mywork.PlanYear;
import cn.smarthse.core.model.mywork.PlanYearDetail;
import cn.smarthse.core.model.mywork.PlanYearDetailExample;
import cn.smarthse.core.model.mywork.PlanYearExample;
import cn.smarthse.core.model.mywork.PlanYearExpend;
import cn.smarthse.core.model.mywork.PlanYearExpendExample;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.workflow.IWorkflowService;
import cn.smarthse.core.service.workflow.ModularsWorkflowService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class PlanYearService
implements IWorkflowService {
    @Autowired
    PlanYearMapper planYearMapper;
    @Autowired
    ModularsWorkflowService modularsWorkflowService;
    @Autowired
    PlanYearDetailMapper planYearDetailMapper;
    @Autowired
    PlanYearExpendMapper planYearExpendMapper;

    public PlanYear addPlanYear(PlanYear record) {
        this.planYearMapper.insertSelective(record);
        return record;
    }

    public PlanYear getPlanYearDetails(int id) {
        return this.planYearMapper.selectByIDWithEntity(id);
    }

    public PlanYear getPlanYearById(int id) {
        return this.planYearMapper.selectByPrimaryKey(id);
    }

    public int updatePlanYear(PlanYear record) {
        return this.planYearMapper.updateByPrimaryKeySelective(record);
    }

    public int deletePlanYearByID(int id) {
        return this.planYearMapper.deleteByPrimaryKey(id);
    }

    public List<PlanYear> getPlanYearListByExample(PlanYearExample example) {
        return this.planYearMapper.selectByExample(example);
    }

    public List<PlanYear> getPlanYearList(int cid) {
        PlanYearExample example = new PlanYearExample();
        example.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        example.setOrderByClause(" createtime desc");
        return this.planYearMapper.selectByExampleWithEntity(example);
    }

    @Transactional
    public int executeSubmitPlanYear(PlanYear planYear) {
        ArrayList<Integer> ids;
        int count = 0;
        if (planYear == null) {
            return count;
        }
        if (planYear.getId() != null && planYear.getId() > 0) {
            count += this.planYearMapper.updateByPrimaryKeyWithBLOBs(planYear);
        } else {
            planYear.setIsvalid(Constant.ACTIVE_YES);
            planYear.setCreatetime(new Date());
            count += this.planYearMapper.insertSelective(planYear);
        }
        if (planYear.getDetaillist() != null && planYear.getDetaillist().size() > 0) {
            ids = new ArrayList<Integer>();
            for (PlanYearDetail d : planYear.getDetaillist()) {
                if (d.getYplanid() != null && d.getYplanid() != 0) continue;
                ids.add(d.getId());
            }
            if (ids.size() > 0) {
                PlanYearDetailExample example = new PlanYearDetailExample();
                example.createCriteria().andIdIn(ids).andIsvalidEqualTo(Constant.ACTIVE_YES);
                PlanYearDetail update = new PlanYearDetail();
                update.setYplanid(planYear.getId());
                update.setCreatetime(new Date());
                count += this.planYearDetailMapper.updateByExampleSelective(update, example);
            }
        }
        if (planYear.getExpendlist() != null && planYear.getExpendlist().size() > 0) {
            ids = new ArrayList();
            for (PlanYearExpend expend : planYear.getExpendlist()) {
                if (expend.getYplanid() != null && expend.getYplanid() != 0) continue;
                ids.add(expend.getId());
            }
            if (ids.size() > 0) {
                PlanYearExpendExample e = new PlanYearExpendExample();
                e.createCriteria().andIdIn(ids).andIsvalidEqualTo(Constant.ACTIVE_YES);
                PlanYearExpend record = new PlanYearExpend();
                record.setYplanid(planYear.getId());
                record.setCreatetime(new Date());
                count += this.planYearExpendMapper.updateByExampleSelective(record, e);
            }
        }
        return count;
    }

    @Transactional
    public int executeUpdateAndComplete(PlanYear record) {
        int count = 0;
        if (record == null) {
            return count;
        }
        count += this.planYearMapper.updateByPrimaryKeySelective(record);
        WfModularsWorkflow wf = this.modularsWorkflowService.getLastWorkflow(record.getCid(), Modulars.planyear.getCode(), record.getId());
        if (wf == null) {
            wf = new WfModularsWorkflow();
            wf.setApplyer(record.getCreator());
            wf.setApplyerDatetime(new Date());
            wf.setBusinessid(record.getId());
            wf.setBusinesstype(Modulars.planyear.getCode());
            wf.setBusinessno(record.getPlanno());
            wf.setCid(record.getCid());
            wf.setStageId((byte)1);
            wf.setStage("\u8ba1\u5212");
            wf.setProcessstate((byte)2);
            this.modularsWorkflowService.addWfModularsWorkflow(wf);
        } else {
            wf.setProcessstate((byte)2);
            this.modularsWorkflowService.updateWfModularsWorkflow(wf);
        }
        return count;
    }

    @Transactional
    public int executeCompletePlanYear(PlanYear record) {
        record.setStageType((byte)2);
        record.setStageStatus((byte)2);
        int count = this.executeUpdateAndComplete(record);
        return count;
    }

    public PlanYearDetail addPlanYearDetail(PlanYearDetail record) {
        this.planYearDetailMapper.insertSelective(record);
        return record;
    }

    public PlanYearDetail getPlanYearDetailById(int id) {
        return this.planYearDetailMapper.selectByPrimaryKey(id);
    }

    public PlanYearDetail getPlanYearDetail(int id) {
        return this.planYearDetailMapper.selectByIDWithEntity(id);
    }

    public int updatePlanYearDetail(PlanYearDetail record) {
        return this.planYearDetailMapper.updateByPrimaryKeySelective(record);
    }

    public int deletePlanYearDetailByID(int id) {
        return this.planYearDetailMapper.deleteByPrimaryKey(id);
    }

    public List<PlanYearDetail> getPlanYearDetailListByExample(PlanYearDetailExample example) {
        return this.planYearDetailMapper.selectByExample(example);
    }

    public PlanYearExpend addPlanYearExpend(PlanYearExpend record) {
        this.planYearExpendMapper.insertSelective(record);
        return record;
    }

    public PlanYearExpend getPlanYearExpendById(int id) {
        return this.planYearExpendMapper.selectByPrimaryKey(id);
    }

    public int updatePlanYearExpend(PlanYearExpend record) {
        return this.planYearExpendMapper.updateByPrimaryKeySelective(record);
    }

    public int deletePlanYearExpendByID(int id) {
        return this.planYearExpendMapper.deleteByPrimaryKey(id);
    }

    public List<PlanYearExpend> getPlanYearExpendListByExample(PlanYearExpendExample example) {
        return this.planYearExpendMapper.selectByExample(example);
    }

    @Override
    @Transactional
    public void workflow(WorkFlowParam wfparam, Integer orderId) {
        PlanYear record = this.getPlanYearById(wfparam.getBusinessId());
        if (wfparam.getNeedapprove() != null && wfparam.getNeedapprove().booleanValue()) {
            record.setStageStatus((byte)1);
            this.updatePlanYear(record);
        } else if (wfparam.getNeedapprove() != null && !wfparam.getNeedapprove().booleanValue()) {
            record.setStageStatus((byte)2);
            this.updatePlanYear(record);
        } else if (wfparam.getApproved() != null && wfparam.getApproved().booleanValue() && wfparam.getEnd().booleanValue()) {
            record.setStageType((byte)2);
            record.setStageStatus((byte)0);
            this.updatePlanYear(record);
        } else if (wfparam.getApproved() != null && !wfparam.getApproved().booleanValue()) {
            record.setStageStatus((byte)3);
            this.updatePlanYear(record);
        }
    }

    @Override
    public String doTask(Integer businessId, String taskName) {
        return "forward:/mywork/yearplan/view/" + businessId;
    }

    @Override
    public String doApproveTask(Integer businessId) {
        return null;
    }

    @Override
    public int terminateTask(Integer businessId) {
        if (businessId == null || businessId == 0) {
            return 0;
        }
        PlanYear planyear = this.planYearMapper.selectByPrimaryKey(businessId);
        planyear.setStageStatus((byte)-2);
        return this.planYearMapper.updateByPrimaryKey(planyear);
    }

    @Override
    public String addWorkUrl() {
        return "/mywork/yearplan/add";
    }

    @Override
    public String workflowInform(WorkFlowParam param, Integer orderId) {
        return null;
    }
}

