/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.matter;

import cn.smarthse.core.annotation.SYSLOG;
import cn.smarthse.core.dao.matter.PmcCompanymaterialMapper;
import cn.smarthse.core.dao.matter.PmcMaterialehsMapper;
import cn.smarthse.core.dao.matter.PmcMaterialharmMapper;
import cn.smarthse.core.dao.matter.PmcMaterialhazardousMapper;
import cn.smarthse.core.dao.matter.PmcMaterialproduceMapper;
import cn.smarthse.core.dao.matter.PmcMaterialstoreinfoMapper;
import cn.smarthse.core.dao.matter.PmcMaterialusageinfoMapper;
import cn.smarthse.core.dao.matter.PmcMaterialusageworkroleMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.common.ResponseData;
import cn.smarthse.core.model.matter.MatterInit;
import cn.smarthse.core.model.matter.PmcCompanymaterial;
import cn.smarthse.core.model.matter.PmcCompanymaterialExample;
import cn.smarthse.core.model.matter.PmcMaterialehs;
import cn.smarthse.core.model.matter.PmcMaterialehsExample;
import cn.smarthse.core.model.matter.PmcMaterialharm;
import cn.smarthse.core.model.matter.PmcMaterialharmExample;
import cn.smarthse.core.model.matter.PmcMaterialhazardous;
import cn.smarthse.core.model.matter.PmcMaterialhazardousExample;
import cn.smarthse.core.model.matter.PmcMaterialproduce;
import cn.smarthse.core.model.matter.PmcMaterialproduceExample;
import cn.smarthse.core.model.matter.PmcMaterialstoreinfo;
import cn.smarthse.core.model.matter.PmcMaterialstoreinfoExample;
import cn.smarthse.core.model.matter.PmcMaterialusageinfo;
import cn.smarthse.core.model.matter.PmcMaterialusageinfoExample;
import cn.smarthse.core.model.matter.PmcMaterialusageworkrole;
import cn.smarthse.core.model.matter.PmcMaterialusageworkroleExample;
import cn.smarthse.core.model.matter.vo.MatterItemVO;
import cn.smarthse.core.model.vo.QueryMatterParam;
import com.github.pagehelper.PageHelper;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@SYSLOG(desc="\u7269\u6599\u6a21\u5757")
@Service
public class MatterService {
    @Autowired
    PmcCompanymaterialMapper pmccompanyMaterialMapper;
    @Autowired
    PmcMaterialehsMapper pmcmaterialEhsMapper;
    @Autowired
    PmcMaterialharmMapper pmcmaterialHarmMapper;
    @Autowired
    PmcMaterialhazardousMapper pmcmaterialHazardousMapper;
    @Autowired
    PmcMaterialusageinfoMapper pmcmaterialUsageInfoMapper;
    @Autowired
    PmcMaterialusageworkroleMapper pmcmaterialUsageWorkroleMapper;
    @Autowired
    PmcMaterialstoreinfoMapper pmcmaterialStoreInfoMapper;
    @Autowired
    PmcMaterialproduceMapper pmcmaterialProduceMapper;

    public PmcCompanymaterial addPmccompanyMaterial(PmcCompanymaterial record) {
        this.pmccompanyMaterialMapper.insertSelective(record);
        return record;
    }

    public PmcCompanymaterial getCompanymaterialById(int id) {
        return this.pmccompanyMaterialMapper.selectByPrimaryKey(id);
    }

    public int updatePmccompanyMaterial(PmcCompanymaterial record) {
        return this.pmccompanyMaterialMapper.updateByPrimaryKeySelective(record);
    }

    public int deletePmccompanyMaterial(PmcCompanymaterial record) {
        return this.pmccompanyMaterialMapper.deleteByPrimaryKey(record.getId());
    }

    public List<PmcCompanymaterial> getPmccompanyMaterialListByExample(PmcCompanymaterialExample example) {
        return this.pmccompanyMaterialMapper.selectByExample(example);
    }

    public List<MatterItemVO> getMatterItemList(QueryMatterParam qparam) {
        if (qparam == null) {
            return Collections.emptyList();
        }
        return this.pmccompanyMaterialMapper.selectMatterItemList(qparam);
    }

    public void batchDeletePmccompanyMaterial(Integer cid, List<Integer> list) {
        if (list != null && list.size() > 0) {
            PmcCompanymaterialExample example = new PmcCompanymaterialExample();
            PmcCompanymaterialExample.Criteria criteria = example.createCriteria();
            criteria.andCidEqualTo(cid);
            criteria.andIdIn((List)list);
            PmcCompanymaterial record = new PmcCompanymaterial();
            record.setIsvalid(Constant.ACTIVE_NO);
            this.pmccompanyMaterialMapper.updateByExampleSelective(record, example);
        }
    }

    public PmcMaterialehs addMaterialEhs(PmcMaterialehs record) {
        this.pmcmaterialEhsMapper.insertSelective(record);
        return record;
    }

    public PmcMaterialehs getMaterialehsById(int id) {
        return this.pmcmaterialEhsMapper.selectByPrimaryKey(id);
    }

    public int updatePmcmaterialEhs(PmcMaterialehs record) {
        return this.pmcmaterialEhsMapper.updateByPrimaryKeySelective(record);
    }

    public int deletePmcmaterialEhs(PmcMaterialehs record) {
        return this.pmcmaterialEhsMapper.deleteByPrimaryKey(record.getId());
    }

    public List<PmcMaterialehs> getPmcmaterialEhsListByExample(PmcMaterialehsExample example) {
        return this.pmcmaterialEhsMapper.selectByExample(example);
    }

    public PmcMaterialehs getPmcMaterialehs(Integer cid, Integer companyMaterialID) {
        if (cid != null && cid > 0 && companyMaterialID != null && companyMaterialID > 0) {
            PmcMaterialehsExample example = new PmcMaterialehsExample();
            example.or().andCidEqualTo(cid).andCompanymaterialidEqualTo(companyMaterialID);
            PageHelper.startPage((int)1, (int)1);
            List<PmcMaterialehs> ehsList = this.pmcmaterialEhsMapper.selectByExampleWithEntity(example);
            if (ehsList != null && ehsList.size() > 0) {
                return ehsList.get(0);
            }
        }
        PmcMaterialehs ehs = new PmcMaterialehs();
        ehs.setCid(cid);
        ehs.setCompanymaterialid(companyMaterialID);
        this.pmcmaterialEhsMapper.insertSelective(ehs);
        return ehs;
    }

    public PmcMaterialehs selectByPrimaryKeyWithEntity(Integer cid, Integer companyMaterialID) {
        if (cid != null && cid > 0 && companyMaterialID != null && companyMaterialID > 0) {
            PmcMaterialehsExample example = new PmcMaterialehsExample();
            example.or().andCidEqualTo(cid).andCompanymaterialidEqualTo(companyMaterialID);
            PageHelper.startPage((int)1, (int)1);
            List<PmcMaterialehs> ehsList = this.pmcmaterialEhsMapper.selectByExampleWithEntity(example);
            if (ehsList != null && ehsList.size() > 0) {
                return ehsList.get(0);
            }
        }
        PmcMaterialehs ehs = new PmcMaterialehs();
        ehs.setCid(cid);
        ehs.setCompanymaterialid(companyMaterialID);
        this.pmcmaterialEhsMapper.insertSelective(ehs);
        return ehs;
    }

    public PmcMaterialharm addPmcmaterialHarm(PmcMaterialharm record) {
        this.pmcmaterialHarmMapper.insertSelective(record);
        return record;
    }

    public PmcMaterialharm getMaterialharmById(int id) {
        return this.pmcmaterialHarmMapper.selectByPrimaryKey(id);
    }

    public int updatePmcmaterialHarm(PmcMaterialharm record) {
        return this.pmcmaterialHarmMapper.updateByPrimaryKeySelective(record);
    }

    public int deletePmcmaterialHarmById(int id) {
        return this.pmcmaterialHarmMapper.deleteByPrimaryKey(id);
    }

    public List<PmcMaterialharm> getPmcmaterialHarmListByExample(PmcMaterialharmExample example) {
        return this.pmcmaterialHarmMapper.selectByExample(example);
    }

    public List<PmcMaterialharm> getPmcmaterialHarmList(Integer cid, Integer companyMaterialID) {
        if (cid != null && cid > 0 && companyMaterialID != null && companyMaterialID > 0) {
            PmcMaterialharmExample example = new PmcMaterialharmExample();
            example.or().andCidEqualTo(cid).andCompanymaterialidEqualTo(companyMaterialID);
            return this.pmcmaterialHarmMapper.selectByExampleWithEntity(example);
        }
        return Collections.emptyList();
    }

    public void clearPmcmaterialHarm(Integer cid, Integer companyMaterialID) {
        if (cid != null && cid > 0 && companyMaterialID != null && companyMaterialID > 0) {
            PmcMaterialharmExample example = new PmcMaterialharmExample();
            example.or().andCidEqualTo(cid).andCompanymaterialidEqualTo(companyMaterialID);
            this.pmcmaterialHarmMapper.deleteByExample(example);
        }
    }

    public PmcMaterialhazardous addPmcmaterialHazardous(PmcMaterialhazardous record) {
        this.pmcmaterialHazardousMapper.insertSelective(record);
        return record;
    }

    public PmcMaterialhazardous getMaterialhazardousById(int id) {
        return this.pmcmaterialHazardousMapper.selectByPrimaryKey(id);
    }

    public int updatePmcmaterialHazardous(PmcMaterialhazardous record) {
        return this.pmcmaterialHazardousMapper.updateByPrimaryKeySelective(record);
    }

    public int deletePmcmaterialHazardousById(int id) {
        return this.pmcmaterialHazardousMapper.deleteByPrimaryKey(id);
    }

    public List<PmcMaterialhazardous> getPmcmaterialHazardousListByExample(PmcMaterialhazardousExample example) {
        return this.pmcmaterialHazardousMapper.selectByExample(example);
    }

    public List<PmcMaterialhazardous> getPmcmaterialHazardousList(Integer cid, Integer companyMaterialID) {
        if (cid != null && cid > 0 && companyMaterialID != null && companyMaterialID > 0) {
            PmcMaterialhazardousExample example = new PmcMaterialhazardousExample();
            example.or().andCidEqualTo(cid).andCompanymaterialidEqualTo(companyMaterialID);
            return this.pmcmaterialHazardousMapper.selectByExampleWithEntity(example);
        }
        return Collections.emptyList();
    }

    public PmcMaterialusageinfo addPmcmaterialUsageInfo(PmcMaterialusageinfo record) {
        this.pmcmaterialUsageInfoMapper.insertSelective(record);
        return record;
    }

    public PmcMaterialusageinfo getPmcMaterialusageinfoById(int id) {
        return this.pmcmaterialUsageInfoMapper.selectByPrimaryKey(id);
    }

    public PmcMaterialusageinfo getPmcMaterialusageinfo(int id) {
        return this.pmcmaterialUsageInfoMapper.selectWithEntityByPrimaryKey(id);
    }

    public int updatePmcmaterialUsageInfo(PmcMaterialusageinfo record) {
        return this.pmcmaterialUsageInfoMapper.updateByPrimaryKeySelective(record);
    }

    public void deletePmcmaterialUsageInfoById(Integer id) {
        this.pmcmaterialUsageInfoMapper.deleteByPrimaryKey(id);
    }

    public List<PmcMaterialusageinfo> getPmcmaterialUsageInfoListByExample(PmcMaterialusageinfoExample example) {
        return this.pmcmaterialUsageInfoMapper.selectByExample(example);
    }

    public List<PmcMaterialusageinfo> getPmcmaterialUsageInfoList(Integer cid, Integer id) {
        PmcMaterialusageworkroleExample example = new PmcMaterialusageworkroleExample();
        example.or().andCidEqualTo(cid).andCompanymaterialidEqualTo(id);
        return null;
    }

    public List<PmcMaterialusageinfo> getPmcmaterialUsageInfoList(Integer companyMaterialID) {
        if (companyMaterialID != null && companyMaterialID > 0) {
            return this.pmcmaterialUsageInfoMapper.selectListViewByMaterialID(companyMaterialID);
        }
        return Collections.emptyList();
    }

    public PmcMaterialusageworkrole addPmcmaterialUsageWorkrole(PmcMaterialusageworkrole record) {
        this.pmcmaterialUsageWorkroleMapper.insertSelective(record);
        return record;
    }

    public PmcMaterialusageworkrole getPmcMaterialusageworkroleById(int id) {
        return this.pmcmaterialUsageWorkroleMapper.selectByPrimaryKey(id);
    }

    public int deletePmcmaterialUsageWorkroleById(int id) {
        return this.pmcmaterialUsageWorkroleMapper.deleteByPrimaryKey(id);
    }

    public List<PmcMaterialusageworkrole> getPmcmaterialUsageWorkroleListByExample(PmcMaterialusageworkroleExample example) {
        return this.pmcmaterialUsageWorkroleMapper.selectByExampleWithEntity(example);
    }

    public void clearPmcMaterialusageworkroleByMaterialusageid(Integer cid, Integer materialusageid) {
        PmcMaterialusageworkroleExample example = new PmcMaterialusageworkroleExample();
        example.or().andCidEqualTo(cid).andMaterialusageidEqualTo(materialusageid);
        this.pmcmaterialUsageWorkroleMapper.deleteByExample(example);
    }

    public PmcMaterialstoreinfo addPmcmaterialStoreInfo(PmcMaterialstoreinfo record) {
        this.pmcmaterialStoreInfoMapper.insertSelective(record);
        return record;
    }

    public PmcMaterialstoreinfo getPmcMaterialstoreinfoById(int id) {
        return this.pmcmaterialStoreInfoMapper.selectByPrimaryKey(id);
    }

    public int updatePmcmaterialStoreInfo(PmcMaterialstoreinfo record) {
        return this.pmcmaterialStoreInfoMapper.updateByPrimaryKeySelective(record);
    }

    public int deletePmcmaterialStoreInfo(int id) {
        PmcMaterialstoreinfo storeinfo = this.pmcmaterialStoreInfoMapper.selectByPrimaryKey(id);
        storeinfo.setIsvalid(Constant.ACTIVE_NO);
        return this.pmcmaterialStoreInfoMapper.updateByPrimaryKey(storeinfo);
    }

    public List<PmcMaterialstoreinfo> getPmcmaterialStoreInfoListByExample(PmcMaterialstoreinfoExample example) {
        return this.pmcmaterialStoreInfoMapper.selectByExample(example);
    }

    public List<PmcMaterialstoreinfo> getPmcMaterialstoreinfoListByCompanyMaterialID(Integer companyMaterialID) {
        if (companyMaterialID != null && companyMaterialID > 0) {
            PmcMaterialstoreinfoExample example = new PmcMaterialstoreinfoExample();
            PmcMaterialstoreinfoExample.Criteria c = example.createCriteria();
            c.andCompanymaterialidEqualTo(companyMaterialID);
            c.andIsvalidEqualTo(Constant.ACTIVE_YES);
            return this.pmcmaterialStoreInfoMapper.selectByExample(example);
        }
        return Collections.emptyList();
    }

    public List<PmcMaterialstoreinfo> getMatterStoreItemList(Integer cid, Integer companymaterialid, Integer useAreaId) {
        if (cid == null || cid == 0) {
            return Collections.emptyList();
        }
        return this.pmcmaterialStoreInfoMapper.selectMatterStoreItemList(cid, companymaterialid, useAreaId);
    }

    public int countByExample(Integer cid, Integer companymaterialid, Integer useAreaId, Integer notthisId) {
        PmcMaterialstoreinfoExample example = new PmcMaterialstoreinfoExample();
        PmcMaterialstoreinfoExample.Criteria c = example.createCriteria();
        c.andCompanymaterialidEqualTo(companymaterialid);
        c.andIsvalidEqualTo(Constant.ACTIVE_YES);
        c.andCidEqualTo(cid);
        c.andUseareaidEqualTo(useAreaId);
        if (notthisId != null && notthisId > 0) {
            c.andIdNotEqualTo(notthisId);
        }
        return this.pmcmaterialStoreInfoMapper.countByExample(example);
    }

    public PmcMaterialproduce addPmcmaterialProduce(PmcMaterialproduce record) {
        this.pmcmaterialProduceMapper.insertSelective(record);
        return record;
    }

    public PmcMaterialproduce getPmcMaterialproduceById(int id) {
        return this.pmcmaterialProduceMapper.selectByPrimaryKey(id);
    }

    public PmcMaterialproduce getPmcMaterialproduce(int id) {
        return this.pmcmaterialProduceMapper.selectByPrimaryKeyWithEntity(id);
    }

    public int updatePmcmaterialProduce(PmcMaterialproduce record) {
        return this.pmcmaterialProduceMapper.updateByPrimaryKeySelective(record);
    }

    public int deletePmcmaterialProduce(int id) {
        return this.pmcmaterialProduceMapper.deleteByPrimaryKey(id);
    }

    public List<PmcMaterialproduce> getPmcmaterialProduceListByExample(PmcMaterialproduceExample example) {
        return this.pmcmaterialProduceMapper.selectByExample(example);
    }

    public List<PmcMaterialproduce> getPmcmaterialProduceListByCompanyMaterialID(Integer companyMaterialID) {
        if (companyMaterialID != null && companyMaterialID > 0) {
            PmcMaterialproduceExample example = new PmcMaterialproduceExample();
            example.or().andCompanymaterialidEqualTo(companyMaterialID);
            return this.pmcmaterialProduceMapper.selectByExampleWithEntity(example);
        }
        return Collections.emptyList();
    }

    public ResponseData<MatterInit> getMatterInitInfoFromExcel(String fileName, Map<String, Object> paramMap) throws Exception {
        ResponseData<MatterInit> data = new ResponseData<MatterInit>();
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)new FileInputStream(fileName));
        HSSFSheet sheet = wb.getSheetAt(0);
        MatterInit init = new MatterInit();
        int rowIndex = 0;
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1 || row.getCell(3) == null || row.getCell(3).getCellType() == 3) continue;
            PmcCompanymaterial material = new PmcCompanymaterial();
            int cellCount = 11;
            int colIndex = 0;
            int i = 0;
            while (i < cellCount) {
                Cell cell = row.getCell(i);
                ++colIndex;
                if (cell != null && cell.getCellType() != 3) {
                    switch (i) {
                        case 0: {
                            String type = cell.getStringCellValue().trim();
                            List objList = (List)paramMap.get("material_type");
                            int j = 0;
                            while (j < objList.size()) {
                                String s = objList.get(j).toString();
                                String idS = s.substring(s.indexOf("id=") + 3, s.indexOf(","));
                                Integer id2 = new Integer(idS);
                                int m = s.indexOf("paramvalue=");
                                String Name2 = (s = s.substring(m)).substring(s.indexOf("paramvalue") + 11, s.indexOf(","));
                                if (type.equals(Name2)) {
                                    material.setMaterialtype(id2);
                                }
                                ++j;
                            }
                            break;
                        }
                        case 1: {
                            material.setMaterialname(cell.getStringCellValue().trim());
                            break;
                        }
                        case 2: {
                            material.setSpecification(cell.getStringCellValue().trim());
                            break;
                        }
                        case 3: {
                            String unit = cell.getStringCellValue().trim();
                            List objList = (List)paramMap.get("material_unit");
                            int j = 0;
                            while (j < objList.size()) {
                                String s = objList.get(j).toString();
                                String idS = s.substring(s.indexOf("id=") + 3, s.indexOf(","));
                                Integer id2 = new Integer(idS);
                                int m = s.indexOf("paramvalue=");
                                String Name3 = (s = s.substring(m)).substring(s.indexOf("paramvalue") + 11, s.indexOf(","));
                                if (unit.equals(Name3)) {
                                    material.setMaterialunit(id2);
                                }
                                ++j;
                            }
                            break;
                        }
                        case 4: {
                            try {
                                material.setUsageYear(cell.getNumericCellValue());
                                break;
                            }
                            catch (Exception e) {
                                data.setCode(-6);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5e74\u4f7f\u7528\u91cf/\u5e74\u4ea7\u91cf\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                        }
                        case 5: {
                            try {
                                material.setMaxsum(cell.getNumericCellValue());
                                break;
                            }
                            catch (Exception e) {
                                data.setCode(-6);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5e74\u4f7f\u7528\u91cf/\u5e74\u4ea7\u91cf\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                        }
                        case 6: {
                            material.setMaterialnick(cell.getStringCellValue().trim());
                            break;
                        }
                        case 7: {
                            material.setCasno(cell.getStringCellValue().trim());
                            break;
                        }
                        case 8: {
                            String state = cell.getStringCellValue().trim();
                            List objList = (List)paramMap.get("material_state");
                            int j = 0;
                            while (j < objList.size()) {
                                String s = objList.get(j).toString();
                                String idS = s.substring(s.indexOf("id=") + 3, s.indexOf(","));
                                Integer id2 = new Integer(idS);
                                int m = s.indexOf("paramvalue=");
                                String Name4 = (s = s.substring(m)).substring(s.indexOf("paramvalue") + 11, s.indexOf(","));
                                if (state.equals(Name4)) {
                                    material.setMaterialstate(id2);
                                }
                                ++j;
                            }
                            break;
                        }
                        case 9: {
                            String yesOrNo;
                            try {
                                yesOrNo = cell.getStringCellValue().trim();
                            }
                            catch (Exception e) {
                                data.setCode(-6);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u5371\u9669\u5316\u5b66\u54c1\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                            if (yesOrNo.equals("\u662f")) {
                                material.setIsharm(Constant.ACTIVE_YES);
                                break;
                            }
                            if (yesOrNo.equals("\u5426")) {
                                material.setIsharm(Constant.ACTIVE_NO);
                                break;
                            }
                            data.setCode(-4);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u5371\u9669\u5316\u5b66\u54c1\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        case 10: {
                            String yesOrNo;
                            try {
                                yesOrNo = cell.getStringCellValue().trim();
                            }
                            catch (Exception e) {
                                data.setCode(-6);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u4ea7\u751f\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                            if (yesOrNo.equals("\u662f")) {
                                material.setIshazard(Constant.ACTIVE_YES);
                                break;
                            }
                            if (yesOrNo.equals("\u5426")) {
                                material.setIshazard(Constant.ACTIVE_NO);
                                break;
                            }
                            data.setCode(-4);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u4ea7\u751f\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                }
                ++i;
            }
            init.getMatterList().add(material);
        }
        wb.close();
        data.setResult(init);
        return data;
    }

    private Date getExcelDate(int days) {
        Calendar c3 = Calendar.getInstance();
        c3.set(1900, 0, -1);
        c3.add(5, days);
        return c3.getTime();
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf(String.valueOf((char)(65 + a - 1))) + String.valueOf((char)(65 + b - 1));
    }

    @Transactional
    public ResponseData<String> initImport(MatterInit init) {
        int cid = init.getCompanyId();
        ResponseData<String> data = new ResponseData<String>();
        List<PmcCompanymaterial> matterList = init.getMatterList();
        for (PmcCompanymaterial mater : matterList) {
            mater.setCid(cid);
            mater.setIsvalid(Constant.ACTIVE_YES);
            this.pmccompanyMaterialMapper.insertSelective(mater);
            PmcMaterialusageinfo useinfo = new PmcMaterialusageinfo();
            useinfo.setUsageyear(mater.getUsageYear());
            useinfo.setCid(cid);
            useinfo.setCreatedate(new Date());
            useinfo.setCompanymaterialid(mater.getId());
            this.pmcmaterialUsageInfoMapper.insertSelective(useinfo);
            PmcMaterialstoreinfo materialstoreinfo = new PmcMaterialstoreinfo();
            materialstoreinfo.setCompanymaterialid(mater.getId());
            materialstoreinfo.setIsvalid(Constant.ACTIVE_YES);
            materialstoreinfo.setCid(cid);
            materialstoreinfo.setMaxstore(mater.getMaxsum());
            materialstoreinfo.setCreatedate(new Date());
            this.pmcmaterialStoreInfoMapper.insertSelective(materialstoreinfo);
        }
        return data;
    }

    public void deleteBycid(Integer cid) {
        PmcCompanymaterialExample pce = new PmcCompanymaterialExample();
        pce.createCriteria().andIsvalidEqualTo(Constant.ACTIVE_YES).andCidEqualTo(cid);
        List<PmcCompanymaterial> pcList = this.pmccompanyMaterialMapper.selectByExample(pce);
        for (PmcCompanymaterial pc : pcList) {
            pc.setIsvalid(Constant.ACTIVE_NO);
            this.pmccompanyMaterialMapper.updateByPrimaryKeySelective(pc);
        }
        PmcMaterialstoreinfoExample pmse = new PmcMaterialstoreinfoExample();
        pmse.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<PmcMaterialstoreinfo> pmsList = this.pmcmaterialStoreInfoMapper.selectByExample(pmse);
        for (PmcMaterialstoreinfo pms : pmsList) {
            pms.setIsvalid(Constant.ACTIVE_NO);
            this.pmcmaterialStoreInfoMapper.updateByPrimaryKeySelective(pms);
        }
    }
}

