/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.managsys;

import cn.smarthse.core.dao.managsys.MsInfoMapper;
import cn.smarthse.core.dao.managsys.MsReviseapplyMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.managsys.MsInfo;
import cn.smarthse.core.model.managsys.MsInfoExample;
import cn.smarthse.core.model.managsys.MsReviseapply;
import cn.smarthse.core.model.managsys.MsReviseapplyExample;
import cn.smarthse.core.model.managsys.vo.MsInfoItemVO;
import cn.smarthse.core.model.vo.QueryManagParam;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagSystemService {
    @Autowired
    MsInfoMapper msinfoMapper;
    @Autowired
    MsReviseapplyMapper msreviseApplyMapper;

    public MsInfo addMsinfo(MsInfo record) {
        this.msinfoMapper.insertSelective(record);
        return record;
    }

    public MsInfo getMsInfoById(int id) {
        return this.msinfoMapper.selectByPrimaryKey(id);
    }

    public MsInfo getMsInfoByIdWithEntity(int id) {
        MsInfoExample example = new MsInfoExample();
        example.or().andIdEqualTo(id);
        List<MsInfo> list = this.msinfoMapper.selectByExampleWithEntity(example);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public int updateMsinfo(MsInfo record) {
        return this.msinfoMapper.updateByPrimaryKeySelective(record);
    }

    public void deleteMsinfo(int id) {
        MsInfo info = this.msinfoMapper.selectByPrimaryKey(id);
        info.setIsvalid(Constant.ACTIVE_NO);
        this.msinfoMapper.updateByPrimaryKeySelective(info);
    }

    public List<MsInfo> getMsinfoListByExample(MsInfoExample example) {
        return this.msinfoMapper.selectByExample(example);
    }

    public List<MsInfo> getMsinfoListWithEntityByExample(MsInfoExample example) {
        return this.msinfoMapper.selectByExampleWithEntity(example);
    }

    public List<MsInfoItemVO> getMsinfoList(Integer cid, Integer type, Byte state) {
        if (cid != null && cid > 0) {
            MsInfoExample example = new MsInfoExample();
            MsInfoExample.Criteria c = example.createCriteria();
            c.andCidEqualTo(cid);
            if (type != null && type > 0) {
                c.andTypeEqualTo(type);
            }
            c.andIsvalidEqualTo(Constant.ACTIVE_YES);
            if (state != null) {
                c.andStateEqualTo(state);
            }
            example.setOrderByClause(" updatedate desc");
            return this.msinfoMapper.selectItemList(example);
        }
        return Collections.emptyList();
    }

    public List<MsInfoItemVO> getMsinfoOccupList(Integer cid, Integer occuptypeid) {
        if (cid != null && cid > 0) {
            MsInfoExample example = new MsInfoExample();
            MsInfoExample.Criteria c = example.createCriteria();
            c.andCidEqualTo(cid);
            c.andIsvalidEqualTo(Constant.ACTIVE_YES);
            c.andIszywsEqualTo(Constant.ACTIVE_YES);
            c.andZywsidEqualTo(occuptypeid);
            return this.msinfoMapper.selectItemList(example);
        }
        return Collections.emptyList();
    }

    public MsReviseapply addMsreviseApply(MsReviseapply record) {
        this.msreviseApplyMapper.insertSelective(record);
        return record;
    }

    public MsReviseapply getMsReviseapplyById(int id) {
        MsReviseapplyExample example = new MsReviseapplyExample();
        example.or().andIdEqualTo(id);
        List<MsReviseapply> list = this.msreviseApplyMapper.selectByExampleWithEntity(example);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public int updateMsreviseApply(MsReviseapply record) {
        return this.msreviseApplyMapper.updateByPrimaryKeySelective(record);
    }

    public List<MsReviseapply> getMsreviseApplyListByExample(MsReviseapplyExample example) {
        return this.msreviseApplyMapper.selectByExample(example);
    }

    public List<MsReviseapply> getMsReviseapplyList(QueryManagParam qparam) {
        if (qparam == null || qparam.getCid() == null || qparam.getCid() == 0) {
            return Collections.emptyList();
        }
        MsReviseapplyExample example = new MsReviseapplyExample();
        example.setDistinct(false);
        MsReviseapplyExample.Criteria c = example.createCriteria();
        c.andCidEqualTo(qparam.getCid());
        if (qparam.getType() > 0) {
            c.andRegimetypeEqualTo(qparam.getType());
        }
        if (!StringUtils.isEmpty((String)qparam.getKeyword())) {
            c.andRegimenameLike("%" + qparam.getKeyword() + "%");
        }
        if (qparam.getSdate() != null && qparam.getEdate() != null) {
            c.andRevisedateBetween(qparam.getSdate(), qparam.getEdate());
        } else if (qparam.getSdate() != null && qparam.getEdate() == null) {
            c.andRegimedateGreaterThanOrEqualTo(qparam.getSdate());
        } else if (qparam.getSdate() == null && qparam.getEdate() != null) {
            c.andRegimedateLessThanOrEqualTo(qparam.getEdate());
        }
        return this.msreviseApplyMapper.selectByExampleWithEntity(example);
    }
}

