/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.legal.lawdemandsurvey;

import cn.smarthse.core.dao.legal.lawdemandsurvey.LawPlanMapper;
import cn.smarthse.core.dao.legal.lawdemandsurvey.LawPlanWorkflowMapper;
import cn.smarthse.core.dao.legal.lawdemandsurvey.LawPlaninvolvedusersMapper;
import cn.smarthse.core.dao.legal.lawdemandsurvey.LawPlanresultMapper;
import cn.smarthse.core.dao.legal.lawdemandsurvey.LawPlansurveyorgMapper;
import cn.smarthse.core.framework.common.generator.SerialTool;
import cn.smarthse.core.model.legal.LawInfo;
import cn.smarthse.core.model.legal.lawdemandsurvey.LawPlan;
import cn.smarthse.core.model.legal.lawdemandsurvey.LawPlanWorkflow;
import cn.smarthse.core.model.legal.lawdemandsurvey.LawPlaninvolvedusers;
import cn.smarthse.core.model.legal.lawdemandsurvey.LawPlanresult;
import cn.smarthse.core.model.legal.lawdemandsurvey.LawPlansurveyorg;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.basic.staff.StaffService;
import cn.smarthse.core.service.workflow.IWorkflowService;
import cn.smarthse.core.service.workflow.ModularsWorkflowService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class LawPlanService
implements IWorkflowService {
    @Autowired
    private LawPlanMapper lawPlanMapper;
    @Autowired
    private LawPlanWorkflowMapper LawPlanWorkflowMapper;
    @Autowired
    private LawPlansurveyorgMapper lawPlansurveyorgMapper;
    @Autowired
    private LawPlaninvolvedusersMapper lawPlaninvolvedusersMapper;
    @Autowired
    private LawPlanresultMapper lawPlanresultMapper;
    @Autowired
    ModularsWorkflowService modularsWorkflowService;
    @Autowired
    StaffService staffService;

    public String addNumber() {
        return SerialTool.Law();
    }

    public List<LawPlan> getLawPlanNo(Integer cid) {
        return this.lawPlanMapper.selectLawPlanNo(cid);
    }

    public List<LawPlan> getLawPlanYes(Integer cid) {
        return this.lawPlanMapper.selectLawPlanYes(cid);
    }

    public List<Byte> getStageIdNo(Integer cid) {
        return this.lawPlanMapper.selectStageIdNo(cid);
    }

    public List<Byte> getStageIdYes(Integer cid) {
        return this.lawPlanMapper.selectStageIdYes(cid);
    }

    public LawPlan getLawPlanById(Integer id) {
        return this.lawPlanMapper.selectByPrimaryKey(id);
    }

    public List<Integer> getLawPlanId() {
        return this.lawPlanMapper.selectLawPlanId();
    }

    public int addLawPlan(LawPlan record) {
        return this.lawPlanMapper.insertSelective(record);
    }

    public int updateLawPlan(LawPlan record) {
        return this.lawPlanMapper.updateByPrimaryKey(record);
    }

    public LawPlanWorkflow getLawPlanWorkflowByLawPlanId(Integer lawplanid) {
        return this.LawPlanWorkflowMapper.selectLawPlanWorkflow(lawplanid);
    }

    public LawPlanWorkflow getLawPlanWorkflowById(Integer id) {
        return this.LawPlanWorkflowMapper.selectByPrimaryKey(id);
    }

    public int addLawPlanWorkflow(LawPlanWorkflow record) {
        return this.LawPlanWorkflowMapper.insert(record);
    }

    public int updateLawPlanWorkflow(LawPlanWorkflow record) {
        return this.LawPlanWorkflowMapper.updateByPrimaryKey(record);
    }

    public List<LawPlansurveyorg> getLawPlansurveyorgByLawPlanId(Integer lawplanid) {
        return this.lawPlansurveyorgMapper.selectLawPlansurveyorgByLawPlanId(lawplanid);
    }

    public List<LawPlansurveyorg> getLawPlansurveyorgByLawPlanIdAndStages(Integer lawplanid) {
        return this.lawPlansurveyorgMapper.selectLawPlansurveyorgByLawPlanIdAndStages(lawplanid);
    }

    public int addLawPlansurveyorg(LawPlansurveyorg record) {
        return this.lawPlansurveyorgMapper.insert(record);
    }

    public int deleteLawPlansurveyorg(Integer id) {
        return this.lawPlansurveyorgMapper.deleteByPrimaryKey(id);
    }

    @Deprecated
    public String getRealName(Integer staffid) {
        return this.lawPlanMapper.selectRealName(staffid);
    }

    @Deprecated
    public String gerFullName(Integer staffid) {
        return this.lawPlanMapper.selectFullName(staffid);
    }

    @Deprecated
    public String getFullNameByOrgId(Integer orgID) {
        return this.lawPlanMapper.selectFullNameByOrgId(orgID);
    }

    public String getFullNameByUid(Integer uid) {
        return this.lawPlanMapper.selectFullNameByUid(uid);
    }

    public int getFullNameId(Integer uid) {
        return this.lawPlanMapper.selectFullNameId(uid);
    }

    public int getFullNameid(Integer staffid) {
        return this.lawPlanMapper.selectFullNameid(staffid);
    }

    public int getStaffId(Integer uid) {
        return this.lawPlanMapper.selectStaffId(uid);
    }

    public Integer getUid(Integer staffid) {
        return this.lawPlanMapper.selectUid(staffid);
    }

    public List<LawPlaninvolvedusers> getLawPlaninvolvedusersByLawPlanId(Integer lawplanid) {
        return this.lawPlaninvolvedusersMapper.selectLawPlaninvolvedusersByLawPlanId(lawplanid);
    }

    public LawPlaninvolvedusers getLawPlaninvolvedusersByStaffId(Integer lawPlanID, Integer staffId) {
        return this.lawPlaninvolvedusersMapper.selectLawPlaninvolvedusersByStaffId(lawPlanID, staffId);
    }

    public int addLawPlaninvolvedusers(LawPlaninvolvedusers record) {
        return this.lawPlaninvolvedusersMapper.insert(record);
    }

    public int updateLawPlaninvolvedusers(LawPlaninvolvedusers record) {
        return this.lawPlaninvolvedusersMapper.updateByPrimaryKey(record);
    }

    public int deleteLawPlaninvolvedusers(Integer id) {
        return this.lawPlaninvolvedusersMapper.deleteByPrimaryKey(id);
    }

    public List<LawPlanresult> getLawPlanresult(Integer id) {
        return this.lawPlanresultMapper.selectLawPlanresult(id);
    }

    public List<LawPlanresult> getLawPlanresultAndValid(Integer id) {
        return this.lawPlanresultMapper.selectLawPlanresultAndValid(id);
    }

    public LawPlanresult getLawPlanresultById(Integer ID) {
        return this.lawPlanresultMapper.selectByPrimaryKey(ID);
    }

    public int addLawPlanresult(LawPlanresult record) {
        return this.lawPlanresultMapper.insert(record);
    }

    public int updateLawPlanresult(LawPlanresult record) {
        return this.lawPlanresultMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteLawPlanresult(Integer id) {
        return this.lawPlanresultMapper.deleteByPrimaryKey(id);
    }

    public List<LawPlanresult> getLawPlanresultByStaffId(Integer id, Integer staffId) {
        return this.lawPlanresultMapper.selectLawPlanresultByStaffId(id, staffId);
    }

    public List<LawPlanresult> getLawPlanresultByStaffIdAndValid(Integer id, Integer StaffId) {
        return this.lawPlanresultMapper.selectLawPlanresultByStaffIdAndValid(id, StaffId);
    }

    public List<LawPlanresult> getLawPlanresultByCheckState(Integer id) {
        return this.lawPlanresultMapper.selectLawPlanresultByCheckState(id);
    }

    public List<LawInfo> getLawInfo(Integer cid) {
        return this.lawPlanMapper.selectLawInfo(cid);
    }

    @Override
    public void workflow(WorkFlowParam param, Integer orderId) {
        LawPlan lawPlan = this.getLawPlanById(param.getBusinessId());
        lawPlan.setApprove((byte)1);
        LawPlanWorkflow lawPlanWorkflow = this.getLawPlanWorkflowByLawPlanId(lawPlan.getId());
        lawPlanWorkflow.setWorkflowid(orderId);
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            switch (lawPlanWorkflow.getStageid()) {
                case 1: {
                    lawPlanWorkflow.setStageid((byte)2);
                    lawPlan.setApprove((byte)0);
                    lawPlan.setUpdatetime(new Date());
                    break;
                }
                case 2: {
                    lawPlan.setApprove((byte)2);
                    lawPlan.setUpdatetime(new Date());
                    break;
                }
                case 3: {
                    lawPlanWorkflow.setStageid((byte)4);
                    lawPlan.setApprove((byte)0);
                    lawPlan.setUpdatetime(new Date());
                    break;
                }
            }
        }
        if (param.getEnd().booleanValue() && !param.getApproved().booleanValue()) {
            lawPlan.setApprove((byte)3);
            lawPlan.setUpdatetime(new Date());
        }
        this.updateLawPlanWorkflow(lawPlanWorkflow);
        this.updateLawPlan(lawPlan);
    }

    public String getBusinessPath(Integer businessId, Boolean isApprove) {
        LawPlanWorkflow lawPlanWorkflow = this.getLawPlanWorkflowByLawPlanId(businessId);
        lawPlanWorkflow = this.getLawPlanWorkflowById(lawPlanWorkflow.getId());
        switch (lawPlanWorkflow.getStageid().intValue()) {
            case 1: {
                if (isApprove.booleanValue()) {
                    return "forward:/legal/lawdemandsurvey/view/" + businessId + "?approve=1";
                }
                return "forward:/legal/lawdemandsurvey/view/" + businessId + "?approve=0";
            }
            case 2: {
                if (isApprove.booleanValue()) {
                    return "forward:/legal/lawdemandsurvey/view/" + businessId + "?approve=1";
                }
                return "forward:/legal/lawdemandsurvey/view/" + businessId + "?approve=0";
            }
            case 3: {
                if (isApprove.booleanValue()) {
                    return "forward:/legal/lawdemandsurvey/view/" + businessId + "?approve=1";
                }
                return "forward:/legal/lawdemandsurvey/view/" + businessId + "?approve=0";
            }
            case 4: {
                return "forward:/legal/lawdemandsurvey/view/" + businessId + "?approve=0";
            }
        }
        return "forward:/legal/lawdemandsurvey/readOnlyView/" + businessId + "?readOnly=5";
    }

    public String getInformPath(Integer businessId) {
        return "redirect:/legal/lawdemandsurvey/feedback/" + businessId;
    }

    @Override
    public String doTask(Integer businessId, String taskName) {
        if ("read".equals(taskName)) {
            return this.getInformPath(businessId);
        }
        if ("apply".equals(taskName)) {
            return this.getBusinessPath(businessId, false);
        }
        if ("approve".equals(taskName)) {
            return this.getBusinessPath(businessId, true);
        }
        return this.getBusinessPath(businessId, false);
    }

    @Override
    public String doApproveTask(Integer businessId) {
        return null;
    }

    @Override
    public int terminateTask(Integer businessId) {
        return 0;
    }

    @Override
    public String addWorkUrl() {
        return "/legal/lawdemandsurvey/createNumber/1";
    }

    @Override
    public String workflowInform(WorkFlowParam param, Integer orderId) {
        LawPlan lawPlan = this.getLawPlanById(param.getBusinessId());
        LawPlanWorkflow lawPlanWorkflow = this.getLawPlanWorkflowByLawPlanId(lawPlan.getId());
        lawPlanWorkflow.setStageid((byte)3);
        lawPlan.setApprove((byte)0);
        lawPlan.setUpdatetime(new Date());
        this.updateLawPlan(lawPlan);
        this.updateLawPlanWorkflow(lawPlanWorkflow);
        return "redirect:/legal/lawdemandsurvey/lawPlanNo";
    }
}

