/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.hccheckplan;

import cn.smarthse.core.dao.basic.AreaMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckSchemeMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckTypeMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.framework.enums.RecordState;
import cn.smarthse.core.model.basic.Area;
import cn.smarthse.core.model.basic.Staff;
import cn.smarthse.core.model.hccheckplan.HcCheckScheme;
import cn.smarthse.core.model.hccheckplan.HcCheckSchemeExample;
import cn.smarthse.core.model.hccheckplan.HcCheckType;
import cn.smarthse.core.model.hccheckplan.HcCheckTypeExample;
import cn.smarthse.core.model.vo.CheckSchemeSearchEntity;
import cn.smarthse.core.service.FileService;
import cn.smarthse.core.service.basic.staff.StaffService;
import cn.smarthse.core.util.EntityUtil;
import cn.smarthse.core.util.LoginUtil;
import java.util.Calendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class HcCheckSchemeService {
    @Autowired
    private HcCheckSchemeMapper checkSchemeMapper;
    @Autowired
    private HcCheckTypeMapper checkTypeMapper;
    @Autowired
    private AreaMapper areaMapper;
    @Autowired
    private FileService fileService;
    @Autowired
    private StaffService staffService;

    public List<HcCheckScheme> searchCheckScheme(CheckSchemeSearchEntity search) {
        HcCheckSchemeExample example = new HcCheckSchemeExample();
        HcCheckSchemeExample.Criteria criteria = example.createCriteria();
        HcCheckSchemeExample.Criteria criteria2 = example.createCriteria();
        Integer companyId = LoginUtil.getInstance().getLoginStaffCompanyId();
        if (companyId == null) {
            criteria.andCompanyIdIsNull();
            criteria2.andCompanyIdIsNull();
        } else {
            criteria.andCompanyIdEqualTo(companyId);
            criteria2.andCompanyIdEqualTo(companyId);
        }
        criteria.andRecordStateEqualTo(RecordState.valid.getValue());
        if (search != null) {
            if (search.getCheckType() != null) {
                criteria.andCheckTypeIdEqualTo(search.getCheckType());
                criteria2.andCheckTypeIdEqualTo(search.getCheckType());
            }
            if (StringUtils.isNotEmpty(search.getName())) {
                criteria.andNameEqualTo(search.getName());
                criteria2.andFileUploaderEqualTo(search.getName());
            }
            if (search.getUpdateTimeStart() != null) {
                criteria.andUpdateDateGreaterThanOrEqualTo(search.getUpdateTimeStart());
                criteria2.andUpdateDateGreaterThanOrEqualTo(search.getUpdateTimeStart());
            }
            if (search.getUpdateTimeEnd() != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(search.getUpdateTimeEnd());
                cal.add(5, 1);
                criteria.andUpdateDateLessThanOrEqualTo(cal.getTime());
                criteria2.andUpdateDateLessThanOrEqualTo(cal.getTime());
            }
            example.or(criteria2);
        }
        List<HcCheckScheme> list = this.checkSchemeMapper.selectByExample(example);
        this.setCheckSchemeExtendsInfoByList(list);
        return list;
    }

    public List<HcCheckScheme> getCheckSchemeListByCompanyId(Integer companyId) {
        HcCheckSchemeExample example = new HcCheckSchemeExample();
        HcCheckSchemeExample.Criteria criteria = example.createCriteria();
        if (companyId != null) {
            criteria.andCompanyIdEqualTo(companyId);
        } else {
            criteria.andCompanyIdIsNull();
        }
        criteria.andRecordStateEqualTo(RecordState.valid.getValue());
        List<HcCheckScheme> list = this.checkSchemeMapper.selectByExample(example);
        this.setCheckSchemeExtendsInfoByList(list);
        return list;
    }

    @Transactional(readOnly=false)
    public Integer saveCheckScheme(HcCheckScheme checkScheme) {
        if (checkScheme == null) {
            return null;
        }
        EntityUtil.getInstance().setCreateAndUpdateInfo(checkScheme);
        if (checkScheme.getId() == null) {
            Staff staff = LoginUtil.getInstance().getLoginStaffInfo();
            if (staff != null) {
                String orgAndName = this.staffService.getStaffNameOrgByStaffId(staff.getId());
                if (StringUtils.isNotEmpty(orgAndName)) {
                    checkScheme.setFileUploader(orgAndName);
                }
                checkScheme.setCompanyId(staff.getCid());
            }
            this.checkSchemeMapper.insertSelective(checkScheme);
        } else {
            this.checkSchemeMapper.updateByPrimaryKeySelective(checkScheme);
        }
        return checkScheme.getId();
    }

    private void setCheckSchemeExtendsInfoByList(List<HcCheckScheme> list) {
        for (HcCheckScheme checkScheme : list) {
            this.setCheckSchemeExtendsInfo(checkScheme);
        }
    }

    private void setCheckSchemeExtendsInfo(HcCheckScheme checkScheme) {
        if (!StringUtils.isEmpty((String)checkScheme.getCheckRange())) {
            String[] ranges;
            String[] stringArray = ranges = checkScheme.getCheckRange().split(",");
            int n = ranges.length;
            int n2 = 0;
            while (n2 < n) {
                Area area;
                String range = stringArray[n2];
                if (StringUtils.isNumber(range) && (area = this.areaMapper.selectByPrimaryKey(Integer.valueOf(range))) != null) {
                    checkScheme.getCheckRangeArea().add(area);
                }
                ++n2;
            }
        }
        if (checkScheme.getCheckTypeId() != null) {
            checkScheme.setCheckType(this.checkTypeMapper.selectByPrimaryKey(checkScheme.getCheckTypeId()));
        }
        if (checkScheme.getFileId() != null) {
            checkScheme.setFile(this.fileService.getById(checkScheme.getFileId()));
        }
    }

    public List<HcCheckType> getHcCheckTypeByCompanyId(Integer companyId) {
        HcCheckTypeExample example = new HcCheckTypeExample();
        example.createCriteria().andCompanyIdIsNull();
        if (companyId != null) {
            example.or().andCompanyIdEqualTo(companyId).andRecordStateEqualTo(RecordState.valid.getValue());
        }
        return this.checkTypeMapper.selectByExample(example);
    }

    @Transactional(readOnly=false)
    public int deleteCheckSchemeByPrimaryId(Integer primaryId) {
        if (primaryId == null) {
            return 0;
        }
        HcCheckScheme record = new HcCheckScheme();
        record.setId(primaryId);
        record.setRecordState(RecordState.invalid.getValue());
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        return this.checkSchemeMapper.updateByPrimaryKeySelective(record);
    }

    @Transactional(readOnly=false)
    public Integer saveCheckType(HcCheckType checkType) {
        if (checkType == null) {
            return null;
        }
        EntityUtil.getInstance().setCreateAndUpdateInfo(checkType);
        if (checkType.getId() == null) {
            Integer companyId = LoginUtil.getInstance().getLoginStaffCompanyId();
            if (companyId != null) {
                checkType.setCompanyId(companyId);
            }
            this.checkTypeMapper.insertSelective(checkType);
        } else {
            this.checkTypeMapper.updateByPrimaryKeySelective(checkType);
        }
        return checkType.getId();
    }

    public boolean isHasCheckType(String checkTypeName) {
        Integer companyId = LoginUtil.getInstance().getLoginStaffCompanyId();
        if (companyId == null) {
            return true;
        }
        if (StringUtils.isEmpty((String)checkTypeName)) {
            return true;
        }
        HcCheckTypeExample example = new HcCheckTypeExample();
        example.createCriteria().andTypeNameEqualTo(checkTypeName).andCompanyIdEqualTo(companyId).andRecordStateEqualTo(RecordState.valid.getValue());
        example.or().andTypeNameEqualTo(checkTypeName).andCompanyIdIsNull();
        List<HcCheckType> list = this.checkTypeMapper.selectByExample(example);
        return list.size() > 0;
    }

    public HcCheckScheme getCheckSchemeByPrimaryId(Integer primaryId) {
        if (primaryId == null) {
            return null;
        }
        HcCheckScheme scheme = this.checkSchemeMapper.selectByPrimaryKey(primaryId);
        this.setCheckSchemeExtendsInfo(scheme);
        return scheme;
    }
}

