/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.hccheckplan;

import cn.smarthse.core.dao.hccheckplan.HcCheckResultReportMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.framework.enums.HcCheckPlanReportState;
import cn.smarthse.core.framework.enums.RecordState;
import cn.smarthse.core.model.basic.File;
import cn.smarthse.core.model.hccheckplan.HcCheckResultReport;
import cn.smarthse.core.model.vo.CheckResultReportSearchEntity;
import cn.smarthse.core.service.FileService;
import cn.smarthse.core.service.basic.staff.StaffService;
import cn.smarthse.core.service.hccheckplan.HcCheckPlanService;
import cn.smarthse.core.util.EntityUtil;
import cn.smarthse.core.util.LoginUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class HcCheckResultReportService {
    @Autowired
    private HcCheckResultReportMapper checkResultReportMapper;
    @Autowired
    private HcCheckPlanService checkPlanService;
    @Autowired
    private FileService fileService;
    @Autowired
    private StaffService staffService;

    public List<HcCheckResultReport> search(CheckResultReportSearchEntity search) {
        Integer companyId = LoginUtil.getInstance().getLoginStaffCompanyId();
        if (search == null) {
            search = new CheckResultReportSearchEntity();
        }
        if (search.getCheckDateStart() != null || search.getCheckDateEnd() != null) {
            if (search.getCheckDateStart() == null) {
                search.setCheckDateStart(new Date(0L));
            }
            if (search.getCheckDateEnd() == null) {
                search.setCheckDateEnd(new Date());
            }
            if (search.getCheckDateStart().after(search.getCheckDateEnd())) {
                Date temp = search.getCheckDateStart();
                search.setCheckDateStart(search.getCheckDateEnd());
                search.setCheckDateEnd(temp);
            }
        }
        List<HcCheckResultReport> list = this.checkResultReportMapper.search(search, companyId);
        this.setCheckResultReportExtendInfoList(list);
        return list;
    }

    private void setCheckResultReportExtendInfoList(List<HcCheckResultReport> list) {
        for (HcCheckResultReport checkResultReport : list) {
            this.setCheckResultReportExtendInfo(checkResultReport);
        }
    }

    @Transactional(readOnly=false)
    public boolean saveCheckResultReport(HcCheckResultReport checkResultReport) {
        boolean isSaveSuccess;
        if (checkResultReport == null) {
            return false;
        }
        EntityUtil.getInstance().setCreateAndUpdateInfo(checkResultReport);
        int num = 0;
        num = checkResultReport.getId() == null ? this.checkResultReportMapper.insertSelective(checkResultReport) : this.checkResultReportMapper.updateByPrimaryKeySelective(checkResultReport);
        boolean bl = isSaveSuccess = num > 0;
        if (isSaveSuccess) {
            this.checkPlanService.updateCheckPlanIsReportFromCheckOrginzation(HcCheckPlanReportState.reported, checkResultReport.getCheckId());
        }
        return isSaveSuccess;
    }

    public HcCheckResultReport getHcCheckResultReportByPrimaryKey(Integer primaryKey, boolean needExtendsInfo) {
        HcCheckResultReport report = this.checkResultReportMapper.selectByPrimaryKey(primaryKey);
        if (needExtendsInfo) {
            this.setCheckResultReportExtendInfo(report);
        }
        return report;
    }

    @Transactional(readOnly=false)
    public boolean deleteCheckResultReportByPrimaryKey(Integer primaryKey) {
        HcCheckResultReport checkResultReport;
        boolean isDeleted;
        if (primaryKey == null) {
            return false;
        }
        HcCheckResultReport report = new HcCheckResultReport();
        report.setId(primaryKey);
        report.setRecordState(RecordState.invalid.getValue());
        EntityUtil.getInstance().setCreateAndUpdateInfo(report);
        int num = this.checkResultReportMapper.updateByPrimaryKeySelective(report);
        boolean bl = isDeleted = num > 0;
        if (isDeleted && (checkResultReport = this.getHcCheckResultReportByPrimaryKey(primaryKey, false)) != null) {
            this.checkPlanService.updateCheckPlanIsReportFromCheckOrginzation(HcCheckPlanReportState.notReport, checkResultReport.getCheckId());
        }
        return isDeleted;
    }

    private void setCheckResultReportExtendInfo(HcCheckResultReport report) {
        if (report.getCheckId() != null) {
            report.setCheckPlan(this.checkPlanService.getHcCheckPlanById(report.getCheckId()));
        }
        if (StringUtils.isNotEmpty(report.getReportFileIds())) {
            String[] fileIds;
            String[] stringArray = fileIds = report.getReportFileIds().split(",");
            int n = fileIds.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                String id = stringArray[n2];
                if (StringUtils.isNumber(id) && (file = this.fileService.getById(Integer.valueOf(id))) != null) {
                    report.getReportFiles().add(file);
                }
                ++n2;
            }
        }
    }
}

