/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.hccheckplan;

import cn.smarthse.core.dao.hccheckplan.HcCheckPointMapMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.framework.enums.RecordState;
import cn.smarthse.core.model.basic.File;
import cn.smarthse.core.model.hccheckplan.HcCheckPointMap;
import cn.smarthse.core.model.hccheckplan.HcCheckPointMapExample;
import cn.smarthse.core.model.vo.CheckPointMapSearchEntity;
import cn.smarthse.core.service.FileService;
import cn.smarthse.core.service.basic.staff.StaffService;
import cn.smarthse.core.util.EntityUtil;
import cn.smarthse.core.util.LoginUtil;
import java.util.Calendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class HcCheckPointMapService {
    @Autowired
    private HcCheckPointMapMapper checkPointMapMapper;
    @Autowired
    private FileService fileService;
    @Autowired
    private StaffService staffService;

    public List<HcCheckPointMap> search(CheckPointMapSearchEntity search) {
        HcCheckPointMapExample example = new HcCheckPointMapExample();
        HcCheckPointMapExample.Criteria criteria = example.createCriteria();
        Integer companyId = LoginUtil.getInstance().getLoginStaffCompanyId();
        if (companyId != null) {
            criteria.andCompanyIdEqualTo(companyId);
        } else {
            criteria.andCompanyIdIsNull();
        }
        if (search != null) {
            if (StringUtils.isNotEmpty(search.getName())) {
                criteria.andNameLike("%" + search.getName() + "%");
            }
            if (search.getEditDate() != null) {
                criteria.andUpdateDateGreaterThan(search.getEditDate());
                Calendar cal = Calendar.getInstance();
                cal.setTime(search.getEditDate());
                cal.add(5, 1);
                criteria.andUpdateDateLessThan(cal.getTime());
            }
        }
        criteria.andRecordStateEqualTo(RecordState.valid.getValue());
        List<HcCheckPointMap> list = this.checkPointMapMapper.selectByExample(example);
        this.setCheckPointMapExtnedsInfoList(list);
        return list;
    }

    public List<HcCheckPointMap> getHcCheckPointMapListByCompanyId(Integer companyId) {
        HcCheckPointMapExample example = new HcCheckPointMapExample();
        HcCheckPointMapExample.Criteria criteria = example.createCriteria();
        if (companyId != null) {
            criteria.andCompanyIdEqualTo(companyId);
        } else {
            criteria.andCompanyIdIsNull();
        }
        criteria.andRecordStateEqualTo(RecordState.valid.getValue());
        List<HcCheckPointMap> list = this.checkPointMapMapper.selectByExample(example);
        this.setCheckPointMapExtnedsInfoList(list);
        return list;
    }

    private void setCheckPointMapExtnedsInfoList(List<HcCheckPointMap> checkPointMapList) {
        if (checkPointMapList == null) {
            return;
        }
        for (HcCheckPointMap checkPointMap : checkPointMapList) {
            this.setCheckPointMapExtnedsInfo(checkPointMap);
        }
    }

    private void setCheckPointMapExtnedsInfo(HcCheckPointMap checkPointMap) {
        String editor;
        if (checkPointMap == null) {
            return;
        }
        if (StringUtils.isNotEmpty(checkPointMap.getMapFileIds())) {
            String[] ids;
            String[] stringArray = ids = checkPointMap.getMapFileIds().split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                String id = stringArray[n2];
                if (id != null && StringUtils.isNumber(id) && (file = this.fileService.getById(Integer.valueOf(id))) != null) {
                    checkPointMap.getMapFiles().add(file);
                }
                ++n2;
            }
        }
        if (checkPointMap.getCreateBy() != null && (editor = this.staffService.getStaffNameOrgByStaffId(checkPointMap.getCreateBy())) != null) {
            checkPointMap.setEditor(editor);
        }
    }

    @Transactional(readOnly=false)
    public boolean saveHcCheckPointMap(HcCheckPointMap checkPointMap) {
        if (checkPointMap == null) {
            return false;
        }
        EntityUtil.getInstance().setCreateAndUpdateInfo(checkPointMap);
        int num = 0;
        if (checkPointMap.getId() == null) {
            Integer companyId = LoginUtil.getInstance().getLoginStaffCompanyId();
            if (companyId != null) {
                checkPointMap.setCompanyId(companyId);
            }
            num = this.checkPointMapMapper.insertSelective(checkPointMap);
        } else {
            num = this.checkPointMapMapper.updateByPrimaryKeySelective(checkPointMap);
        }
        return num > 0;
    }

    public HcCheckPointMap getHcCheckPointMapByPrimaryKey(Integer primaryKey) {
        if (primaryKey == null) {
            return null;
        }
        HcCheckPointMap checkPointMap = this.checkPointMapMapper.selectByPrimaryKey(primaryKey);
        this.setCheckPointMapExtnedsInfo(checkPointMap);
        return checkPointMap;
    }

    @Transactional(readOnly=false)
    public boolean deleteHcCheckPointMapByPrimayKey(Integer primaryKey) {
        if (primaryKey == null) {
            return false;
        }
        int num = 0;
        HcCheckPointMap record = new HcCheckPointMap();
        record.setId(primaryKey);
        record.setRecordState(RecordState.invalid.getValue());
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        num = this.checkPointMapMapper.updateByPrimaryKeySelective(record);
        return num > 0;
    }
}

