/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.hccheckplan;

import cn.smarthse.core.dao.hccheckplan.HcCheckPlanAreaMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckPlanMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckplanGenMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckplaninformMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckplanlaunchMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckplantestscheduleMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckplantestscheduledeptMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckplanworkflowMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckrelatedMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckresultMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckresultdataMapper;
import cn.smarthse.core.dao.hccheckplan.HcCheckstorefileMapper;
import cn.smarthse.core.dao.hccheckplan.HcSamplingprocessMapper;
import cn.smarthse.core.dao.hccheckplan.HcSamplingprocessfilesMapper;
import cn.smarthse.core.dao.hccheckplan.HcSamplingsolutionMapper;
import cn.smarthse.core.dao.hccheckplan.HcSamplingstaffMapper;
import cn.smarthse.core.dao.reform.RefReformfileMapper;
import cn.smarthse.core.dao.reform.RefReformitemMapper;
import cn.smarthse.core.dao.reform.RefReformphaseMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.framework.enums.CheckPlanPhase;
import cn.smarthse.core.framework.enums.HcCheckPlanReportState;
import cn.smarthse.core.framework.enums.RecordState;
import cn.smarthse.core.model.basic.Company;
import cn.smarthse.core.model.hccheckplan.HcCheckPlan;
import cn.smarthse.core.model.hccheckplan.HcCheckPlanArea;
import cn.smarthse.core.model.hccheckplan.HcCheckPlanInformStat;
import cn.smarthse.core.model.hccheckplan.HcCheckplanExample;
import cn.smarthse.core.model.hccheckplan.HcCheckplaninform;
import cn.smarthse.core.model.hccheckplan.HcCheckplaninformExample;
import cn.smarthse.core.model.hccheckplan.HcCheckplanlaunch;
import cn.smarthse.core.model.hccheckplan.HcCheckplanlaunchExample;
import cn.smarthse.core.model.hccheckplan.HcCheckplantestschedule;
import cn.smarthse.core.model.hccheckplan.HcCheckplantestscheduleExample;
import cn.smarthse.core.model.hccheckplan.HcCheckplantestscheduledept;
import cn.smarthse.core.model.hccheckplan.HcCheckplantestscheduledeptExample;
import cn.smarthse.core.model.hccheckplan.HcCheckrelated;
import cn.smarthse.core.model.hccheckplan.HcCheckrelatedExample;
import cn.smarthse.core.model.hccheckplan.HcCheckresult;
import cn.smarthse.core.model.hccheckplan.HcCheckresultExample;
import cn.smarthse.core.model.hccheckplan.HcCheckresultdata;
import cn.smarthse.core.model.hccheckplan.HcCheckresultdataExample;
import cn.smarthse.core.model.hccheckplan.HcCheckstorefile;
import cn.smarthse.core.model.hccheckplan.HcSamplingprocess;
import cn.smarthse.core.model.hccheckplan.HcSamplingprocessExample;
import cn.smarthse.core.model.hccheckplan.HcSamplingprocessfiles;
import cn.smarthse.core.model.hccheckplan.HcSamplingsolution;
import cn.smarthse.core.model.hccheckplan.HcSamplingsolutionExample;
import cn.smarthse.core.model.hccheckplan.HcSamplingstaff;
import cn.smarthse.core.model.hccheckplan.HcSamplingstaffExample;
import cn.smarthse.core.model.reform.RefReformfile;
import cn.smarthse.core.model.reform.RefReformitem;
import cn.smarthse.core.model.reform.RefReformitemExample;
import cn.smarthse.core.model.reform.RefReformitemWithBLOBs;
import cn.smarthse.core.model.thirdparty.TpCompany;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.basic.CompanyService;
import cn.smarthse.core.service.thirdparty.TpcompanyService;
import cn.smarthse.core.service.workflow.IWorkflowService;
import cn.smarthse.core.util.LoginUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class HcCheckPlanService
implements IWorkflowService {
    @Autowired
    private HcCheckPlanMapper hcCheckPlanMapper;
    @Autowired
    private HcCheckplanGenMapper hcCheckPlanGenMapper;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private TpcompanyService tpcompanyService;
    @Autowired
    private HcCheckPlanAreaMapper hcCheckPlanAreaMapper;
    @Autowired
    private HcCheckstorefileMapper hcCheckstorefileMapper;
    @Autowired
    private HcCheckplanlaunchMapper hcCheckplanlaunchMapper;
    @Autowired
    private HcCheckplantestscheduleMapper hcCheckplantestscheduleMapper;
    @Autowired
    private HcCheckplantestscheduledeptMapper hcCheckplantestscheduledeptMapper;
    @Autowired
    private HcSamplingprocessMapper hcSamplingprocessMapper;
    @Autowired
    private HcSamplingstaffMapper hcSamplingstaffMapper;
    @Autowired
    private HcSamplingsolutionMapper hcSamplingsolutionMapper;
    @Autowired
    private HcSamplingprocessfilesMapper hcSamplingprocessfilesMapper;
    @Autowired
    private HcCheckresultMapper hcCheckresultMapper;
    @Autowired
    private HcCheckresultdataMapper hcCheckresultdataMapper;
    @Autowired
    private HcCheckplanworkflowMapper hcCheckplanworkflowMapper;
    @Autowired
    private HcCheckplaninformMapper hcCheckplaninformMapper;
    @Autowired
    private RefReformitemMapper refReformitemMapper;
    @Autowired
    private RefReformfileMapper refReformfileMapper;
    @Autowired
    private RefReformphaseMapper reformphaseMapper;
    @Autowired
    private HcCheckrelatedMapper hcCheckrelatedMapper;

    public int updateCheckPlanIsReportFromCheckOrginzation(HcCheckPlanReportState reportState, Integer checkPlanPrimaryKey) {
        HcCheckPlan record = new HcCheckPlan();
        record.setId(checkPlanPrimaryKey);
        record.setIsReportedFromCheckOrginzation((byte)reportState.ordinal());
        return this.hcCheckPlanGenMapper.updateByPrimaryKeySelective(record);
    }

    @Deprecated
    public List<HcCheckPlan> getHcCheckPlanListByCompanyIdAndNameAndSn(Integer companyId, String nameOrSn, Integer checkType, Date checkDateStart, Date checkDateEnd, Integer checkOrginzationId) {
        HcCheckplanExample example = new HcCheckplanExample();
        HcCheckplanExample.Criteria criteria = example.createCriteria();
        HcCheckplanExample.Criteria criteria2 = example.createCriteria();
        criteria.andIsvalidEqualTo(RecordState.valid.getValue());
        criteria2.andIsvalidEqualTo(RecordState.valid.getValue());
        if (companyId != null) {
            criteria.andCidEqualTo(companyId);
            criteria2.andCidEqualTo(companyId);
        }
        if (checkType != null) {
            criteria.andStartchecktypeEqualTo(checkType);
            criteria2.andStartchecktypeEqualTo(checkType);
        }
        if (StringUtils.isNotEmpty(nameOrSn)) {
            criteria.andChecknameLike("%" + nameOrSn + "%");
            criteria2.andChecknoLike("%" + nameOrSn + "%");
        }
        if (checkDateStart != null) {
            // empty if block
        }
        if (checkDateEnd != null) {
            // empty if block
        }
        if (checkOrginzationId != null) {
            // empty if block
        }
        example.or(criteria2);
        return this.hcCheckPlanGenMapper.selectByExample(example);
    }

    public List<HcCheckPlan> getCheckPlanListIsNotReport(String keyword) {
        HcCheckplanExample example = new HcCheckplanExample();
        Integer companyId = LoginUtil.getInstance().getLoginStaffCompanyId();
        if (companyId == null) {
            return null;
        }
        boolean hasOrCondition = false;
        HcCheckplanExample.Criteria criteria = example.createCriteria();
        HcCheckplanExample.Criteria criteria2 = example.createCriteria();
        criteria.andCidEqualTo(companyId);
        criteria2.andCidEqualTo(companyId);
        criteria.andIsReportedFromCheckOrginzationEqualTo((byte)HcCheckPlanReportState.notReport.ordinal());
        criteria2.andIsReportedFromCheckOrginzationEqualTo((byte)HcCheckPlanReportState.notReport.ordinal());
        if (keyword != null) {
            criteria.andChecknameLike("%" + keyword + "%");
            criteria2.andChecknoLike("%" + keyword + "%");
            hasOrCondition = true;
        }
        criteria.andPhaseEqualTo(CheckPlanPhase.finish.getValue());
        criteria2.andPhaseEqualTo(CheckPlanPhase.finish.getValue());
        if (hasOrCondition) {
            example.or(criteria2);
        }
        List<HcCheckPlan> list = this.hcCheckPlanGenMapper.selectByExample(example);
        this.setHcCheckPlanExtnedsInfoList(list);
        return list;
    }

    private void setHcCheckPlanExtnedsInfoList(List<HcCheckPlan> list) {
        for (HcCheckPlan checkPlan : list) {
            this.setHcCheckPlanExtnedsInfo(checkPlan);
        }
    }

    private void setHcCheckPlanExtnedsInfo(HcCheckPlan checkPlan) {
        if (checkPlan.getHcCheckplanlaunch() != null) {
            if (checkPlan.getHcCheckplanlaunch().getTpcompanyid() == null) {
                Company company = this.companyService.getCompanyByID(checkPlan.getCid());
                if (company != null) {
                    checkPlan.getHcCheckplanlaunch().setTpCompanyName(company.getName());
                }
            } else {
                TpCompany tpCompany = this.tpcompanyService.getTpCompanyById(checkPlan.getHcCheckplanlaunch().getTpcompanyid());
                if (tpCompany != null) {
                    checkPlan.getHcCheckplanlaunch().setTpCompanyName(tpCompany.getCompanyname());
                }
            }
        }
    }

    public List<HcCheckPlan> getHcCheckPlans(HcCheckPlan hc) {
        return this.hcCheckPlanMapper.getHcCheckPlans(hc);
    }

    public HcCheckPlan getHcCheckPlanById(Integer id) {
        HcCheckPlan checkPlan = this.hcCheckPlanMapper.getHcCheckPlanById(id);
        if (checkPlan != null) {
            this.setHcCheckPlanExtnedsInfo(checkPlan);
        }
        return checkPlan;
    }

    public HcCheckPlan insertHcCheckPlan(HcCheckPlan hc) {
        this.hcCheckPlanMapper.insertHcCheckPlan(hc);
        return hc;
    }

    public Integer updatestartPhasePlanById(HcCheckPlan hc) {
        return this.hcCheckPlanMapper.updatestartPhasePlanById(hc);
    }

    public List<HcCheckPlanArea> getCheckAreasByHcplantID(Integer hcplantID) {
        return this.hcCheckPlanAreaMapper.getCheckAreasByHcplantID(hcplantID);
    }

    public void updatePhaseById(HcCheckPlan hc) {
        this.hcCheckPlanMapper.updatePhaseById(hc);
    }

    public void deleteCheckAreasByPlanId(Integer id, Integer phase) {
        this.hcCheckPlanAreaMapper.deleteCheckAreasByPlanId(id, phase);
    }

    public HcCheckstorefile getHcCheckStoreFileByPid(Integer planId) {
        return this.hcCheckstorefileMapper.getHcCheckStoreFileByplantId(planId);
    }

    public void insertHcCheckstorefile(HcCheckstorefile hcf) {
        this.hcCheckstorefileMapper.insert(hcf);
    }

    public void updateHcCheckstorefile(HcCheckstorefile hcf) {
        this.hcCheckstorefileMapper.updateByPrimaryKey(hcf);
    }

    public void insertCheckAreas(List<HcCheckPlanArea> list) {
        this.hcCheckPlanAreaMapper.inserCheckAreas(list);
    }

    public HcCheckplanlaunch getCheckPlanLaunchPage(Integer planId) {
        return this.hcCheckplanlaunchMapper.getCheckPlanLaunchPage(planId);
    }

    public void deleteCheckPlanLaunchByPlanId(HcCheckplanlaunch hcl) {
        HcCheckplanlaunchExample e = new HcCheckplanlaunchExample();
        e.createCriteria().andHcplantidEqualTo(hcl.getHcplantid());
        this.hcCheckplanlaunchMapper.deleteByExample(e);
    }

    public void insertCheckPlanLaunch(HcCheckplanlaunch hcl) {
        this.hcCheckplanlaunchMapper.insert(hcl);
    }

    public List<HcCheckplantestschedule> getHcCheckplantestschedules(Integer pid) {
        HcCheckplantestscheduleExample he = new HcCheckplantestscheduleExample();
        he.createCriteria().andHcplantidEqualTo(pid);
        List<HcCheckplantestschedule> list = this.hcCheckplantestscheduleMapper.selectByExample(he);
        for (HcCheckplantestschedule h : list) {
            HcCheckplantestscheduledeptExample e = new HcCheckplantestscheduledeptExample();
            e.createCriteria().andScheduleidEqualTo(h.getId());
            h.setListDept(this.hcCheckplantestscheduledeptMapper.selectByExample(e));
        }
        return list;
    }

    public HcCheckplantestschedule getTestScheduleById(Integer id) {
        HcCheckplantestschedule h = this.hcCheckplantestscheduleMapper.selectByPrimaryKey(id);
        HcCheckplantestscheduledeptExample e = new HcCheckplantestscheduledeptExample();
        e.createCriteria().andScheduleidEqualTo(h.getId());
        h.setListDept(this.hcCheckplantestscheduledeptMapper.selectByExample(e));
        return h;
    }

    public void delTestSchedule(Integer id) {
        this.hcCheckplantestscheduleMapper.deleteByPrimaryKey(id);
        HcCheckplantestscheduledeptExample e = new HcCheckplantestscheduledeptExample();
        e.createCriteria().andScheduleidEqualTo(id);
        this.hcCheckplantestscheduledeptMapper.deleteByExample(e);
    }

    public Integer insertHcCheckplantestschedule(HcCheckplantestschedule hcs) {
        return this.hcCheckplantestscheduleMapper.insert(hcs);
    }

    public void insertHcCheckplantestscheduledepts(List<HcCheckplantestscheduledept> list) {
        HcCheckplantestscheduledeptExample e = new HcCheckplantestscheduledeptExample();
        e.createCriteria().andScheduleidEqualTo(list.get(0).getScheduleid());
        this.hcCheckplantestscheduledeptMapper.deleteByExample(e);
        this.hcCheckplantestscheduledeptMapper.insertList(list);
    }

    public void updateHcCheckplantestschedule(HcCheckplantestschedule hcs) {
        this.hcCheckplantestscheduleMapper.updateByPrimaryKey(hcs);
    }

    public void updateLaunchPhaseById(HcCheckPlan hc) {
        this.hcCheckPlanMapper.updateLaunchPhasePlanById(hc);
    }

    public List<HcSamplingprocess> findSamplingProcessesByPid(Integer id) {
        HcSamplingprocessExample e = new HcSamplingprocessExample();
        e.createCriteria().andHcplantidEqualTo(id);
        return this.hcSamplingprocessMapper.selectByExample(e);
    }

    public List<HcSamplingstaff> findSamplingStaffsByPid(Integer id) {
        HcSamplingstaffExample e = new HcSamplingstaffExample();
        e.createCriteria().andHcplantidEqualTo(id);
        return this.hcSamplingstaffMapper.selectByExample(e);
    }

    public List<HcSamplingsolution> findSamplingSolutionsByPid(Integer id) {
        HcSamplingsolutionExample e = new HcSamplingsolutionExample();
        e.createCriteria().andHcplantidEqualTo(id);
        return this.hcSamplingsolutionMapper.selectByExample(e);
    }

    public HcSamplingprocess selectProcessById(Integer id) {
        return this.hcSamplingprocessMapper.selectByPrimaryKey(id);
    }

    public void insertSamplingProcess(HcSamplingprocess p) {
        this.hcSamplingprocessMapper.insert(p);
    }

    public void updateSamlingProcessById(HcSamplingprocess p) {
        this.hcSamplingprocessMapper.updateByPrimaryKey(p);
    }

    public void insertSamplingProcessFiles(List<HcSamplingprocessfiles> list) {
        this.hcSamplingprocessfilesMapper.insertList(list);
    }

    public void insertSamplingStaffs(List<HcSamplingstaff> list) {
        this.hcSamplingstaffMapper.insertList(list);
    }

    public void insertSamplingSolutions(List<HcSamplingsolution> list) {
        this.hcSamplingsolutionMapper.insertList(list);
    }

    public void updateCollectPhaseById(HcCheckPlan hc) {
        this.hcCheckPlanMapper.updateCollectPhaseById(hc);
    }

    public List<HcCheckresult> getHcCheckresultByPid(Integer pid) {
        HcCheckresultExample he = new HcCheckresultExample();
        he.createCriteria().andHcplantidEqualTo(pid);
        List<HcCheckresult> list = this.hcCheckresultMapper.selectByExample(he);
        return list;
    }

    public List<HcCheckresultdata> getHcCheckresultdata(Integer rid, Integer tid) {
        HcCheckresultdataExample e = new HcCheckresultdataExample();
        e.createCriteria().andResultidEqualTo(rid);
        e.createCriteria().andDatatypeEqualTo(tid);
        return this.hcCheckresultdataMapper.selectByExample(e);
    }

    public void addHcCheckResult(HcCheckresult hr) {
        this.hcCheckresultMapper.insert(hr);
    }

    public void deleteHcCheckResult(Integer pid) {
        HcCheckresultExample he = new HcCheckresultExample();
        he.createCriteria().andHcplantidEqualTo(pid);
        this.hcCheckresultMapper.deleteByExample(he);
    }

    public List<HcCheckresultdata> getHcCheckresultdataByRowId(Integer rowId) {
        HcCheckresultdataExample e = new HcCheckresultdataExample();
        e.createCriteria().andDatacodeEqualTo(rowId + "");
        return this.hcCheckresultdataMapper.selectByExample(e);
    }

    public void deleteHcCheckresultdataByDatacode(String rowId) {
        HcCheckresultdataExample e = new HcCheckresultdataExample();
        e.createCriteria().andDatacodeEqualTo(rowId);
        this.hcCheckresultdataMapper.deleteByExample(e);
    }

    public void insertHcCheckresultdata(HcCheckresultdata h) {
        this.hcCheckresultdataMapper.insert(h);
    }

    public void updateResultIdByHarmId() {
        this.hcCheckresultdataMapper.updateResultIdByHarmId();
    }

    public List<HcCheckPlan> getHcCheckPlansByAreaId(Integer areaId) {
        return this.hcCheckPlanMapper.getHcCheckPlansByAreaId(areaId);
    }

    public List<HcCheckPlan> getHcCheckPlansByWorkId(Integer workId) {
        return this.hcCheckPlanMapper.getHcCheckPlansByWorkId(workId);
    }

    @Override
    public void workflow(WorkFlowParam param, Integer orderId) {
        if (param.getApproved().booleanValue() && param.getEnd().booleanValue()) {
            HcCheckPlan hc = new HcCheckPlan();
            hc.setId(param.getBusinessId());
            hc.setPhase(Integer.valueOf(param.getBusinessPhase()) + 1);
            this.hcCheckPlanMapper.updatePhaseById(hc);
        }
    }

    @Override
    public String doTask(Integer businessId, String taskName) {
        if ("approve".equals(taskName)) {
            return "forward:/hccheckplan/gohccheckplanapprove?id=" + businessId;
        }
        if ("read".equals(taskName)) {
            return "forward:/hccheckplan/gohccheckplaninform?id=" + businessId;
        }
        if ("apply".equals(taskName)) {
            return "forward:/hccheckplan/gohccheckplanapply?id=" + businessId;
        }
        if ("inform".equals(taskName)) {
            return "forward:/hccheckplan/gohccheckplaninformshow?id=" + businessId;
        }
        return "forward:/hccheckplan/gohccheckplanview?id=" + businessId;
    }

    @Override
    public String doApproveTask(Integer businessId) {
        return null;
    }

    @Override
    public int terminateTask(Integer businessId) {
        return 0;
    }

    @Override
    public String addWorkUrl() {
        return null;
    }

    public List<HcCheckplaninform> getInforms(Integer hid) {
        HcCheckplaninformExample e = new HcCheckplaninformExample();
        e.createCriteria().andHidEqualTo(hid);
        return this.hcCheckplaninformMapper.selectByExample(e);
    }

    public Integer getInformCount(Integer hid) {
        HcCheckplaninformExample e = new HcCheckplaninformExample();
        e.createCriteria().andHidEqualTo(hid);
        return this.hcCheckplaninformMapper.countByExample(e);
    }

    @Override
    public String workflowInform(WorkFlowParam param, Integer orderId) {
        if (orderId == null) {
            String[] informers;
            for (String s : informers = param.getReceiver().split(",")) {
                HcCheckplaninform h = new HcCheckplaninform();
                h.setHid(param.getBusinessId());
                h.setInformstaff(Integer.valueOf(s));
                h.setResult(0);
                h.setInformtime(new Date());
                this.hcCheckplaninformMapper.insert(h);
            }
        } else {
            HcCheckplaninform h = new HcCheckplaninform();
            h.setFeedbacktime(new Date());
            h.setHid(param.getBusinessId());
            h.setInformstaff(Integer.valueOf(param.getReceiver()));
            h.setRemark(param.getRemark());
            h.setResult(param.getApproved() != false ? 1 : 2);
            HcCheckplaninformExample e = new HcCheckplaninformExample();
            e.createCriteria().andHidEqualTo(h.getHid()).andInformstaffEqualTo(h.getInformstaff());
            this.hcCheckplaninformMapper.updateByExampleSelective(h, e);
        }
        return "";
    }

    public List<HcCheckPlanInformStat> getHcCheckPlanInformStatByhid(Integer hid) {
        return this.hcCheckplaninformMapper.getHcCheckPlanInformStatByhid(hid);
    }

    public List<HcCheckplaninform> getHcCheckPlanInforms(Integer hid, Integer result, String informTime) throws ParseException {
        HcCheckplaninformExample e = new HcCheckplaninformExample();
        HcCheckplaninformExample.Criteria c = e.createCriteria();
        if (result != null) {
            c.andResultEqualTo(result);
        }
        c.andHidEqualTo(hid).andInformtimeBetween(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(informTime + " 00:00:00"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(informTime + " 23:59:59"));
        return this.hcCheckplaninformMapper.selectByExample(e);
    }

    public List<RefReformitem> getRectificationItemsByHcCheckPlan(Integer pid) {
        RefReformitemExample rfe = new RefReformitemExample();
        rfe.createCriteria().andSourceEqualTo("\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b").andResultidEqualTo(pid);
        List<RefReformitem> list = this.refReformitemMapper.selectByExample(rfe);
        return list;
    }

    public List<HcCheckresultdata> getCheckResultDataLowQualityByHid(Integer hid) {
        return this.hcCheckresultdataMapper.getCheckResultDataLowQualityByHid(hid);
    }

    public List<HcCheckresultdata> getCheckResultDataLowQualityByRowids(String rowidStr) {
        return this.hcCheckresultdataMapper.getCheckResultDataLowQualityByRowids(("'" + rowidStr + "'").replaceAll(",", "','"));
    }

    public Integer saveRefReformitem(RefReformitemWithBLOBs rfi) {
        Integer id = this.refReformitemMapper.insertSelective(rfi);
        for (RefReformfile f : rfi.getFileList()) {
            f.setItemid(rfi.getId());
            this.refReformfileMapper.insert(f);
        }
        rfi.getPhase().setItemid(rfi.getId());
        this.reformphaseMapper.insertSelective(rfi.getPhase());
        return id;
    }

    public RefReformitemWithBLOBs findRefReformitemById(Integer id) {
        return this.refReformitemMapper.selectByPrimaryKey(id);
    }

    public List<HcCheckrelated> getHcCheckrelatedByhid(Integer hid) {
        HcCheckrelatedExample e = new HcCheckrelatedExample();
        e.createCriteria().andHcplantidEqualTo(hid);
        List<HcCheckrelated> list = this.hcCheckrelatedMapper.selectByExample(e);
        return list;
    }

    public void stopHcCheckPlan(String ids) {
        this.hcCheckPlanMapper.stopHcCheckPlan(ids);
    }
}

