/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.emergency.material;

import cn.smarthse.core.dao.emergency.material.EmeMaterialrentitemMapper;
import cn.smarthse.core.model.emergency.material.EmeMaterialrentitem;
import cn.smarthse.core.model.emergency.material.EmeMaterialrentitemExample;
import cn.smarthse.core.model.emergency.material.EmeMaterialrentitemVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmeMaterialrentitemService {
    @Autowired
    EmeMaterialrentitemMapper mapper;

    public List<EmeMaterialrentitem> list(EmeMaterialrentitem item) {
        EmeMaterialrentitemExample example = new EmeMaterialrentitemExample();
        EmeMaterialrentitemExample.Criteria criteria = example.createCriteria();
        if (item.getRentid() != null) {
            criteria.andRentidEqualTo(item.getRentid());
        }
        if (item.getIsreturn() != null) {
            criteria.andIsreturnEqualTo(item.getIsreturn());
        }
        return this.mapper.selectByExample(example);
    }

    public int addBatch(List<EmeMaterialrentitem> array) {
        if (array == null || array.size() == 0) {
            return 0;
        }
        return this.mapper.addBatch(array);
    }

    public int deleteByPid(Integer pid) {
        EmeMaterialrentitemExample example = new EmeMaterialrentitemExample();
        EmeMaterialrentitemExample.Criteria criteria = example.createCriteria();
        criteria.andRentidEqualTo(pid);
        return this.mapper.deleteByExample(example);
    }

    public void updateBatch(Integer pid, List<EmeMaterialrentitem> array) {
        this.deleteByPid(pid);
        if (array == null || array.size() == 0) {
            return;
        }
        ArrayList<EmeMaterialrentitem> insertArray = new ArrayList<EmeMaterialrentitem>();
        for (EmeMaterialrentitem a : array) {
            if (a.getRentcount() == null) continue;
            a.setRentid(pid);
            a.setIsreturn(Byte.parseByte("0"));
            insertArray.add(a);
        }
        this.addBatch(insertArray);
    }

    public List<EmeMaterialrentitemVO> listBackInfo(Integer rentid) {
        return this.mapper.listBackInfo(rentid);
    }

    public void back(EmeMaterialrentitem item) {
        try {
            EmeMaterialrentitem info = this.mapper.selectByPrimaryKey(item.getId());
            if (info == null) {
                return;
            }
            item.setIsreturn(info.getRentcount() == item.getBackcount() ? Byte.parseByte("1") : Byte.parseByte("0"));
            item.setReturndate(new Date());
            this.mapper.back(item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<EmeMaterialrentitemVO> listBackInfo(Integer rentid, String mname) {
        EmeMaterialrentitemVO vo = new EmeMaterialrentitemVO();
        vo.setRentid(rentid);
        vo.setMname(mname);
        return this.mapper.listBackInfoByQuery(vo);
    }
}

