/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.emergency.material;

import cn.smarthse.core.dao.emergency.material.EmeMaterialrentMapper;
import cn.smarthse.core.framework.enums.ApproveResult;
import cn.smarthse.core.framework.enums.Modulars;
import cn.smarthse.core.model.emergency.material.EmeMaterialrent;
import cn.smarthse.core.model.emergency.material.EmeMaterialrentExample;
import cn.smarthse.core.model.emergency.material.EmeMaterialrentitem;
import cn.smarthse.core.model.flow.WfModular;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.emergency.material.EmeMaterialrentitemService;
import cn.smarthse.core.service.workflow.GeneralWorkFlowService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmeMaterialrentService {
    @Autowired
    EmeMaterialrentMapper mapper;
    @Autowired
    EmeMaterialrentitemService itemService;
    @Autowired
    GeneralWorkFlowService workflowService;

    public List<EmeMaterialrent> list(EmeMaterialrent info) {
        EmeMaterialrentExample example = new EmeMaterialrentExample();
        EmeMaterialrentExample.Criteria criteria = example.createCriteria();
        if (info.getRentstate() != null) {
            criteria.andRentstateEqualTo(info.getRentstate());
        }
        return this.mapper.selectByExample(example);
    }

    public int updateState(List<Integer> ids, Byte state) {
        if (ids == null || ids.size() == 0) {
            return 0;
        }
        EmeMaterialrentExample example = new EmeMaterialrentExample();
        EmeMaterialrentExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)ids);
        EmeMaterialrent record = new EmeMaterialrent();
        record.setRentstate(state);
        return this.mapper.updateByExampleSelective(record, example);
    }

    public int update(EmeMaterialrent info) {
        this.mapper.updateByPrimaryKey(info);
        this.itemService.updateBatch(info.getId(), info.getItems());
        return 1;
    }

    public int insert(EmeMaterialrent info) {
        this.mapper.insert(info);
        this.itemService.updateBatch(info.getId(), info.getItems());
        return 1;
    }

    public EmeMaterialrent get(Integer id) {
        EmeMaterialrent info = this.mapper.selectByPrimaryKey(id);
        if (info != null) {
            EmeMaterialrentitem item = new EmeMaterialrentitem();
            if (info.getRentstate() == null || info.getRentstate() == 0) {
                item.setIsreturn(Byte.parseByte("0"));
            } else {
                item.setIsreturn(Byte.parseByte("1"));
            }
            item.setRentid(id);
            info.setItems(this.itemService.list(item));
        }
        return info;
    }

    public String getBusinessPath(Integer businessId, Boolean isApprove) {
        int approve = isApprove != false ? 1 : 0;
        try {
            return "forward:/emeMaterialrents/info?approve=" + approve + "&id=" + businessId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "/commons/404";
        }
    }

    public void workflow(WorkFlowParam param, Integer orderId) {
        EmeMaterialrent record = this.mapper.selectByPrimaryKey(param.getBusinessId());
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            if (record.getPhase() == 1) {
                this.updateStatus(param.getBusinessId(), (byte)1, 2);
            }
            if (record.getPhase() == 2) {
                this.updateStatus(param.getBusinessId(), (byte)2, record.getPhase());
            }
        }
        if (param.getEnd().booleanValue()) {
            param.getApproved().booleanValue();
        }
    }

    public void updateStatus(Integer id, Byte status, Integer phase) {
        EmeMaterialrent record = new EmeMaterialrent();
        record.setId(id);
        record.setRentstate(status);
        record.setPhase(phase);
        this.mapper.updateByPrimaryKeySelective(record);
    }

    public String goNextState(Integer id) {
        String url = "redirect:/emeMaterialrents/info?id=" + id;
        EmeMaterialrent record = this.get(id);
        switch (record.getPhase()) {
            case 1: {
                record.setRentstate((byte)1);
                record.setPhase(2);
                break;
            }
            case 2: {
                record.setRentstate((byte)2);
                url = "redirect:/emeMaterialrents?rentstate=2";
            }
        }
        this.setNoApprove(id, record.getPhase(), record.getRentstate().byteValue());
        this.updateStatus(id, record.getRentstate(), record.getPhase());
        return url;
    }

    private void setNoApprove(Integer id, int phase, int status) {
        WfModular wfModular = new WfModular();
        wfModular.setModularId(Modulars.emeMaterialrents.getValue());
        wfModular.setPhase(phase);
        wfModular.setSolutionId(id);
        wfModular.setStatus(status);
        wfModular.setWorkflowId(null);
        wfModular.setApproveResult(ApproveResult.approvePass.getValue());
        wfModular.setApproveNum(this.workflowService.getWfModularMaxApproveNum(wfModular.getSolutionId(), wfModular.getModularId(), wfModular.getPhase()));
        this.workflowService.saveWfModularInfo(wfModular);
    }
}

