/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.emergency.material;

import cn.smarthse.core.dao.emergency.material.EmeMaterialMapper;
import cn.smarthse.core.model.emergency.material.EmeMaterial;
import cn.smarthse.core.model.emergency.material.EmeMaterialExample;
import cn.smarthse.core.service.emergency.material.EmeMaterialExtendDataService;
import cn.smarthse.core.service.emergency.material.EmeMaterialFileService;
import cn.smarthse.core.service.filegroup.FileGroupService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmeMaterialService {
    @Autowired
    EmeMaterialMapper mapper;
    @Autowired
    EmeMaterialFileService emeMaterialFileService;
    @Autowired
    FileGroupService fileGroupService;
    @Autowired
    EmeMaterialExtendDataService emeMaterialExtendDataService;
    private String groupName = "emeMaterial";

    public EmeMaterial get(Integer id) {
        EmeMaterial detail = this.mapper.selectByPrimaryKey(id);
        detail.setMaterialfiles(this.emeMaterialFileService.listByPid(id));
        detail.setOtherfiles(this.fileGroupService.listByPidAndGroup(id, this.groupName));
        detail.setExtenddatas(this.emeMaterialExtendDataService.listByPid(id));
        return detail;
    }

    public List<EmeMaterial> list(EmeMaterial info) {
        return this.mapper.list(info);
    }

    public void update(EmeMaterial info) {
        this.mapper.updateByPrimaryKey(info);
        this.updateChildren(info);
    }

    public void insert(EmeMaterial info) {
        this.mapper.insert(info);
        this.updateChildren(info);
    }

    public void updateChildren(EmeMaterial info) {
        this.emeMaterialFileService.updateBatch(info.getId(), info.getMaterialfiles());
        this.fileGroupService.updateFileGroup(info.getId(), this.groupName, info.getOtherfiles());
        this.emeMaterialExtendDataService.updateBatch(info.getId(), info.getExtenddatas());
    }

    public List<EmeMaterial> getListByCompanyId(Integer companyId) {
        EmeMaterialExample example = new EmeMaterialExample();
        example.createCriteria().andCidEqualTo(companyId);
        List<EmeMaterial> list = this.mapper.selectByExample(example);
        return list;
    }

    public void delete(List<Integer> idList) {
        if (idList == null || idList.size() == 0) {
            return;
        }
        EmeMaterialExample example = new EmeMaterialExample();
        example.createCriteria().andIdIn((List)idList);
        this.mapper.deleteByExample(example);
    }
}

