/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.emergency.material;

import cn.smarthse.core.dao.emergency.material.EmeMaterialfileMapper;
import cn.smarthse.core.model.emergency.material.EmeMaterialfile;
import cn.smarthse.core.model.emergency.material.EmeMaterialfileExample;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmeMaterialFileService {
    @Autowired
    EmeMaterialfileMapper mapper;

    public List<EmeMaterialfile> listByPid(Integer pid) {
        EmeMaterialfileExample example = new EmeMaterialfileExample();
        EmeMaterialfileExample.Criteria criteria = example.createCriteria();
        criteria.andMaterialidEqualTo(pid);
        return this.mapper.selectByExample(example);
    }

    public int deleteById(Integer id) {
        return this.mapper.deleteByPrimaryKey(id);
    }

    public int addBatch(List<EmeMaterialfile> array) {
        if (array == null || array.size() == 0) {
            return 0;
        }
        return this.mapper.addBatch(array);
    }

    public int deleteByPid(Integer pid) {
        EmeMaterialfileExample example = new EmeMaterialfileExample();
        EmeMaterialfileExample.Criteria criteria = example.createCriteria();
        criteria.andMaterialidEqualTo(pid);
        return this.mapper.deleteByExample(example);
    }

    public void updateBatch(Integer pid, List<EmeMaterialfile> array) {
        this.deleteByPid(pid);
        if (array == null || array.size() == 0) {
            return;
        }
        ArrayList<EmeMaterialfile> insertArray = new ArrayList<EmeMaterialfile>();
        for (EmeMaterialfile a : array) {
            if (StringUtils.isEmpty((String)a.getCername())) continue;
            a.setMaterialid(pid);
            insertArray.add(a);
        }
        this.addBatch(insertArray);
    }
}

