/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.emergency.accident;

import cn.smarthse.core.dao.emergency.accident.EmeAccidentinfoMapper;
import cn.smarthse.core.framework.enums.ApproveResult;
import cn.smarthse.core.framework.enums.Modulars;
import cn.smarthse.core.model.emergency.accident.EmeAccidentinfo;
import cn.smarthse.core.model.emergency.accident.EmeAccidentinfoExample;
import cn.smarthse.core.model.emergency.accident.EmeAccidentinfoWithBLOBs;
import cn.smarthse.core.model.emergency.accident.EmeAccidentinfohappens;
import cn.smarthse.core.model.emergency.accident.EmeAccidentinforeport;
import cn.smarthse.core.model.flow.WfModular;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.emergency.accident.EmeAccidentinfodescribeService;
import cn.smarthse.core.service.emergency.accident.EmeAccidentinfohappensService;
import cn.smarthse.core.service.emergency.accident.EmeAccidentinforeportService;
import cn.smarthse.core.service.filegroup.FileGroupService;
import cn.smarthse.core.service.workflow.GeneralWorkFlowService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmeAccidentInfoService {
    @Autowired
    EmeAccidentinfoMapper mapper;
    @Autowired
    FileGroupService fileGroupService;
    @Autowired
    EmeAccidentinfohappensService emeAccidentinfohappensService;
    @Autowired
    EmeAccidentinfodescribeService emeAccidentinfodescribeService;
    @Autowired
    EmeAccidentinforeportService emeAccidentinforeportService;
    private String groupName = "emeAccidentInfos";
    @Autowired
    GeneralWorkFlowService workflowService;

    public List<EmeAccidentinfo> list(EmeAccidentinfo info) {
        EmeAccidentinfoExample example = new EmeAccidentinfoExample();
        EmeAccidentinfoExample.Criteria criteria = example.createCriteria();
        if (info.getStatus() != null) {
            criteria.andStatusEqualTo(info.getStatus());
        }
        return this.mapper.selectByExample(example);
    }

    public EmeAccidentinfoWithBLOBs get(Integer id) {
        EmeAccidentinfoWithBLOBs info = this.mapper.selectByPrimaryKey(id);
        EmeAccidentinfohappens item = new EmeAccidentinfohappens();
        item.setAccidentinfoid(id);
        info.setHappens(this.emeAccidentinfohappensService.list(item));
        info.setDesc(this.emeAccidentinfodescribeService.getByPid(id));
        EmeAccidentinforeport report = new EmeAccidentinforeport();
        report.setAccidentinfoid(id);
        info.setReports(this.emeAccidentinforeportService.list(report));
        info.setFiles(this.fileGroupService.listByPidAndGroup(id, this.groupName));
        return info;
    }

    public int insertOrUpdate(EmeAccidentinfoWithBLOBs info) {
        if (info.getId() != null) {
            this.mapper.updateByPrimaryKeyWithBLOBs(info);
        } else {
            info.setStatus(Byte.parseByte("0"));
            info.setPhase(Byte.parseByte("1"));
            this.mapper.insert(info);
        }
        this.updateChildren(info);
        return 1;
    }

    public void updateChildren(EmeAccidentinfoWithBLOBs info) {
        this.fileGroupService.updateFileGroup(info.getId(), this.groupName, info.getFiles());
        this.emeAccidentinfohappensService.updateBatch(info.getId(), info.getHappens());
        this.emeAccidentinfodescribeService.insertOrUpdate(info.getId(), info.getDesc());
        this.emeAccidentinforeportService.updateBatch(info.getId(), info.getReports());
    }

    public int updateState(List<Integer> ids, Byte state) {
        if (ids == null || ids.size() == 0) {
            return 0;
        }
        EmeAccidentinfoExample example = new EmeAccidentinfoExample();
        EmeAccidentinfoExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)ids);
        EmeAccidentinfoWithBLOBs record = new EmeAccidentinfoWithBLOBs();
        record.setStatus(state);
        return this.mapper.updateByExampleSelective(record, example);
    }

    public String getBusinessPath(Integer businessId, Boolean isApprove) {
        int approve = isApprove != false ? 1 : 0;
        try {
            return "forward:/emeAccidentInfos/info?approve=" + approve + "&id=" + businessId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "/commons/404";
        }
    }

    public void workflow(WorkFlowParam param, Integer orderId) {
        EmeAccidentinfoWithBLOBs record = this.mapper.selectByPrimaryKey(param.getBusinessId());
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue() && record.getPhase() == 1) {
            this.updateStatus(param.getBusinessId(), (byte)1, record.getPhase());
        }
        if (param.getEnd().booleanValue()) {
            param.getApproved().booleanValue();
        }
    }

    public void updateStatus(Integer id, Byte status, Byte phase) {
        EmeAccidentinfoWithBLOBs record = new EmeAccidentinfoWithBLOBs();
        record.setId(id);
        record.setStatus(status);
        record.setPhase(phase);
        this.mapper.updateByPrimaryKeySelective(record);
    }

    public String goNextState(Integer id) {
        EmeAccidentinfoWithBLOBs record = this.mapper.selectByPrimaryKey(id);
        record.setStatus((byte)1);
        this.setNoApprove(id, record.getPhase().byteValue(), record.getStatus().byteValue());
        this.updateStatus(id, record.getStatus(), record.getPhase());
        return "redirect:/emeAccidentInfos?status=1";
    }

    private void setNoApprove(Integer id, int phase, int status) {
        WfModular wfModular = new WfModular();
        wfModular.setModularId(Modulars.emeAccidentInfos.getValue());
        wfModular.setPhase(phase);
        wfModular.setSolutionId(id);
        wfModular.setStatus(status);
        wfModular.setWorkflowId(null);
        wfModular.setApproveResult(ApproveResult.approvePass.getValue());
        wfModular.setApproveNum(this.workflowService.getWfModularMaxApproveNum(wfModular.getSolutionId(), wfModular.getModularId(), wfModular.getPhase()));
        this.workflowService.saveWfModularInfo(wfModular);
    }
}

