/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.emergency;

import cn.smarthse.core.dao.emergency.EmeDrillsumMapper;
import cn.smarthse.core.model.emergency.EmeDrillsum;
import cn.smarthse.core.model.emergency.EmeDrillsumExample;
import cn.smarthse.core.model.emergency.EmeDrillsumWithBLOBs;
import cn.smarthse.core.service.filegroup.FileGroupService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmeDrillsumService {
    @Autowired
    EmeDrillsumMapper mapper;
    @Autowired
    FileGroupService fileGroupService;
    private String emeDrillsumFiles = "emeDrillsumFiles";

    public EmeDrillsumWithBLOBs getDetailByPid(Integer pid) {
        EmeDrillsumExample example = new EmeDrillsumExample();
        EmeDrillsumExample.Criteria criteria = example.createCriteria();
        criteria.andDrillidEqualTo(pid);
        List<EmeDrillsumWithBLOBs> details = this.mapper.selectByExampleWithBLOBs(example);
        EmeDrillsum detail = null;
        if (details != null && details.size() > 0) {
            detail = details.get(0);
        }
        if (detail != null) {
            detail.setFiles(this.fileGroupService.listByPidAndGroup(detail.getId(), this.emeDrillsumFiles));
        }
        return detail;
    }

    public void updateOrInsert(EmeDrillsumWithBLOBs info, Integer pid) {
        info.setDrillid(pid);
        if (info.getId() == null) {
            this.mapper.insert(info);
        } else {
            this.mapper.updateByPrimaryKeyWithBLOBs(info);
        }
        this.fileGroupService.updateFileGroup(info.getId(), this.emeDrillsumFiles, info.getFiles());
    }
}

