/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.emergency;

import cn.smarthse.core.dao.emergency.EmeDrillrecordMapper;
import cn.smarthse.core.model.emergency.EmeDrillrecordExample;
import cn.smarthse.core.model.emergency.EmeDrillrecordWithBLOBs;
import cn.smarthse.core.service.filegroup.FileGroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmeDrillrecordService {
    @Autowired
    EmeDrillrecordMapper mapper;
    @Autowired
    FileGroupService fileGroupService;
    private String emeDrillRecordSign = "emeDrillRecordSign";
    private String emeDrillRecordMedia = "emeDrillRecordMedia";
    private String emeDrillRecordOtherFile = "emeDrillRecordOtherFile";

    public EmeDrillrecordWithBLOBs getDetailByPid(Integer pid) {
        EmeDrillrecordWithBLOBs detail = this.mapper.getDetailByPid(pid);
        if (detail != null) {
            detail.setSignFiles(this.fileGroupService.listByPidAndGroup(detail.getId(), this.emeDrillRecordSign));
            detail.setMediaFiles(this.fileGroupService.listByPidAndGroup(detail.getId(), this.emeDrillRecordMedia));
            detail.setOtherFiles(this.fileGroupService.listByPidAndGroup(detail.getId(), this.emeDrillRecordOtherFile));
        }
        return detail;
    }

    public void deleteByPid(Integer pid) {
        EmeDrillrecordExample example = new EmeDrillrecordExample();
        example.createCriteria().andDrillidEqualTo(pid);
        this.mapper.deleteByExample(example);
    }

    public void updateOrInsert(EmeDrillrecordWithBLOBs info, Integer pid) {
        if (pid != null) {
            this.deleteByPid(pid);
        }
        info.setDrillid(pid);
        if (info.getId() == null) {
            this.mapper.insert(info);
        } else {
            this.mapper.updateByPrimaryKeyWithBLOBs(info);
        }
        this.fileGroupService.updateFileGroup(info.getId(), this.emeDrillRecordSign, info.getSignFiles());
        this.fileGroupService.updateFileGroup(info.getId(), this.emeDrillRecordMedia, info.getMediaFiles());
        this.fileGroupService.updateFileGroup(info.getId(), this.emeDrillRecordOtherFile, info.getOtherFiles());
    }

    public void insert(EmeDrillrecordWithBLOBs info) {
        this.mapper.insert(info);
    }

    public void update(EmeDrillrecordWithBLOBs info) {
        this.mapper.updateByPrimaryKeyWithBLOBs(info);
    }
}

