/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.emergency;

import cn.smarthse.core.dao.emergency.EmeDrillMapper;
import cn.smarthse.core.dao.emergency.EmeDrillinformMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.framework.enums.ApproveResult;
import cn.smarthse.core.framework.enums.EmeDrillPage;
import cn.smarthse.core.framework.enums.Modulars;
import cn.smarthse.core.model.basic.Staff;
import cn.smarthse.core.model.emergency.EmeDrill;
import cn.smarthse.core.model.emergency.EmeDrillExample;
import cn.smarthse.core.model.emergency.EmeDrillinform;
import cn.smarthse.core.model.emergency.EmeDrillinformExample;
import cn.smarthse.core.model.flow.WfModular;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.basic.staff.StaffService;
import cn.smarthse.core.service.emergency.EmeDrillPeopleService;
import cn.smarthse.core.service.emergency.EmeDrillrecordService;
import cn.smarthse.core.service.emergency.EmeDrillstorefileService;
import cn.smarthse.core.service.emergency.EmeDrillsumService;
import cn.smarthse.core.service.emergency.EmeDrillteamService;
import cn.smarthse.core.service.filegroup.FileGroupService;
import cn.smarthse.core.service.workflow.GeneralWorkFlowService;
import cn.smarthse.core.service.workflow.IWorkflowService;
import cn.smarthse.core.service.workflow.SnakerEngineFacets;
import cn.smarthse.core.util.LoginUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmeDrillService
implements IWorkflowService {
    @Autowired
    EmeDrillMapper mapper;
    @Autowired
    EmeDrillPeopleService actorService;
    @Autowired
    FileGroupService fileGroupService;
    @Autowired
    EmeDrillteamService emeDrillteamService;
    @Autowired
    EmeDrillrecordService emeDrillrecordService;
    @Autowired
    EmeDrillsumService emeDrillsumService;
    @Autowired
    EmeDrillstorefileService emeDrillstorefileService;
    @Autowired
    EmeDrillinformMapper informMapper;
    @Autowired
    private StaffService staffService;
    @Autowired
    private SnakerEngineFacets facets;
    private String schemeFileGroupName = "EmeDrill_Scheme";
    @Autowired
    GeneralWorkFlowService workflowService;

    public List<EmeDrill> list(EmeDrill e) {
        return this.mapper.list(e);
    }

    public EmeDrill get(Integer id) {
        EmeDrill info = this.mapper.selectDetailById(id);
        info.setActors(this.actorService.listByPid(id));
        info.setSchemeFiles(this.fileGroupService.listByPidAndGroup(id, this.schemeFileGroupName));
        info.setLeaders(this.emeDrillteamService.listByPid(id));
        info.setRecord(this.emeDrillrecordService.getDetailByPid(id));
        info.setSummary(this.emeDrillsumService.getDetailByPid(id));
        info.setStoreFile(this.emeDrillstorefileService.getDetailByPid(id));
        return info;
    }

    public int insert(EmeDrill e) {
        this.mapper.insert(e);
        this.updateActors(e);
        this.fileGroupService.updateFileGroup(e.getId(), this.schemeFileGroupName, e.getSchemeFiles());
        return 1;
    }

    public int update(EmeDrill e) {
        this.mapper.updateByPrimaryKeyWithBLOBs(e);
        this.updateActors(e);
        return 1;
    }

    public int delete(Integer id) {
        return this.mapper.deleteByPrimaryKey(id);
    }

    public void updateActors(EmeDrill e) {
        this.actorService.deleteByPid(e.getId());
        this.actorService.addBatch(e.getActors(), e.getId());
    }

    public void scheme(EmeDrill info) {
        this.mapper.scheme(info);
        this.updateActors(info);
        this.fileGroupService.updateFileGroup(info.getId(), this.schemeFileGroupName, info.getSchemeFiles());
    }

    public void record(EmeDrill info) {
        this.mapper.updateByPrimaryKeySelective(info);
        this.emeDrillrecordService.updateOrInsert(info.getRecord(), info.getId());
    }

    public void summary(EmeDrill info) {
        this.emeDrillsumService.updateOrInsert(info.getSummary(), info.getId());
    }

    public void finish(EmeDrill info) {
        this.emeDrillstorefileService.updateOrInsert(info.getStoreFile(), info.getId());
    }

    public void all(EmeDrill info) {
        if (info.getId() != null) {
            this.update(info);
        } else {
            this.insert(info);
        }
        this.fileGroupService.updateFileGroup(info.getId(), this.schemeFileGroupName, info.getSchemeFiles());
        this.emeDrillrecordService.updateOrInsert(info.getRecord(), info.getId());
        this.emeDrillsumService.updateOrInsert(info.getSummary(), info.getId());
        this.emeDrillstorefileService.updateOrInsert(info.getStoreFile(), info.getId());
    }

    public String getBusinessPath(Integer businessId, Boolean isApprove) {
        EmeDrill record = this.mapper.selectDetailById(businessId);
        Integer phase = record.getPhase();
        String page = EmeDrillPage.getName(phase);
        int approve = isApprove != false ? 1 : 0;
        try {
            return "forward:/emeDrills/" + page + "?approve=" + approve + "&id=" + businessId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "/commons/404";
        }
    }

    public String goNextState(Integer id) {
        EmeDrill record = this.mapper.selectDetailById(id);
        Integer phase = record.getPhase();
        Integer status = record.getStatus();
        if (record.getPhase() == 1) {
            phase = 3;
        } else if (record.getPhase() == 3) {
            phase = 5;
        } else if (record.getPhase() == 5) {
            phase = 7;
        } else if (record.getPhase() == 7) {
            phase = 9;
        } else if (record.getPhase() == 9) {
            phase = 11;
            status = 1;
        } else if (record.getPhase() == 11) {
            phase = 11;
            status = 1;
        }
        this.updateStatus(id, status, phase);
        this.setNoApprove(id, record.getPhase(), record.getStatus());
        if (phase == 11) {
            return "redirect:/emeDrills?status=" + status;
        }
        return "redirect:/emeDrills/" + EmeDrillPage.getName(phase) + "?id=" + id;
    }

    private void setNoApprove(Integer id, int phase, int status) {
        WfModular wfModular = new WfModular();
        wfModular.setModularId(Modulars.emeDrills.getValue());
        wfModular.setPhase(phase);
        wfModular.setSolutionId(id);
        wfModular.setStatus(status);
        wfModular.setWorkflowId(null);
        wfModular.setApproveResult(ApproveResult.approvePass.getValue());
        wfModular.setApproveNum(this.workflowService.getWfModularMaxApproveNum(wfModular.getSolutionId(), wfModular.getModularId(), wfModular.getPhase()));
        this.workflowService.saveWfModularInfo(wfModular);
    }

    @Override
    public void workflow(WorkFlowParam param, Integer orderId) {
        EmeDrill record = this.mapper.selectDetailById(param.getBusinessId());
        Integer phase = record.getPhase();
        Integer status = record.getStatus();
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            if (record.getPhase() == 1) {
                phase = 3;
            } else if (record.getPhase() == 3) {
                phase = 5;
            } else if (record.getPhase() == 5) {
                phase = 7;
            } else if (record.getPhase() == 7) {
                phase = 9;
            } else if (record.getPhase() == 9) {
                phase = 11;
                status = 1;
            } else if (record.getPhase() == 11) {
                phase = 11;
                status = 1;
            }
            this.updateStatus(param.getBusinessId(), status, phase);
        }
        if (param.getEnd().booleanValue()) {
            param.getApproved().booleanValue();
        }
    }

    public void updateStatus(Integer id, Integer status, Integer phase) {
        EmeDrill drill = new EmeDrill();
        drill.setId(id);
        drill.setStatus(status);
        drill.setPhase(phase);
        this.mapper.updateByPrimaryKeySelective(drill);
    }

    public void end(List<Integer> idList, Integer status) {
        if (idList == null || idList.size() == 0) {
            return;
        }
        EmeDrillExample example = new EmeDrillExample();
        EmeDrillExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)idList);
        EmeDrill drill = new EmeDrill();
        drill.setStatus(status);
        this.mapper.updateByExampleSelective(drill, example);
    }

    public void deleteInform(Integer drillid) {
        EmeDrillinformExample example = new EmeDrillinformExample();
        example.createCriteria().andDrillidEqualTo(drillid);
        this.informMapper.deleteByExample(example);
    }

    public void addInform(Integer staffid, Integer drillid, Integer orderId) {
        EmeDrillinform record = new EmeDrillinform();
        record.setDeptmanager(staffid);
        record.setInformtime(new Date());
        record.setDrillid(drillid);
        this.informMapper.insert(record);
    }

    @Transactional(readOnly=false)
    public void updateForInitiateInform(WorkFlowParam param, Integer orderId) {
        String[] recover = param.getReceiver().split(",");
        this.deleteInform(param.getBusinessId());
        if (recover != null) {
            String[] stringArray = recover;
            int n = recover.length;
            int n2 = 0;
            while (n2 < n) {
                Staff staff;
                String rec = stringArray[n2];
                if (StringUtils.isNumber(rec) && (staff = this.staffService.get(Integer.valueOf(rec))) != null) {
                    this.addInform(staff.getId(), param.getBusinessId(), orderId);
                }
                ++n2;
            }
        }
        param.getNeedfeedback().booleanValue();
    }

    @Transactional(readOnly=false)
    public void InitiateFeedback(WorkFlowParam param, EmeDrillinform feedback) {
        Map<String, Object> paramMap = param.getparamMap();
        Staff staff = this.staffService.selectByUserId(Integer.valueOf(param.getReceiver()));
        if (staff != null) {
            EmeDrillinformExample example = new EmeDrillinformExample();
            EmeDrillinformExample.Criteria criteria = example.createCriteria();
            criteria.andDrillidEqualTo(param.getBusinessId());
            criteria.andDeptmanagerEqualTo(staff.getId());
            feedback.setFeedbacktime(new Date());
            this.informMapper.updateByExampleSelective(feedback, example);
        }
        this.facets.execute(param.getTaskId(), "" + LoginUtil.getInstance().getLoginStaffInfo().getId(), paramMap);
    }

    public List<EmeDrillinform> getInforms(Integer drill) {
        EmeDrillinformExample example = new EmeDrillinformExample();
        EmeDrillinformExample.Criteria criteria = example.createCriteria();
        criteria.andDrillidEqualTo(drill);
        return this.informMapper.selectByExample(example);
    }

    public String getInformPath(Integer businessId) {
        return "forward:/emeDrills/inform?id=" + businessId;
    }

    @Override
    public String workflowInform(WorkFlowParam param, Integer orderId) {
        String[] recover = param.getReceiver().split(",");
        this.deleteInform(param.getBusinessId());
        if (recover != null) {
            String[] stringArray = recover;
            int n = recover.length;
            int n2 = 0;
            while (n2 < n) {
                Staff staff;
                String rec = stringArray[n2];
                if (StringUtils.isNumber(rec) && (staff = this.staffService.get(Integer.valueOf(rec))) != null) {
                    this.addInform(staff.getId(), param.getBusinessId(), orderId);
                }
                ++n2;
            }
        }
        param.getNeedfeedback().booleanValue();
        return null;
    }

    @Override
    public String doTask(Integer businessId, String taskName) {
        return this.getBusinessPath(businessId, true);
    }

    @Override
    public String doApproveTask(Integer businessId) {
        return null;
    }

    @Override
    public int terminateTask(Integer businessId) {
        return 0;
    }

    @Override
    public String addWorkUrl() {
        return null;
    }
}

