/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.device;

import cn.smarthse.core.annotation.SYSLOG;
import cn.smarthse.core.dao.basic.AreaMapper;
import cn.smarthse.core.dao.basic.OrganizationMapper;
import cn.smarthse.core.dao.basic.WorkroleinfoMapper;
import cn.smarthse.core.dao.device.DeviceMapper;
import cn.smarthse.core.dao.device.DevicecertificateMapper;
import cn.smarthse.core.dao.device.DevicefhtypeMapper;
import cn.smarthse.core.dao.device.DeviceharmfactorMapper;
import cn.smarthse.core.dao.device.DevicemaintenanceMapper;
import cn.smarthse.core.dao.device.DevicematerialMapper;
import cn.smarthse.core.dao.device.DeviceparamMapper;
import cn.smarthse.core.dao.device.DevicerelationMapper;
import cn.smarthse.core.dao.device.DevicespecialMapper;
import cn.smarthse.core.dao.device.DevicetypeMapper;
import cn.smarthse.core.dao.device.DeviceworkroleMapper;
import cn.smarthse.core.dao.sys.SyslogMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.Area;
import cn.smarthse.core.model.basic.AreaExample;
import cn.smarthse.core.model.basic.OccupationalRiskFactors;
import cn.smarthse.core.model.basic.Organization;
import cn.smarthse.core.model.basic.OrganizationExample;
import cn.smarthse.core.model.basic.Workroleinfo;
import cn.smarthse.core.model.basic.WorkroleinfoExample;
import cn.smarthse.core.model.common.ResponseData;
import cn.smarthse.core.model.device.Device;
import cn.smarthse.core.model.device.DeviceExample;
import cn.smarthse.core.model.device.DeviceInit;
import cn.smarthse.core.model.device.Devicecertificate;
import cn.smarthse.core.model.device.DevicecertificateExample;
import cn.smarthse.core.model.device.Devicefhtype;
import cn.smarthse.core.model.device.DevicefhtypeExample;
import cn.smarthse.core.model.device.Deviceharmfactor;
import cn.smarthse.core.model.device.DeviceharmfactorExample;
import cn.smarthse.core.model.device.Devicemaintenance;
import cn.smarthse.core.model.device.DevicemaintenanceExample;
import cn.smarthse.core.model.device.Devicematerial;
import cn.smarthse.core.model.device.DevicematerialExample;
import cn.smarthse.core.model.device.Deviceparam;
import cn.smarthse.core.model.device.DeviceparamExample;
import cn.smarthse.core.model.device.Devicerelation;
import cn.smarthse.core.model.device.DevicerelationExample;
import cn.smarthse.core.model.device.Devicespecial;
import cn.smarthse.core.model.device.DevicespecialExample;
import cn.smarthse.core.model.device.Devicetype;
import cn.smarthse.core.model.device.DevicetypeExample;
import cn.smarthse.core.model.device.Deviceworkrole;
import cn.smarthse.core.model.device.DeviceworkroleExample;
import cn.smarthse.core.model.device.vo.DeviceItemVO;
import cn.smarthse.core.model.device.vo.DevicetypeVO;
import cn.smarthse.core.model.matter.PmcCompanymaterial;
import cn.smarthse.core.model.vo.QueryDeviceMaintainParam;
import cn.smarthse.core.model.vo.QueryDeviceParam;
import cn.smarthse.core.service.basic.OccupationalRiskFactorsService;
import cn.smarthse.core.service.basic.staff.WorkRoleInfoService;
import cn.smarthse.core.service.matter.MatterService;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@SYSLOG(desc="\u8bbe\u5907\u8bbe\u65bd")
@Service
public class DeviceService {
    @Autowired
    SyslogMapper syslogMapper;
    @Autowired
    DeviceMapper deviceMapper;
    @Autowired
    OrganizationMapper orgMapper;
    @Autowired
    AreaMapper areaMapper;
    @Autowired
    WorkroleinfoMapper workroleMapper;
    @Autowired
    WorkRoleInfoService workRoleInfoService;
    @Autowired
    MatterService matterService;
    @Autowired
    OccupationalRiskFactorsService occupationalRiskFactorsService;
    @Autowired
    DeviceworkroleMapper deviceWorkRoleMapper;
    @Autowired
    DevicemaintenanceMapper deviceMaintenanceMapper;
    @Autowired
    DevicefhtypeMapper deviceFhtypeMapper;
    @Autowired
    DeviceharmfactorMapper deviceHarmFactorMapper;
    @Autowired
    DevicetypeMapper deviceTypeMapper;
    @Autowired
    DevicespecialMapper deviceSpecialMapper;
    @Autowired
    DevicematerialMapper deviceMaterialMapper;
    @Autowired
    DevicerelationMapper deviceRelationMapper;
    @Autowired
    DeviceparamMapper deviceParamMapper;
    @Autowired
    DevicecertificateMapper deviceCertificateMapper;

    public Device addDevice(Device record) {
        this.deviceMapper.insertSelective(record);
        return record;
    }

    @Transactional
    public Device executeAddDevice(Device record, String[] userworkids, String[] materialids) {
        Integer tid;
        int n;
        int n2;
        String[] stringArray;
        record.setUpdatedate(new Date());
        record.setIsvalid(Constant.ACTIVE_YES);
        this.deviceMapper.insertSelective(record);
        if (userworkids != null && userworkids.length > 0) {
            stringArray = userworkids;
            n2 = userworkids.length;
            n = 0;
            while (n < n2) {
                String userworkid = stringArray[n];
                tid = Integer.valueOf(userworkid);
                Workroleinfo wrole = this.workRoleInfoService.getById(tid);
                if (wrole != null) {
                    Deviceworkrole dwrole = new Deviceworkrole();
                    dwrole.setCid(record.getCid());
                    dwrole.setDeviceid(record.getId());
                    dwrole.setWorkroleid(tid);
                    this.addDeviceWorkRole(dwrole);
                }
                ++n;
            }
        }
        if (materialids != null && materialids.length > 0) {
            stringArray = materialids;
            n2 = materialids.length;
            n = 0;
            while (n < n2) {
                String materialid = stringArray[n];
                tid = Integer.valueOf(materialid);
                PmcCompanymaterial material = this.matterService.getCompanymaterialById(tid);
                if (material != null && material.getCid().equals(record.getCid())) {
                    Devicematerial dmaterial = new Devicematerial();
                    dmaterial.setCid(record.getCid());
                    dmaterial.setDeviceid(record.getId());
                    dmaterial.setMaterialid(tid);
                    this.addDeviceMaterial(dmaterial);
                }
                ++n;
            }
        }
        return record;
    }

    public Device getDeviceById(int id) {
        return this.deviceMapper.selectByPrimaryKey(id);
    }

    @Transactional
    public int executeupdateDevice(Device record, String[] userworkids, String[] materialids) {
        Integer tid;
        int n;
        int n2;
        String[] stringArray;
        if (userworkids != null && userworkids.length > 0) {
            stringArray = userworkids;
            n2 = userworkids.length;
            n = 0;
            while (n < n2) {
                String userworkid = stringArray[n];
                tid = Integer.valueOf(userworkid);
                Workroleinfo wrole = this.workRoleInfoService.getById(tid);
                if (wrole != null) {
                    Deviceworkrole dwrole = new Deviceworkrole();
                    dwrole.setCid(record.getCid());
                    dwrole.setDeviceid(record.getId());
                    dwrole.setWorkroleid(tid);
                    this.addDeviceWorkRole(dwrole);
                }
                ++n;
            }
        }
        if (materialids != null && materialids.length > 0) {
            stringArray = materialids;
            n2 = materialids.length;
            n = 0;
            while (n < n2) {
                String materialid = stringArray[n];
                tid = Integer.valueOf(materialid);
                PmcCompanymaterial material = this.matterService.getCompanymaterialById(tid);
                if (material != null) {
                    Devicematerial dmaterial = new Devicematerial();
                    dmaterial.setCid(record.getCid());
                    dmaterial.setDeviceid(record.getId());
                    dmaterial.setMaterialid(tid);
                    this.addDeviceMaterial(dmaterial);
                }
                ++n;
            }
        }
        return this.deviceMapper.updateByPrimaryKeySelective(record);
    }

    @Transactional
    public int executeupdateDeviceEHS(Device record, String[] fhtypeids, String[] reladeviceids, Byte isharm, String[] harmfactorIds) {
        Integer tid;
        int n;
        int n2;
        String[] stringArray;
        if (fhtypeids != null && fhtypeids.length > 0) {
            stringArray = fhtypeids;
            n2 = fhtypeids.length;
            n = 0;
            while (n < n2) {
                String fhtypeid = stringArray[n];
                tid = Integer.valueOf(fhtypeid);
                Devicefhtype fhtype = new Devicefhtype();
                fhtype.setCid(record.getCid());
                fhtype.setDeviceid(record.getId());
                fhtype.setFhtypeid(tid);
                this.addDeviceFhtype(fhtype);
                ++n;
            }
        }
        if (reladeviceids != null && reladeviceids.length > 0) {
            stringArray = reladeviceids;
            n2 = reladeviceids.length;
            n = 0;
            while (n < n2) {
                String reladeviceid = stringArray[n];
                tid = Integer.valueOf(reladeviceid);
                Devicerelation relation = new Devicerelation();
                relation.setCid(record.getCid());
                relation.setDeviceid(record.getId());
                relation.setRelationdeviceid(tid);
                relation.setRelationdevicename(record.getDevicename());
                this.addDeviceRelation(relation);
                ++n;
            }
        }
        if (isharm == 1) {
            if (harmfactorIds != null && harmfactorIds.length > 0) {
                stringArray = harmfactorIds;
                n2 = harmfactorIds.length;
                n = 0;
                while (n < n2) {
                    String harmfactorId = stringArray[n];
                    Integer hid = Integer.valueOf(harmfactorId);
                    OccupationalRiskFactors hram = this.occupationalRiskFactorsService.getById(hid);
                    if (hram != null) {
                        Deviceharmfactor hramfactor = new Deviceharmfactor();
                        hramfactor.setCid(record.getCid());
                        hramfactor.setDeviceid(record.getId());
                        hramfactor.setHarmid(hid);
                        hramfactor.setHarmname(hram.getNameCh());
                        this.addDeviceHarmFactor(hramfactor);
                    }
                    ++n;
                }
            }
        } else {
            this.clearDeviceharmfactorByDeviceId(record.getCid(), record.getId());
        }
        return this.deviceMapper.updateByPrimaryKeySelective(record);
    }

    public int updateDevice(Device record) {
        return this.deviceMapper.updateByPrimaryKeySelective(record);
    }

    public void batchDeleteDevice(int cid, List<Integer> ids) {
        if (ids != null && ids.size() > 0) {
            DeviceExample example = new DeviceExample();
            DeviceExample.Criteria criteria = example.createCriteria();
            criteria.andCidEqualTo(cid);
            criteria.andIdIn((List)ids);
            Device record = new Device();
            record.setIsvalid(Constant.ACTIVE_NO);
            this.deviceMapper.updateByExampleSelective(record, example);
        }
    }

    public List<Device> getDeviceListByExample(DeviceExample example) {
        return this.deviceMapper.selectWithEntityByExample(example);
    }

    public Device getDeviceWidthEntity(int id) {
        return this.deviceMapper.selectWithEntityByPrimaryKey(id);
    }

    public List<Device> getDeviceListByCompanyId(Integer companyId) {
        DeviceExample example = new DeviceExample();
        example.createCriteria().andCidEqualTo(companyId);
        List<Device> list = this.deviceMapper.selectByExample(example);
        return list;
    }

    public List<Device> getDeviceTypeInfoById(Integer cid, Integer typeid) {
        DeviceExample e = new DeviceExample();
        DeviceExample.Criteria criteria = e.createCriteria();
        criteria.andCidEqualTo(cid);
        List<Device> list = this.deviceMapper.selectByExample(e);
        return list;
    }

    public List<Device> getDeviceByDeviceId(DeviceExample example) {
        List<Device> list = this.deviceMapper.selectByExample(example);
        return list;
    }

    public List<DeviceItemVO> getDeviceItemList(QueryDeviceParam qparam) {
        if (qparam == null || qparam.getCid() == null || qparam.getCid() == 0) {
            return Collections.emptyList();
        }
        return this.deviceMapper.selectItemList(qparam);
    }

    public Deviceworkrole addDeviceWorkRole(Deviceworkrole record) {
        this.deviceWorkRoleMapper.insertSelective(record);
        return record;
    }

    public Deviceworkrole getDeviceworkroleById(int id) {
        return this.deviceWorkRoleMapper.selectByPrimaryKey(id);
    }

    public int updateDeviceWorkRole(Deviceworkrole record) {
        return this.deviceWorkRoleMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteDeviceWorkRole(Deviceworkrole record) {
        return this.deviceWorkRoleMapper.deleteByPrimaryKey(record.getId());
    }

    public List<Deviceworkrole> getDeviceWorkRoleListByExample(DeviceworkroleExample example) {
        return this.deviceWorkRoleMapper.selectByExample(example);
    }

    public void clearDeviceworkrole(Integer cid, Integer deviceId) {
        DeviceworkroleExample example = new DeviceworkroleExample();
        example.or().andCidEqualTo(cid).andDeviceidEqualTo(deviceId);
        this.deviceWorkRoleMapper.deleteByExample(example);
    }

    public Devicemaintenance addDeviceMaintenance(Devicemaintenance record) {
        this.deviceMaintenanceMapper.insertSelective(record);
        return record;
    }

    public Devicemaintenance getDevicemaintenanceById(int id) {
        return this.deviceMaintenanceMapper.selectByPrimaryKey(id);
    }

    public Devicemaintenance getDevicemaintenance(int id) {
        return this.deviceMaintenanceMapper.selectWithEntityByPrimaryKey(id);
    }

    public int updateDeviceMaintenance(Devicemaintenance record) {
        return this.deviceMaintenanceMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteDeviceMaintenance(Devicemaintenance record) {
        return this.deviceMaintenanceMapper.deleteByPrimaryKey(record.getId());
    }

    public List<Devicemaintenance> getDeviceMaintenanceListByExample(DevicemaintenanceExample example) {
        return this.deviceMaintenanceMapper.selectWithEntityByExample(example);
    }

    public List<Devicemaintenance> getDevicemaintenanceList(QueryDeviceMaintainParam param) {
        if (param != null && param.getCid() != null) {
            return this.deviceMaintenanceMapper.selectDevicemaintenanceList(param);
        }
        return Collections.emptyList();
    }

    public void batchDeleteDeviceMaintenance(Integer cid, List<Integer> list) {
        if (list != null && list.size() > 0) {
            DevicemaintenanceExample example = new DevicemaintenanceExample();
            DevicemaintenanceExample.Criteria criteria = example.createCriteria();
            criteria.andCidEqualTo(cid);
            criteria.andIdIn((List)list);
            Devicemaintenance record = new Devicemaintenance();
            record.setState(2);
            this.deviceMaintenanceMapper.updateByExampleSelective(record, example);
        }
    }

    public Devicefhtype addDeviceFhtype(Devicefhtype record) {
        this.deviceFhtypeMapper.insertSelective(record);
        return record;
    }

    public Devicefhtype getDevicefhtypeById(int id) {
        return this.deviceFhtypeMapper.selectByPrimaryKey(id);
    }

    public int updateDeviceFhtype(Devicefhtype record) {
        return this.deviceFhtypeMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteDeviceFhtype(Integer id) {
        return this.deviceFhtypeMapper.deleteByPrimaryKey(id);
    }

    public List<Devicefhtype> getDeviceFhtypeListByExample(DevicefhtypeExample example) {
        return this.deviceFhtypeMapper.selectByExample(example);
    }

    public List<Devicefhtype> getDeviceFhtypeListByDeviceId(Integer cid, Integer deviceId) {
        if (cid != null && cid > 0 && deviceId != null && deviceId > 0) {
            DevicefhtypeExample example = new DevicefhtypeExample();
            DevicefhtypeExample.Criteria c = example.createCriteria();
            c.andCidEqualTo(cid);
            c.andDeviceidEqualTo(deviceId);
            return this.deviceFhtypeMapper.selectByExampleWithEntity(example);
        }
        return Collections.emptyList();
    }

    public void clearDeviceFhtypeListByDeviceId(Integer cid, Integer deviceId) {
        DevicefhtypeExample example = new DevicefhtypeExample();
        DevicefhtypeExample.Criteria c = example.createCriteria();
        c.andCidEqualTo(cid);
        c.andDeviceidEqualTo(deviceId);
        this.deviceFhtypeMapper.deleteByExample(example);
    }

    public List<Devicefhtype> getFhtypeListByFhtypeId(Integer fhtypeid, Integer cid) {
        DevicefhtypeExample example = new DevicefhtypeExample();
        DevicefhtypeExample.Criteria criteria = example.createCriteria();
        criteria.andCidEqualTo(cid);
        criteria.andFhtypeidEqualTo(fhtypeid);
        List<Devicefhtype> fhtypelist = this.deviceFhtypeMapper.selectByExample(example);
        return fhtypelist;
    }

    public Deviceharmfactor addDeviceHarmFactor(Deviceharmfactor record) {
        this.deviceHarmFactorMapper.insertSelective(record);
        return record;
    }

    public Deviceharmfactor getDeviceharmfactorById(int id) {
        return this.deviceHarmFactorMapper.selectByPrimaryKey(id);
    }

    public int deleteDeviceHarmFactor(Integer id) {
        return this.deviceHarmFactorMapper.deleteByPrimaryKey(id);
    }

    public List<Deviceharmfactor> getDeviceHarmFactorListByExample(DeviceharmfactorExample example) {
        return this.deviceHarmFactorMapper.selectByExample(example);
    }

    public void clearDeviceharmfactorByDeviceId(Integer cid, Integer deviceID) {
        if (cid != null && cid > 0 && deviceID != null && deviceID > 0) {
            DeviceharmfactorExample example = new DeviceharmfactorExample();
            example.or().andCidEqualTo(cid);
            example.or().andDeviceidEqualTo(deviceID);
            this.deviceHarmFactorMapper.deleteByExample(example);
        }
    }

    public List<Deviceharmfactor> getDeviceHarmFactorList(Integer cid, Integer deviceID) {
        if (cid != null && cid > 0 && deviceID != null && deviceID > 0) {
            DeviceharmfactorExample example = new DeviceharmfactorExample();
            example.or().andCidEqualTo(cid);
            example.or().andDeviceidEqualTo(deviceID);
            return this.getDeviceHarmFactorListByExample(example);
        }
        return Collections.emptyList();
    }

    public Devicetype addDeviceType(Devicetype record) {
        this.deviceTypeMapper.insertSelective(record);
        return record;
    }

    public Devicetype getDevicetypeById(int id) {
        return this.deviceTypeMapper.selectByPrimaryKey(id);
    }

    public int updateDeviceType(Devicetype record) {
        return this.deviceTypeMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteDeviceType(Devicetype record) {
        return this.deviceTypeMapper.deleteByPrimaryKey(record.getId());
    }

    public int delete(int id) {
        return this.deviceTypeMapper.deleteByPrimaryKey(id);
    }

    public int update(Devicetype record) {
        return this.deviceTypeMapper.updateByPrimaryKeySelective(record);
    }

    public Devicetype insert(Devicetype record) {
        this.deviceTypeMapper.insertSelective(record);
        return record;
    }

    public List<Devicetype> getDeviceTypeListByExample(DevicetypeExample example) {
        return this.deviceTypeMapper.selectByExample(example);
    }

    public List<Devicetype> getDeviceTypeListByCompanyId(Integer cid) {
        if (cid == null || cid == 0) {
            return Collections.emptyList();
        }
        DevicetypeExample example = new DevicetypeExample();
        example.or().andCidEqualTo(cid);
        return this.deviceTypeMapper.selectByExample(example);
    }

    public List<DevicetypeVO> getDeviceWithCount(Integer cid) {
        return this.deviceTypeMapper.selectDeviceWithCount(cid);
    }

    public List<Devicetype> getAll(Integer cid) {
        DevicetypeExample e = new DevicetypeExample();
        e.createCriteria().andCidEqualTo(cid);
        List<Devicetype> list = this.deviceTypeMapper.selectByExample(e);
        return list;
    }

    public Devicespecial addDeviceSpecial(Devicespecial record) {
        this.deviceSpecialMapper.insertSelective(record);
        return record;
    }

    public Devicespecial getDevicespecialById(int id) {
        return this.deviceSpecialMapper.selectByPrimaryKey(id);
    }

    public int updateDeviceSpecial(Devicespecial record) {
        return this.deviceSpecialMapper.updateByPrimaryKey(record);
    }

    public int deleteDeviceSpecial(Devicespecial record) {
        return this.deviceSpecialMapper.deleteByPrimaryKey(record.getId());
    }

    public List<Devicespecial> getDeviceSpecialListByExample(DevicespecialExample example) {
        return this.deviceSpecialMapper.selectByExample(example);
    }

    public Devicespecial getDevicespecialByDeviceId(Integer cid, Integer deviceID) {
        if (cid != null && cid > 0 && deviceID != null && deviceID > 0) {
            DevicespecialExample example = new DevicespecialExample();
            example.or().andCidEqualTo(cid);
            example.or().andDeviceidEqualTo(deviceID);
            List<Devicespecial> list = this.getDeviceSpecialListByExample(example);
            if (list != null && list.size() > 0) {
                return list.get(0);
            }
            Devicespecial special = new Devicespecial();
            special.setCid(cid);
            special.setDeviceid(deviceID);
            return this.addDeviceSpecial(special);
        }
        return null;
    }

    public Devicematerial addDeviceMaterial(Devicematerial record) {
        this.deviceMaterialMapper.insertSelective(record);
        return record;
    }

    public Devicematerial getDevicematerialById(int id) {
        return this.deviceMaterialMapper.selectByPrimaryKey(id);
    }

    public int updateDeviceMaterial(Devicematerial record) {
        return this.deviceMaterialMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteDeviceMaterial(Devicematerial record) {
        return this.deviceMaterialMapper.deleteByPrimaryKey(record.getId());
    }

    public List<Devicematerial> getDeviceMaterialListByExample(DevicematerialExample example) {
        return this.deviceMaterialMapper.selectByExample(example);
    }

    public List<Devicematerial> getDevicematerialList(Integer cid, Integer deviceId) {
        if (cid != null && cid > 0 && deviceId != null && deviceId > 0) {
            DevicematerialExample example = new DevicematerialExample();
            DevicematerialExample.Criteria c = example.createCriteria();
            c.andCidEqualTo(cid);
            c.andDeviceidEqualTo(deviceId);
            return this.deviceMaterialMapper.selectByExampleWithEntity(example);
        }
        return Collections.emptyList();
    }

    public Devicerelation addDeviceRelation(Devicerelation record) {
        this.deviceRelationMapper.insertSelective(record);
        return record;
    }

    public Devicerelation getDevicerelationById(int id) {
        return this.deviceRelationMapper.selectByPrimaryKey(id);
    }

    public int deleteDeviceRelation(Devicerelation record) {
        return this.deviceRelationMapper.deleteByPrimaryKey(record.getId());
    }

    public List<Devicerelation> getDevicerelationList(Integer cid, Integer deviceId) {
        if (cid != null && cid > 0 && deviceId != null && deviceId > 0) {
            DevicerelationExample example = new DevicerelationExample();
            DevicerelationExample.Criteria c = example.createCriteria();
            c.andCidEqualTo(cid);
            c.andDeviceidEqualTo(deviceId);
            return this.deviceRelationMapper.selectByExampleWithEntity(example);
        }
        return Collections.emptyList();
    }

    public Deviceparam addDeviceParam(Deviceparam record) {
        this.deviceParamMapper.insertSelective(record);
        return record;
    }

    public Deviceparam getDeviceparamById(int id) {
        return this.deviceParamMapper.selectByPrimaryKey(id);
    }

    public int updateDeviceParam(Deviceparam record) {
        return this.deviceParamMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteDeviceParam(Integer paramId) {
        return this.deviceParamMapper.deleteByPrimaryKey(paramId);
    }

    public List<Deviceparam> getDeviceParamListByExample(DeviceparamExample example) {
        return this.deviceParamMapper.selectByExample(example);
    }

    public List<Deviceparam> getDeviceparamList(Integer cid, Integer deviceId) {
        if (cid != null && cid > 0 && deviceId != null && deviceId > 0) {
            DeviceparamExample example = new DeviceparamExample();
            DeviceparamExample.Criteria c = example.createCriteria();
            c.andCidEqualTo(cid);
            c.andDeviceidEqualTo(deviceId);
            return this.getDeviceParamListByExample(example);
        }
        return Collections.emptyList();
    }

    public Devicecertificate addDeviceCertificate(Devicecertificate record) {
        this.deviceCertificateMapper.insertSelective(record);
        return record;
    }

    public Devicecertificate getDevicecertificateById(int id) {
        return this.deviceCertificateMapper.selectByPrimaryKey(id);
    }

    public int updateDeviceCertificate(Devicecertificate record) {
        return this.deviceCertificateMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteDeviceCertificate(Integer certId) {
        return this.deviceCertificateMapper.deleteByPrimaryKey(certId);
    }

    public List<Devicecertificate> getDeviceCertificateListByExample(DevicecertificateExample example) {
        return this.deviceCertificateMapper.selectByExample(example);
    }

    public List<Devicecertificate> getDeviceCertificateList(Integer cid, Integer deviceID) {
        if (cid != null && cid > 0 && deviceID != null && deviceID > 0) {
            DevicecertificateExample example = new DevicecertificateExample();
            example.createCriteria().andCidEqualTo(cid).andDeviceidEqualTo(deviceID);
            return this.getDeviceCertificateListByExample(example);
        }
        return Collections.emptyList();
    }

    public ResponseData<DeviceInit> getDeviceInitInfoFromExcel(String fileName) throws Exception {
        ResponseData<DeviceInit> data = new ResponseData<DeviceInit>();
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)new FileInputStream(fileName));
        HSSFSheet sheet = wb.getSheetAt(0);
        DeviceInit init = new DeviceInit();
        Map<String, String> workMap = init.getWorkMap();
        Map<String, String> workroleMap = init.getWorkroleMap();
        Map<String, String> areaMap = init.getAreaMap();
        Map<String, String> typeMap = init.getTypeMap();
        int rowIndex = 0;
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1 || row.getCell(3) == null || row.getCell(3).getCellType() == 3) continue;
            Device device = new Device();
            Organization org = new Organization();
            Workroleinfo workrole = new Workroleinfo();
            Devicetype type = new Devicetype();
            Area area = new Area();
            int cellCount = 16;
            int colIndex = 0;
            int i = 0;
            while (i < cellCount) {
                Cell cell = row.getCell(i);
                ++colIndex;
                if (cell != null && cell.getCellType() != 3) {
                    switch (i) {
                        case 0: {
                            String deviceType = cell.getStringCellValue().trim();
                            device.setTypeName(deviceType);
                            if (typeMap.get(deviceType) != null) break;
                            typeMap.put(deviceType, deviceType);
                            break;
                        }
                        case 1: {
                            device.setDevicename(cell.getStringCellValue().trim());
                            break;
                        }
                        case 2: {
                            device.setDevicemodel(cell.getStringCellValue().trim());
                            break;
                        }
                        case 3: {
                            device.setDeviceno(cell.getStringCellValue().trim());
                            break;
                        }
                        case 4: {
                            try {
                                int mount = (int)cell.getNumericCellValue();
                                device.setDeviceamount(mount);
                                break;
                            }
                            catch (Exception e) {
                                data.setCode(-1);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6570\u91cf\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                        }
                        case 5: {
                            String isSpecial = cell.getStringCellValue().trim();
                            if (isSpecial.equals("\u662f")) {
                                device.setIsspecial(Constant.ACTIVE_YES);
                                break;
                            }
                            if (isSpecial.equals("\u5426")) {
                                device.setIsspecial(Constant.ACTIVE_NO);
                                break;
                            }
                            data.setCode(-4);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u7279\u79cd\u8bbe\u5907\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        case 6: {
                            String isRadiation = cell.getStringCellValue().trim();
                            if (isRadiation.equals("\u662f")) {
                                device.setIsradiation(Constant.ACTIVE_YES);
                                break;
                            }
                            if (isRadiation.equals("\u5426")) {
                                device.setIsradiation(Constant.ACTIVE_NO);
                                break;
                            }
                            data.setCode(-4);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u653e\u5c04\u8bbe\u5907\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        case 7: {
                            String useArea = cell.getStringCellValue().trim();
                            device.setUseAreaName(useArea);
                            if (workMap.get(useArea) != null) break;
                            workMap.put(useArea, useArea);
                            break;
                        }
                        case 8: {
                            String useWork = cell.getStringCellValue().trim();
                            device.setWorkName(cell.getStringCellValue().trim());
                            if (workroleMap.get(useWork) != null) break;
                            workroleMap.put(useWork, useWork);
                            break;
                        }
                        case 9: {
                            String areaName = cell.getStringCellValue().trim();
                            device.setInstallAreaName(areaName);
                            if (areaMap.get(areaName) != null) break;
                            areaMap.put(areaName, areaName);
                            break;
                        }
                        case 10: {
                            device.setManufacturer(cell.getStringCellValue().trim());
                            break;
                        }
                        case 11: {
                            device.setSupplier(cell.getStringCellValue().trim());
                            break;
                        }
                        case 12: {
                            device.setInstaller(cell.getStringCellValue().trim());
                            break;
                        }
                        case 13: {
                            device.setProducedtime(this.getExcelDate((int)cell.getNumericCellValue()));
                            break;
                        }
                        case 14: {
                            device.setAccepttime(this.getExcelDate((int)cell.getNumericCellValue()));
                            break;
                        }
                        case 15: {
                            device.setUsetime(this.getExcelDate((int)cell.getNumericCellValue()));
                            break;
                        }
                    }
                }
                ++i;
            }
            init.getDeviceList().add(device);
        }
        wb.close();
        data.setResult(init);
        return data;
    }

    private Date getExcelDate(int days) {
        Calendar c3 = Calendar.getInstance();
        c3.set(1900, 0, -1);
        c3.add(5, days);
        return c3.getTime();
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf(String.valueOf((char)(65 + a - 1))) + String.valueOf((char)(65 + b - 1));
    }

    @Transactional
    public ResponseData<String> initImport(DeviceInit init) {
        int cid = init.getCompanyId();
        ResponseData<String> data = new ResponseData<String>();
        Map<String, String> workMap = init.getWorkMap();
        Map<String, String> workroleMap = init.getWorkroleMap();
        Map<String, String> areaMap = init.getAreaMap();
        Map<String, String> typeMap = init.getTypeMap();
        List<Device> deviceList = init.getDeviceList();
        for (Map.Entry<String, String> entry : typeMap.entrySet()) {
            Devicetype devicetype = new Devicetype();
            devicetype.setCid(cid);
            devicetype.setTypename(entry.getKey());
            devicetype.setIsvalid(Constant.ACTIVE_YES);
            this.deviceTypeMapper.insertSelective(devicetype);
            for (Device device : deviceList) {
                if (device.getTypeName() == null || !device.getTypeName().equals(entry.getKey())) continue;
                device.setTypeid(devicetype.getId());
            }
        }
        for (Map.Entry<String, String> entry : workMap.entrySet()) {
            Organization or = new Organization();
            or.setFulname(entry.getKey());
            or.setCid(cid);
            or.setIsvalid(Constant.ACTIVE_YES);
            this.orgMapper.insertSelective(or);
            for (Device device : deviceList) {
                if (device.getUseAreaName() == null || !device.getUseAreaName().equals(entry.getKey())) continue;
                device.setUseareaid(or.getId());
            }
        }
        for (Map.Entry<String, String> entry : areaMap.entrySet()) {
            Area a = new Area();
            a.setAreaname(entry.getKey());
            a.setCid(cid);
            a.setIsvalid(Constant.ACTIVE_YES);
            this.areaMapper.insertSelective(a);
            for (Device device : deviceList) {
                if (device.getInstallAreaName() == null || !device.getInstallAreaName().equals(entry.getKey())) continue;
                device.setInstallareaid(a.getId());
            }
        }
        for (Device device : deviceList) {
            device.setCid(cid);
            device.setIsvalid(Constant.ACTIVE_YES);
            this.deviceMapper.insertSelective(device);
            for (Map.Entry<String, String> entry : workroleMap.entrySet()) {
                int workid;
                if (device.getWorkName() == null || !device.getWorkName().equals(entry.getKey())) continue;
                WorkroleinfoExample example = new WorkroleinfoExample();
                example.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES).andWorknameEqualTo(entry.getKey());
                List<Workroleinfo> list = this.workroleMapper.selectByExample(example);
                if (list != null && list.size() > 0) {
                    workid = list.get(0).getId();
                } else {
                    Workroleinfo workroleinfo = new Workroleinfo();
                    workroleinfo.setIsvalid(Constant.ACTIVE_YES);
                    workroleinfo.setCid(cid);
                    workroleinfo.setWorkname(entry.getKey());
                    workroleinfo.setCreatetime(new Date());
                    this.workroleMapper.insertSelective(workroleinfo);
                    workid = workroleinfo.getId();
                }
                Deviceworkrole deviceworkrole = new Deviceworkrole();
                deviceworkrole.setCid(cid);
                deviceworkrole.setWorkroleid(workid);
                deviceworkrole.setDeviceid(device.getId());
                this.deviceWorkRoleMapper.insertSelective(deviceworkrole);
            }
        }
        return data;
    }

    public void deleteBycid(Integer cid) {
        DevicetypeExample dte = new DevicetypeExample();
        dte.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<Devicetype> dtList = this.deviceTypeMapper.selectByExample(dte);
        for (Devicetype dt : dtList) {
            dt.setIsvalid(Constant.ACTIVE_NO);
            this.deviceTypeMapper.updateByPrimaryKeySelective(dt);
        }
        OrganizationExample ore = new OrganizationExample();
        ore.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<Organization> orList = this.orgMapper.selectByExample(ore);
        for (Organization org : orList) {
            org.setIsvalid(Constant.ACTIVE_NO);
            this.orgMapper.updateByPrimaryKeySelective(org);
        }
        AreaExample ae = new AreaExample();
        ae.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<Area> aList = this.areaMapper.selectByExample(ae);
        for (Area a : aList) {
            a.setIsvalid(Constant.ACTIVE_NO);
            this.areaMapper.updateByPrimaryKeySelective(a);
        }
        DeviceExample de = new DeviceExample();
        de.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<Device> dList = this.deviceMapper.selectByExample(de);
        for (Device d : dList) {
            d.setIsvalid(Constant.ACTIVE_NO);
            this.deviceMapper.updateByPrimaryKeySelective(d);
        }
        WorkroleinfoExample we = new WorkroleinfoExample();
        we.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<Workroleinfo> wList = this.workroleMapper.selectByExample(we);
        for (Workroleinfo w : wList) {
            w.setIsvalid(Constant.ACTIVE_NO);
            this.workroleMapper.updateByPrimaryKeySelective(w);
        }
        DeviceworkroleExample dwe = new DeviceworkroleExample();
        dwe.createCriteria().andIsvalidEqualTo(Constant.ACTIVE_YES).andCidEqualTo(cid);
        List<Deviceworkrole> dwList = this.deviceWorkRoleMapper.selectByExample(dwe);
        for (Deviceworkrole dw : dwList) {
            dw.setIsvalid(Constant.ACTIVE_NO);
            this.deviceWorkRoleMapper.updateByPrimaryKeySelective(dw);
        }
    }
}

