/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic.staff;

import cn.smarthse.core.dao.basic.CompanyparamMapper;
import cn.smarthse.core.dao.basic.CompanyparamtypeMapper;
import cn.smarthse.core.dao.basic.StaffworkroleMapper;
import cn.smarthse.core.dao.basic.WorkroleareaMapper;
import cn.smarthse.core.dao.basic.WorkroleinfoMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.Companyparam;
import cn.smarthse.core.model.basic.CompanyparamExample;
import cn.smarthse.core.model.basic.Companyparamtype;
import cn.smarthse.core.model.basic.CompanyparamtypeExample;
import cn.smarthse.core.model.basic.Staffworkrole;
import cn.smarthse.core.model.basic.StaffworkroleExample;
import cn.smarthse.core.model.basic.Workrolearea;
import cn.smarthse.core.model.basic.WorkroleareaExample;
import cn.smarthse.core.model.basic.Workroleinfo;
import cn.smarthse.core.model.basic.WorkroleinfoExample;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkRoleInfoService {
    @Autowired
    private WorkroleinfoMapper workroleinfoMapper;
    @Autowired
    private CompanyparamtypeMapper CompanyparamtypeMapper;
    @Autowired
    private CompanyparamMapper CompanyparamMapper;
    @Autowired
    private WorkroleareaMapper WorkroleareaMapper;
    @Autowired
    private StaffworkroleMapper StaffworkroleMapper;

    public Workroleinfo getById(int id) {
        return this.workroleinfoMapper.selectDetail(id);
    }

    public int create(Workroleinfo record) {
        return this.workroleinfoMapper.insertSelective(record);
    }

    public Workroleinfo getByName(Integer cid, String name) {
        WorkroleinfoExample e = new WorkroleinfoExample();
        e.createCriteria().andCidEqualTo(cid).andWorknameEqualTo(name).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<Workroleinfo> list = this.workroleinfoMapper.selectByExample(e);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<Companyparam> getJobTitle(Integer cid) {
        Integer type = null;
        CompanyparamtypeExample e1 = new CompanyparamtypeExample();
        e1.createCriteria().andCidEqualTo(cid).andTypecodeEqualTo("JOBTITLE_TYPE");
        List<Companyparamtype> typeList = this.CompanyparamtypeMapper.selectByExample(e1);
        if (typeList != null && typeList.size() > 0) {
            type = typeList.get(0).getId();
        }
        CompanyparamExample e = new CompanyparamExample();
        if (type != null) {
            e.createCriteria().andCidEqualTo(cid).andParamtypeEqualTo(type);
        }
        List<Companyparam> list = this.CompanyparamMapper.selectByExample(e);
        return list;
    }

    @Transactional
    public int createWorkrole(Workroleinfo record, List<Integer> areaIdList) {
        record.setIsvalid(Constant.ACTIVE_YES);
        record.setCreatetime(new Date());
        int count = this.workroleinfoMapper.insertSelective(record);
        int i = 0;
        while (i < areaIdList.size()) {
            Integer areaid = areaIdList.get(i);
            if (areaid != null) {
                Workrolearea a = new Workrolearea();
                a.setWorkid(record.getId());
                a.setAreaid(areaid);
                this.WorkroleareaMapper.insertSelective(a);
            }
            ++i;
        }
        return count;
    }

    @Transactional
    public int deleteWorkrole(Integer id) {
        WorkroleareaExample e = new WorkroleareaExample();
        e.or().andWorkidEqualTo(id);
        this.WorkroleareaMapper.deleteByExample(e);
        Workroleinfo record = new Workroleinfo();
        record.setId(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        record.setExpiretime(new Date());
        return this.workroleinfoMapper.updateByPrimaryKey(record);
    }

    @Transactional
    public int updateWorkrole(Workroleinfo record, List<Integer> areaIdList) {
        WorkroleareaExample e = new WorkroleareaExample();
        e.or().andWorkidEqualTo(record.getId());
        this.WorkroleareaMapper.deleteByExample(e);
        int i = 0;
        while (i < areaIdList.size()) {
            Integer areaid = areaIdList.get(i);
            if (areaid != null) {
                Workrolearea a = new Workrolearea();
                a.setWorkid(record.getId());
                a.setAreaid(areaid);
                this.WorkroleareaMapper.insertSelective(a);
            }
            ++i;
        }
        return this.workroleinfoMapper.updateByPrimaryKeySelective(record);
    }

    public List<Workroleinfo> getAll(Integer cid) {
        return this.queryWorkrole(cid, null);
    }

    public List<Workroleinfo> getAll(Integer cid, Integer pageNumber, Integer pageSize) {
        if (pageNumber != null) {
            PageHelper.startPage((int)pageNumber, (int)pageSize);
        }
        return this.queryWorkrole(cid, null);
    }

    public List<Workroleinfo> queryWorkrole(Integer cid, String keyword) {
        WorkroleinfoExample e = new WorkroleinfoExample();
        WorkroleinfoExample.Criteria c = e.createCriteria();
        c.andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        if (StringUtils.isNotEmpty((String)keyword)) {
            c.andWorknameLike("%" + keyword + "%");
        }
        e.setOrderByClause("id desc");
        List<Workroleinfo> workroleinfoList = this.workroleinfoMapper.selectByExample(e);
        return workroleinfoList;
    }

    public List<Workroleinfo> queryWorkrole(String name, Integer cid, Integer pageNumber, Integer pageSize) {
        if (pageNumber != null) {
            PageHelper.startPage((int)pageNumber, (int)pageSize);
        }
        return this.queryWorkrole(cid, name);
    }

    @Transactional
    public void deleteAll(Integer cid) {
        WorkroleinfoExample e = new WorkroleinfoExample();
        e.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<Workroleinfo> list = this.workroleinfoMapper.selectByExample(e);
        ArrayList<Integer> workIdList = new ArrayList<Integer>();
        for (Workroleinfo a : list) {
            workIdList.add(a.getId());
        }
        Workroleinfo workrole = new Workroleinfo();
        workrole.setIsvalid(Constant.ACTIVE_NO);
        workrole.setExpiretime(new Date());
        this.workroleinfoMapper.updateByExampleSelective(workrole, e);
        if (workIdList.size() > 0) {
            StaffworkroleExample e2 = new StaffworkroleExample();
            e2.or().andRidIn(workIdList);
            Staffworkrole srole = new Staffworkrole();
            srole.setIsvalid(Constant.ACTIVE_NO);
            srole.setLeavetime(new Date());
            srole.setReason("\u4f01\u4e1a\u4fe1\u606f\u521d\u59cb\u5316\uff0c\u5c97\u4f4d\u5220\u9664");
            this.StaffworkroleMapper.updateByExampleSelective(srole, e2);
            WorkroleareaExample e3 = new WorkroleareaExample();
            e3.or().andWorkidIn(workIdList);
            this.WorkroleareaMapper.deleteByExample(e3);
        }
    }
}

