/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic.staff;

import cn.smarthse.core.dao.basic.StaffworkroleMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.Staffworkrole;
import cn.smarthse.core.model.basic.StaffworkroleExample;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StaffWorkRoleService {
    @Autowired
    private StaffworkroleMapper staffworkroleMapper;

    public Staffworkrole get(int id) {
        return this.staffworkroleMapper.selectByPrimaryKey(id);
    }

    public int create(Staffworkrole record) {
        record.setIsvalid(Constant.ACTIVE_YES);
        record.setBegintime(new Date());
        return this.staffworkroleMapper.insertSelective(record);
    }

    public int delete(Integer id) {
        Staffworkrole record = new Staffworkrole();
        record.setId(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        return this.staffworkroleMapper.updateByPrimaryKeySelective(record);
    }

    public int update(Staffworkrole record) {
        return this.staffworkroleMapper.updateByPrimaryKeySelective(record);
    }

    public List<Staffworkrole> getAll(Integer staffId, Integer type, Byte isValid) {
        StaffworkroleExample e = new StaffworkroleExample();
        StaffworkroleExample.Criteria c = e.createCriteria();
        c.andStaffidEqualTo(staffId);
        if (type != null) {
            c.andRtypeEqualTo(type);
        }
        if (isValid != null) {
            c.andIsvalidEqualTo(isValid);
        }
        return this.staffworkroleMapper.selectByExample(e);
    }

    public Staffworkrole getStaffWorkRole(Integer staffId) {
        List<Staffworkrole> list = this.getAll(staffId, 1, (byte)1);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public Staffworkrole getStaffWorkRole(List<Staffworkrole> list) {
        if (list == null) {
            return null;
        }
        for (Staffworkrole a : list) {
            if (a.getIsvalid() != 1 || a.getRtype() == null || a.getRtype() != 1) continue;
            return a;
        }
        return null;
    }

    public List<Staffworkrole> getHistoryList(Integer staffId) {
        List<Staffworkrole> list = this.getAll(staffId, 1, (byte)0);
        return list;
    }

    public List<Staffworkrole> getPartTimeList(Integer staffId) {
        List<Staffworkrole> list = this.getAll(staffId, 2, (byte)1);
        return list;
    }

    @Transactional
    public void updatePartTimeList(Integer staffId, List<Integer> list) {
        List<Staffworkrole> workroleList = this.getPartTimeList(staffId);
        boolean flag = false;
        for (Integer roleId : list) {
            flag = false;
            for (Staffworkrole role : workroleList) {
                if (!role.getRid().equals(roleId)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            Staffworkrole a = new Staffworkrole();
            a.setStaffid(staffId);
            a.setRid(roleId);
            a.setRtype(2);
            this.create(a);
        }
        for (Staffworkrole role : workroleList) {
            flag = false;
            for (Integer roleId : list) {
                if (!role.getRid().equals(roleId)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            this.delete(role.getId());
        }
    }
}

