/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic.staff;

import cn.smarthse.core.dao.basic.CompanyMapper;
import cn.smarthse.core.dao.basic.StaffMapper;
import cn.smarthse.core.dao.basic.StaffdetailsMapper;
import cn.smarthse.core.dao.basic.StaffworkroleMapper;
import cn.smarthse.core.dao.basic.UserbasicinfoMapper;
import cn.smarthse.core.dao.basic.UsercertificateMapper;
import cn.smarthse.core.dao.basic.WorkroleareaMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.common.util.ehcache.EHCacheUtil;
import cn.smarthse.core.model.basic.Company;
import cn.smarthse.core.model.basic.CompanyExample;
import cn.smarthse.core.model.basic.Organization;
import cn.smarthse.core.model.basic.Staff;
import cn.smarthse.core.model.basic.StaffExample;
import cn.smarthse.core.model.basic.Staffdetails;
import cn.smarthse.core.model.basic.Staffworkrole;
import cn.smarthse.core.model.basic.User;
import cn.smarthse.core.model.basic.Userbasicinfo;
import cn.smarthse.core.model.basic.UserbasicinfoExample;
import cn.smarthse.core.model.basic.Usercertificate;
import cn.smarthse.core.model.basic.Workrolearea;
import cn.smarthse.core.model.basic.WorkroleareaExample;
import cn.smarthse.core.model.basic.Workroleinfo;
import cn.smarthse.core.model.basic.vo.StaffQueryVO;
import cn.smarthse.core.model.common.ResponseData;
import cn.smarthse.core.model.init.StaffInit;
import cn.smarthse.core.model.vo.QueryPhysicalCheckParam;
import cn.smarthse.core.model.vo.QueryStaffParam;
import cn.smarthse.core.service.basic.OrganizationService;
import cn.smarthse.core.service.basic.staff.StaffWorkRoleService;
import cn.smarthse.core.service.basic.staff.WorkRoleInfoService;
import cn.smarthse.core.service.contractinfo.ContractInfoService;
import cn.smarthse.core.service.security.UserManager;
import com.github.pagehelper.PageHelper;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class StaffService {
    @Autowired
    private StaffMapper staffMapper;
    @Autowired
    private UsercertificateMapper usercertificateMapper;
    @Autowired
    private StaffWorkRoleService StaffWorkRoleService;
    @Autowired
    private UserbasicinfoMapper userbasicinfoMapper;
    @Autowired
    private StaffdetailsMapper staffdetailsMapper;
    @Autowired
    private OrganizationService OrganizationService;
    @Autowired
    private WorkRoleInfoService WorkRoleInfoService;
    @Autowired
    private ContractInfoService ContractInfoService;
    @Autowired
    private WorkroleareaMapper WorkroleareaMapper;
    @Autowired
    private UserManager userManager;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private CompanyMapper companyMapper;
    @Autowired
    private StaffworkroleMapper staffworkroleMapper;

    public List<Staff> comboQuery(QueryStaffParam param, Integer pageNumber, Integer pageSize) {
        if (pageNumber != null) {
            PageHelper.startPage((int)pageNumber, (int)pageSize);
        }
        return this.staffMapper.comboQuery(param);
    }

    public Staff get(Integer id) {
        if (id == null) {
            return null;
        }
        Staff staff = this.staffMapper.selectDetail(id);
        List<Staffworkrole> list = staff.getStaffworkroleList();
        if (list != null && list.size() > 0) {
            staff.setStaffworkrole(this.StaffWorkRoleService.getStaffWorkRole(list));
        }
        return staff;
    }

    public Staff getStaffById(int id) {
        return this.staffMapper.selectByPrimaryKey(id);
    }

    public Userbasicinfo getUserbasicinfo(String name, String phone, String idCard) {
        List<Userbasicinfo> list;
        UserbasicinfoExample e = new UserbasicinfoExample();
        UserbasicinfoExample.Criteria c = e.createCriteria();
        if (StringUtils.isNotEmpty((String)name)) {
            c.andRealnameEqualTo(name);
        }
        if (StringUtils.isNotEmpty((String)phone)) {
            c.andPhoneEqualTo(phone);
        }
        if (StringUtils.isNotEmpty((String)idCard)) {
            c.andIdcardEqualTo(idCard);
        }
        if ((list = this.userbasicinfoMapper.selectByExample(e)).size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public Staff getStaffByUser(int userid, int cid) {
        return this.staffMapper.selectByUserId(userid, cid);
    }

    @CacheEvict(value={"default"}, key="'Staff-byUser-' + #userid + '-C'+ #cid")
    public void clearStaffByUserCache(int userid, int cid) {
    }

    public Staff selectByUserId(int userId) {
        StaffExample example = new StaffExample();
        StaffExample.Criteria criteria = example.createCriteria();
        criteria.andUidEqualTo(userId);
        List<Staff> staffList = this.staffMapper.selectByExample(example);
        return staffList.size() > 0 ? staffList.get(0) : null;
    }

    @Transactional
    public int create(Staff record) {
        Userbasicinfo basic = null;
        basic = record.getUserbasicid() != null && record.getUserbasicid() > 0 ? this.userbasicinfoMapper.selectByPrimaryKey(record.getUserbasicid()) : record.getBasic();
        if (basic == null) {
            basic = new Userbasicinfo();
            basic.setGender("");
            basic.setAge(0);
        }
        this.userbasicinfoMapper.insertSelective(basic);
        record.setUserbasicid(basic.getId());
        record.setUpdatetime(new Date());
        record.setIsvalid(Constant.ACTIVE_YES);
        this.staffMapper.insertSelective(record);
        Staffdetails details = record.getStaffDetails();
        if (details == null) {
            details = new Staffdetails();
        }
        details.setStaffid(record.getId());
        details.setCreatetime(new Date());
        this.staffdetailsMapper.insertSelective(details);
        if (record.getStaffworkroleList() != null && record.getStaffworkroleList().size() > 0) {
            Staffworkrole wrole = record.getStaffworkroleList().get(0);
            wrole.setStaffid(record.getId());
            this.StaffWorkRoleService.create(wrole);
        }
        return record.getId();
    }

    public int delete(Integer id) {
        EHCacheUtil.remove("staff_cache_" + id);
        Staff staff = this.staffMapper.selectByPrimaryKey(id);
        staff.setIsvalid(Constant.ACTIVE_NO);
        return this.staffMapper.updateByPrimaryKeySelective(staff);
    }

    public int batchDelete(List<Integer> list) {
        for (Integer id : list) {
            EHCacheUtil.remove("staff_cache_" + id);
        }
        StaffExample e = new StaffExample();
        e.createCriteria().andIdIn((List)list);
        Staff record = new Staff();
        record.setIsvalid(Constant.ACTIVE_NO);
        return this.staffMapper.updateByExampleSelective(record, e);
    }

    @Transactional
    public int update(Staff record, List<Integer> workList) {
        List<Staffworkrole> swrList;
        EHCacheUtil.remove("staff_cache_" + record.getId());
        if (record.getId() == null) {
            return this.create(record);
        }
        Staff oldStaff = this.get(record.getId());
        int count = 0;
        if (record.getBasic() != null && (StringUtils.isNotEmpty((String)record.getBasic().getRealname()) || record.getBasic().getFaceid() != null)) {
            count += this.userbasicinfoMapper.updateByPrimaryKeySelective(record.getBasic());
            Staffdetails details = record.getStaffDetails();
            if (details != null) {
                details.setCreatetime(new Date());
                count += this.staffdetailsMapper.updateByPrimaryKeySelective(details);
            }
        }
        if (record.getBasic() != null && record.getBasic().getWorktime() != null) {
            count += this.userbasicinfoMapper.updateByPrimaryKeySelective(record.getBasic());
        }
        Staffworkrole oldRole = null;
        Staffworkrole staffWorkRole = null;
        if (oldStaff != null && oldStaff.getStaffworkrole() != null) {
            oldRole = oldStaff.getStaffworkrole();
        }
        if ((swrList = record.getStaffworkroleList()) != null && swrList.size() > 0) {
            staffWorkRole = swrList.get(0);
        }
        if (staffWorkRole != null) {
            count = this.staffMapper.updateByPrimaryKeySelective(record);
            if (staffWorkRole.getId() == null) {
                staffWorkRole.setStaffid(record.getId());
                this.StaffWorkRoleService.create(staffWorkRole);
            } else {
                staffWorkRole.setIsvalid(Constant.ACTIVE_YES);
                this.StaffWorkRoleService.update(staffWorkRole);
            }
        }
        if (workList != null && workList.size() > 0) {
            this.StaffWorkRoleService.updatePartTimeList(record.getId(), workList);
        }
        boolean needInform = false;
        if (staffWorkRole != null && oldRole != null) {
            if (!staffWorkRole.getRid().equals(oldRole.getRid())) {
                needInform = true;
            }
            if (staffWorkRole.getStatus() == 1 && oldRole.getStatus() == 2) {
                needInform = true;
            }
            if (needInform) {
                this.ContractInfoService.addInform(record.getId(), staffWorkRole.getRid());
            }
        }
        return count;
    }

    public int updateSimple(Staff record) {
        int count = this.staffMapper.updateByPrimaryKeySelective(record);
        return count;
    }

    public Staff getByUsername(String name) {
        User user = this.userManager.getByName(name);
        if (user == null) {
            return null;
        }
        StaffExample e = new StaffExample();
        e.createCriteria().andUidEqualTo(user.getId()).andCidEqualTo(user.getCid());
        List<Staff> list = this.staffMapper.selectByExample(e);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public Staff getByID(Integer id) {
        if (id == null || id == 0) {
            return null;
        }
        StaffExample e = new StaffExample();
        StaffExample.Criteria c = e.createCriteria();
        c.andUidEqualTo(id);
        c.andLeavetimeIsNull();
        List<Staff> list = this.staffMapper.selectByExample(e);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<Staff> getAll(Integer companyId) {
        StaffExample e = new StaffExample();
        e.createCriteria().andCidEqualTo(companyId).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<Staff> list = this.staffMapper.selectByExample(e);
        return list;
    }

    @Transactional
    public void deleteAll(Integer cid, Integer exceptionalStaffId) {
        StaffExample e = new StaffExample();
        e.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES).andIdNotEqualTo(exceptionalStaffId);
        Staff staff = new Staff();
        staff.setIsvalid(Constant.ACTIVE_NO);
        staff.setUpdatetime(new Date());
        this.staffMapper.updateByExampleSelective(staff, e);
    }

    public List<Workrolearea> getAllWorkrolearea(Integer companyId) {
        WorkroleareaExample e = new WorkroleareaExample();
        e.or().andCidEqualTo(companyId);
        List<Workrolearea> list = this.WorkroleareaMapper.selectByExample(e);
        return list;
    }

    public List<Staff> getStaffList(Integer companyId, Boolean isThirdParty, Integer pageNumber, Integer pageSize) {
        if (pageNumber != null) {
            PageHelper.startPage((int)pageNumber, (int)pageSize);
        }
        QueryStaffParam param = new QueryStaffParam();
        param.setCid(companyId);
        param.setIsThirdParty(isThirdParty);
        return this.staffMapper.comboQuery(param);
    }

    public List<Staff> getOrgMembers(Integer companyId, Integer orgid) {
        List<Staff> list = this.staffMapper.selectAll(companyId, orgid);
        return list;
    }

    public ResponseData<StaffInit> getStaffInitInfoFromExcel(String fileName, Map<String, Object> paramMap) throws Exception {
        ResponseData<StaffInit> data = new ResponseData<StaffInit>();
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)new FileInputStream(fileName));
        HSSFSheet sheet = wb.getSheetAt(0);
        StaffInit init = new StaffInit();
        Map<String, String> deptMap = init.getDeptMap();
        Map<String, String> workroleMap = init.getWorkroleMap();
        Map<String, String> comMap = init.getComMap();
        int basicId = 1;
        int rowIndex = 0;
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1 || row.getCell(3) == null || row.getCell(3).getCellType() == 3) continue;
            Staff staff = new Staff();
            Userbasicinfo basic = new Userbasicinfo();
            basic.setId(basicId++);
            staff.setId(basic.getId());
            staff.setUserbasicid(basic.getId());
            Staffworkrole workrole = new Staffworkrole();
            workrole.setId(basic.getId());
            int cellCount = 23;
            int colIndex = 0;
            block38: for (int i = 0; i < cellCount; ++i) {
                Cell cell = row.getCell(i);
                ++colIndex;
                if (cell == null || cell.getCellType() == 3) continue;
                switch (i) {
                    case 0: {
                        String yesOrNo;
                        try {
                            yesOrNo = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setCode(-6);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u5916\u534f\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (yesOrNo.equals("\u662f")) {
                            workrole.setIsthirdparty(Constant.ACTIVE_YES);
                            continue block38;
                        }
                        if (yesOrNo.equals("\u5426")) {
                            workrole.setIsthirdparty(Constant.ACTIVE_NO);
                            continue block38;
                        }
                        data.setCode(-4);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u5916\u534f\u683c\u5f0f\u4e0d\u5bf9");
                        return data;
                    }
                    case 1: {
                        String company = cell.getStringCellValue().trim();
                        workrole.setThirdpartyName(company);
                        if (comMap.get(company) != null) continue block38;
                        comMap.put(company, company);
                        continue block38;
                    }
                    case 2: {
                        String number;
                        try {
                            number = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setCode(-1);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5de5\u53f7\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staff.setWorkno(number);
                        continue block38;
                    }
                    case 3: {
                        basic.setRealname(cell.getStringCellValue().trim());
                        continue block38;
                    }
                    case 4: {
                        String dept = cell.getStringCellValue().trim();
                        if (deptMap.get(dept) == null) {
                            deptMap.put(dept, dept);
                        }
                        staff.setOrgname(dept);
                        continue block38;
                    }
                    case 5: {
                        String work = cell.getStringCellValue().trim();
                        if (workroleMap.get(work) == null) {
                            workroleMap.put(work, work);
                        }
                        workrole.setRname(work);
                        continue block38;
                    }
                    case 6: {
                        String gender;
                        try {
                            gender = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setCode(-6);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6027\u522b\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (gender.equals("\u7537")) {
                            basic.setGender("1");
                            continue block38;
                        }
                        if (gender.equals("\u5973")) {
                            basic.setGender("2");
                            continue block38;
                        }
                        data.setCode(-4);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6027\u522b\u683c\u5f0f\u4e0d\u5bf9");
                        return data;
                    }
                    case 7: {
                        try {
                            String phone = cell.getStringCellValue().trim();
                            basic.setPhone(phone);
                            continue block38;
                        }
                        catch (Exception e) {
                            data.setCode(-5);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8054\u7cfb\u65b9\u5f0f\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 8: {
                        try {
                            basic.setBirthday(this.getExcelDate((int)cell.getNumericCellValue()));
                            continue block38;
                        }
                        catch (Exception e) {
                            data.setCode(-6);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u51fa\u751f\u5e74\u6708\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 9: {
                        String job = cell.getStringCellValue().trim();
                        staff.setJobtitle(job);
                        continue block38;
                    }
                    case 10: {
                        String idcard = cell.getStringCellValue();
                        basic.setIdcard(idcard);
                        continue block38;
                    }
                    case 11: {
                        basic.setNativeplace(cell.getStringCellValue().trim());
                        continue block38;
                    }
                    case 12: {
                        basic.setNation(cell.getStringCellValue().trim());
                        continue block38;
                    }
                    case 13: {
                        String marriage = cell.getStringCellValue().trim();
                        if (marriage.equals("\u5df2\u5a5a")) {
                            basic.setIsmarried((byte)1);
                            continue block38;
                        }
                        if (marriage.equals("\u672a\u5a5a")) {
                            basic.setIsmarried((byte)0);
                            continue block38;
                        }
                        data.setCode(-9);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5a5a\u59fb\u72b6\u51b5\u683c\u5f0f\u4e0d\u5bf9");
                        return data;
                    }
                    case 14: {
                        String collage = cell.getCellType() == 0 ? cell.getNumericCellValue() + "" : cell.getStringCellValue();
                        basic.setEducation(collage);
                        continue block38;
                    }
                    case 15: {
                        String major = cell.getCellType() == 0 ? cell.getNumericCellValue() + "" : cell.getStringCellValue();
                        basic.setMajor(major);
                        continue block38;
                    }
                    case 16: {
                        staff.setJointime(this.getExcelDate((int)cell.getNumericCellValue()));
                        continue block38;
                    }
                    case 17: {
                        basic.setWorktime(this.getExcelDate((int)cell.getNumericCellValue()));
                        continue block38;
                    }
                    case 18: {
                        String isRadiation;
                        try {
                            isRadiation = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setCode(-6);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u662f\u5426\u653e\u5c04\u4eba\u5458\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (isRadiation.equals("\u662f")) {
                            staff.setIsradiation(Constant.ACTIVE_YES);
                            continue block38;
                        }
                        if (isRadiation.equals("\u5426")) {
                            staff.setIsradiation(Constant.ACTIVE_NO);
                            continue block38;
                        }
                        data.setCode(-4);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u662f\u5426\u653e\u5c04\u4eba\u5458\u683c\u5f0f\u4e0d\u5bf9");
                        return data;
                    }
                    case 19: {
                        Date date1 = this.getExcelDate((int)cell.getNumericCellValue());
                        Date date2 = new Date();
                        long diff = date2.getTime() - date1.getTime();
                        float days = diff / 86400000L;
                        staff.setRadiationyear(Float.valueOf(days));
                        continue block38;
                    }
                    case 20: {
                        staff.setOccExposureWorkingtype(cell.getStringCellValue().trim());
                        continue block38;
                    }
                    case 21: {
                        String specialName;
                        int m;
                        Integer id2;
                        String idS;
                        String s;
                        int j;
                        String type = cell.getStringCellValue().trim();
                        List objList = (List)paramMap.get("spec_operation_type");
                        for (j = 0; j < objList.size(); ++j) {
                            s = objList.get(j).toString();
                            idS = s.substring(s.indexOf("id=") + 3, s.indexOf(","));
                            id2 = new Integer(idS);
                            m = s.indexOf("paramvalue=");
                            specialName = (s = s.substring(m)).substring(s.indexOf("paramvalue") + 11, s.indexOf(","));
                            if (!type.equals(specialName)) continue;
                            workrole.setSpecialoperations(id2);
                        }
                        continue block38;
                    }
                    case 22: {
                        String specialName;
                        int m;
                        Integer id2;
                        String idS;
                        String s;
                        int j;
                        String type = cell.getStringCellValue().trim();
                        List objList = (List)paramMap.get("spec_working_type");
                        for (j = 0; j < objList.size(); ++j) {
                            s = objList.get(j).toString();
                            idS = s.substring(s.indexOf("id=") + 3, s.indexOf(","));
                            id2 = new Integer(idS);
                            m = s.indexOf("paramvalue=");
                            specialName = (s = s.substring(m)).substring(s.indexOf("paramvalue") + 11, s.indexOf(","));
                            if (!type.equals(specialName)) continue;
                            workrole.setSpecialwork(id2);
                        }
                        continue block38;
                    }
                }
            }
            init.getStaffList().add(staff);
            init.getWorkroleList().add(workrole);
            init.getBasicList().add(basic);
        }
        wb.close();
        data.setResult(init);
        return data;
    }

    private Date getExcelDate(int days) {
        Calendar c3 = Calendar.getInstance();
        c3.set(1900, 0, -1);
        c3.add(5, days);
        return c3.getTime();
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    @Transactional
    public ResponseData<String> initImport(StaffInit init) {
        int i;
        Object s;
        Object r;
        int cid = init.getCompanyId();
        ResponseData<String> data = new ResponseData<String>();
        Map<String, String> deptMap = init.getDeptMap();
        Map<String, String> workroleMap = init.getWorkroleMap();
        Map<String, String> comMap = init.getComMap();
        List<Staff> staffList = init.getStaffList();
        List<Userbasicinfo> basicList = init.getBasicList();
        List<Staffworkrole> workroleList = init.getWorkroleList();
        for (Map.Entry<String, String> entry : deptMap.entrySet()) {
            r = this.OrganizationService.getByName(cid, entry.getKey());
            if (r == null) {
                r = new Organization();
                ((Organization)r).setCid(cid);
                ((Organization)r).setFulname(entry.getKey());
                ((Organization)r).setCreatetime(new Date());
                this.OrganizationService.insert((Organization)r);
            }
            for (int i2 = 0; i2 < staffList.size(); ++i2) {
                s = staffList.get(i2);
                if (((Staff)s).getOrgname() == null || !((Staff)s).getOrgname().equals(entry.getValue())) continue;
                ((Staff)s).setOrgid(((Organization)r).getId());
            }
        }
        for (Map.Entry<String, String> entry : comMap.entrySet()) {
            Integer comId;
            CompanyExample c = new CompanyExample();
            c.createCriteria().andNameEqualTo(entry.getValue());
            List<Company> list = this.companyMapper.selectByExample(c);
            Company com = new Company();
            if (list != null && list.size() > 0) {
                comId = list.get(0).getId();
            } else {
                com.setName(entry.getValue());
                com.setRegistertime(new Date());
                this.companyMapper.insert(com);
                comId = com.getId();
            }
            for (int i3 = 0; i3 < workroleList.size(); ++i3) {
                Staffworkrole s2 = workroleList.get(i3);
                if (s2.getThirdpartyName() == null || !s2.getThirdpartyName().equals(entry.getValue())) continue;
                s2.setThirdpartyCid(comId);
            }
        }
        for (Map.Entry<String, String> entry : workroleMap.entrySet()) {
            r = this.WorkRoleInfoService.getByName(cid, entry.getKey());
            if (r == null) {
                r = new Workroleinfo();
                ((Workroleinfo)r).setCid(cid);
                ((Workroleinfo)r).setWorkname(entry.getKey());
                ((Workroleinfo)r).setCreatetime(new Date());
                this.WorkRoleInfoService.create((Workroleinfo)r);
            }
            for (int i4 = 0; i4 < workroleList.size(); ++i4) {
                s = workroleList.get(i4);
                if (((Staffworkrole)s).getRname() == null || !((Staffworkrole)s).getRname().equals(entry.getValue())) continue;
                ((Staffworkrole)s).setRid(((Workroleinfo)r).getId());
            }
        }
        for (i = 0; i < basicList.size(); ++i) {
            Userbasicinfo thisUser = basicList.get(i);
            int id = thisUser.getId();
            Userbasicinfo r2 = this.getUserbasicinfo(thisUser.getRealname(), thisUser.getPhone(), thisUser.getIdcard());
            if (r2 == null) {
                thisUser.setId(null);
                this.userbasicinfoMapper.insertSelective(thisUser);
                r2 = thisUser;
            }
            for (int j = 0; j < staffList.size(); ++j) {
                Staff s3 = staffList.get(j);
                if (s3.getUserbasicid() != id) continue;
                s3.setUserbasicid(r2.getId());
            }
        }
        block8: for (i = 0; i < staffList.size(); ++i) {
            Staff r3 = staffList.get(i);
            int id = r3.getId();
            r3.setId(null);
            r3.setCid(cid);
            r3.setIsvalid(Constant.ACTIVE_YES);
            this.staffMapper.insertSelective(r3);
            for (int j = 0; j < workroleList.size(); ++j) {
                Staffworkrole s4 = workroleList.get(i);
                if (s4.getId() == null || !s4.getId().equals(id)) continue;
                s4.setStaffid(r3.getId());
                s4.setIsvalid(Constant.ACTIVE_YES);
                s4.setId(null);
                this.staffworkroleMapper.insertSelective(s4);
                continue block8;
            }
        }
        return data;
    }

    public Map<Integer, List<Staff>> getStaffByOrg(Integer cid) {
        HashMap<Integer, List<Staff>> map = new HashMap<Integer, List<Staff>>();
        List<Organization> orgList = this.organizationService.getAll(cid);
        for (int i = 0; i < orgList.size(); ++i) {
            int orgid = orgList.get(i).getId();
            List<Staff> list = this.getOrgMembers(cid, orgid);
            map.put(orgid, list);
        }
        return map;
    }

    public int createCertificate(Usercertificate record) {
        return this.usercertificateMapper.insertSelective(record);
    }

    public Usercertificate getCertificate(Integer id) {
        return this.usercertificateMapper.selectByPrimaryKey(id);
    }

    public int deleteCertificate(Integer id) {
        return this.usercertificateMapper.deleteByPrimaryKey(id);
    }

    public int updateCertificate(Usercertificate record) {
        return this.usercertificateMapper.updateByPrimaryKeySelective(record);
    }

    public List<Staff> query(Boolean isChange, Integer cid, String name, Integer pageNumber, Integer pageSize) {
        UserbasicinfoExample e1 = new UserbasicinfoExample();
        e1.createCriteria().andRealnameLike("%" + name + "%");
        List<Userbasicinfo> basicList = this.userbasicinfoMapper.selectByExample(e1);
        if (basicList == null || basicList.size() < 1) {
            return null;
        }
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (int i = 0; i < basicList.size(); ++i) {
            idList.add(basicList.get(i).getId());
        }
        StaffExample e = new StaffExample();
        StaffExample.Criteria c = e.createCriteria();
        c.andUserbasicidIn(idList).andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        if (isChange.booleanValue()) {
            c.andIschangeworkEqualTo(Constant.ACTIVE_YES);
        }
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        return this.staffMapper.selectByExample(e);
    }

    public List<Staff> healthCheckQuery(QueryPhysicalCheckParam param, Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        return this.staffMapper.healthCheckQuery(param);
    }

    @Cacheable(value={"staff"}, key="'Staff-Manger-byID-' + #staffId")
    public String getStaffNameOrgByStaffId(Integer staffId) {
        if (staffId == null) {
            return null;
        }
        Staff staff = this.staffMapper.selectStaffByIdWithOrg(staffId);
        if (staff != null && staff.getBasic() != null) {
            String organAndName = staff.getOrganization().getFullname() + "/" + staff.getBasic().getRealname();
            return organAndName;
        }
        return null;
    }

    @CacheEvict(value={"staff"}, key="'Staff-Manger-byID-' + #staffId")
    public void clearStaffNameOrgByStaffIdCache(Integer staffId) {
    }

    @CacheEvict(value={"staff"}, allEntries=true)
    public void clearStaffCache() {
    }

    public List<Staff> selectAllCheckStaffByQuerVO(StaffQueryVO param) {
        if (StringUtils.isNotEmpty((String)param.getWorkRoleStatus())) {
            return this.staffMapper.selectStaffByWorkRoleStatus(param);
        }
        return this.staffMapper.selectAllCheckStaffByQuerVO(param);
    }

    public List<Staff> selectByQuerVO(StaffQueryVO param) {
        return this.staffMapper.selectByQuerVO(param);
    }

    public List<Staff> selectByCheckInfo(Integer id, Integer type) {
        return this.staffMapper.selectByCheckInfo(id, type);
    }

    public List<Staff> selectCheckedStaffByQuerVO(StaffQueryVO param) {
        return this.staffMapper.selectCheckedStaffByQuerVO(param);
    }
}

