/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic.pdmonitor;

import cn.smarthse.core.dao.basic.pdmonitor.PdMonitorMapper;
import cn.smarthse.core.dao.basic.pdmonitor.PdMonitorNoticeFeedbackMapper;
import cn.smarthse.core.framework.common.util.ShiroUtils;
import cn.smarthse.core.model.basic.pdmonitor.PdMonitor;
import cn.smarthse.core.model.basic.pdmonitor.PdMonitorCheck;
import cn.smarthse.core.model.basic.pdmonitor.PdMonitorExample;
import cn.smarthse.core.model.basic.pdmonitor.PdMonitorNoticeFeedback;
import cn.smarthse.core.model.basic.pdmonitor.PdMonitorNoticeFeedbackExample;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.basic.pdmonitor.PdMonitorCheckService;
import cn.smarthse.core.service.workflow.IWorkflowService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PdMonitorService
implements IWorkflowService {
    @Autowired
    PdMonitorMapper pdMonitorMapper;
    @Autowired
    PdMonitorNoticeFeedbackMapper pdMonitorNoticeFeedBackMapper;
    @Autowired
    PdMonitorCheckService pdMonitorCheckService;

    public PdMonitor addPdMonitor(PdMonitor record) {
        this.pdMonitorMapper.insertSelective(record);
        return record;
    }

    public PdMonitor getPdMonitorById(int id) {
        return this.pdMonitorMapper.selectByPrimaryKey(id);
    }

    public int updatePdMonitor(PdMonitor record) {
        return this.pdMonitorMapper.updateByPrimaryKeySelective(record);
    }

    public int deletePdMonitor(PdMonitor record) {
        return this.pdMonitorMapper.deleteByPrimaryKey(record.getId());
    }

    public List<PdMonitor> getPdMonitorListByExample(PdMonitorExample example) {
        return this.pdMonitorMapper.selectByExample(example);
    }

    public List<Map<String, Object>> getPdMonitorNoFinishList(PdMonitor pd) {
        return this.pdMonitorMapper.getPdMonitorNoFinishList(pd);
    }

    public List<Map<String, Object>> getStaffInfo(Integer cid) {
        return this.pdMonitorMapper.getStaffInfo(cid);
    }

    public List<Map<String, Object>> getPdStaffList(PdMonitor pdm) {
        return this.pdMonitorMapper.getPdStaffList(pdm);
    }

    public String getParamValue(Integer valueOf) {
        return this.pdMonitorMapper.getParamValue(valueOf);
    }

    public String getBusinessPathCheck(Integer businessId, Boolean isApprove) {
        return "forward:/staff/pdcheck/gopdcheckedit?approve=1&id=" + businessId;
    }

    @Override
    public void workflow(WorkFlowParam param, Integer orderId) {
        PdMonitor record = this.getPdMonitorById(param.getBusinessId());
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            if (record.getPhrase() == 1) {
                record.setPhrase(2);
            } else if (record.getPhrase() == 2) {
                record.setNeednotice(true);
            } else if (record.getPhrase() == 3) {
                record.setPhrase(4);
            } else if (record.getPhrase() == 4) {
                record.setPhrase(5);
            } else if (record.getPhrase() == 5 || record.getPhrase() == 0 && record.getRedoarchival().booleanValue()) {
                record.setEndarchivaltime(new Date());
                record.setPhrase(6);
            }
            record.setUpdatedate(new Date());
            this.updatePdMonitor(record);
        }
        if (param.getEnd().booleanValue()) {
            param.getApproved().booleanValue();
        }
    }

    public void workflowCheck(WorkFlowParam param, Integer orderId) {
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            PdMonitorCheck check = new PdMonitorCheck();
            check.setId(param.getBusinessId());
            check.setApproval(1);
            check.setClosetime(new Date());
            this.pdMonitorCheckService.updatePdMonitorCheck(check);
        }
    }

    public void workflowInform(WorkFlowParam param) {
        PdMonitor record = new PdMonitor();
        record.setId(param.getBusinessId());
        record.setPhrase(3);
        this.updatePdMonitor(record);
        if (!param.getEnd().booleanValue()) {
            String approver = param.getReceiver();
            if (approver != null && approver.length() > 0) {
                String[] approvers;
                String[] stringArray = approvers = approver.split(",");
                int n = approvers.length;
                int n2 = 0;
                while (n2 < n) {
                    String appr = stringArray[n2];
                    PdMonitorNoticeFeedback feedBack = new PdMonitorNoticeFeedback();
                    feedBack.setCreateby(ShiroUtils.getUserId());
                    feedBack.setIsfeedback(0);
                    feedBack.setMonitorId(param.getBusinessId());
                    feedBack.setWho(Integer.valueOf(appr));
                    this.pdMonitorNoticeFeedBackMapper.insertSelective(feedBack);
                    ++n2;
                }
            }
        } else {
            PdMonitorNoticeFeedback feedback = new PdMonitorNoticeFeedback();
            PdMonitorNoticeFeedbackExample feedbackExample = new PdMonitorNoticeFeedbackExample();
            feedback.setFeedbackcontent(param.getRemark());
            feedback.setFeedbacktime(new Date());
            feedback.setFeedbackcontent(param.getNoAgreeInfo());
            feedback.setFeedbackcontentother(param.getNoAgreeOtherInfo());
            if (param.getApproved().booleanValue()) {
                feedback.setIsfeedback(1);
            } else {
                feedback.setIsfeedback(-1);
            }
            feedback.setUpdateby(ShiroUtils.getUserId());
            feedbackExample.createCriteria().andMonitorIdEqualTo(param.getBusinessId()).andWhoEqualTo(ShiroUtils.getUserId());
            this.pdMonitorNoticeFeedBackMapper.updateByExampleSelective(feedback, feedbackExample);
        }
    }

    public String getInformPath(Integer businessId) {
        return "forward:/pdmonitorfeedback/pdmonitorfeedback?feedback=1&id=" + businessId;
    }

    public List<Map<String, Object>> getPdCheckNoFinish(Map<String, Object> data) {
        return this.pdMonitorMapper.getPdCheckNoFinish(data);
    }

    @Override
    public String doTask(Integer businessId, String taskName) {
        PdMonitor record = this.getPdMonitorById(businessId);
        boolean isApprove = true;
        if ("read".equals(taskName)) {
            return "forward:/pdmonitorfeedback/pdmonitorfeedback?feedback=1&id=" + businessId;
        }
        switch (record.getPhrase()) {
            case 1: {
                if (isApprove) {
                    return "forward:/staff/pdmonitor/pdmonitorplan?approve=1&id=" + businessId;
                }
                return "forward:/staff/pdmonitor/pdmonitorplan?approve=0&check&id=" + businessId;
            }
            case 2: {
                if (isApprove) {
                    return "forward:/staff/pdmonitor/pdmonitorstart?approve=1&id=" + businessId;
                }
                return "forward:/staff/pdmonitor/pdmonitorstart?approve=0&check&id=" + businessId;
            }
            case 3: {
                if (isApprove) {
                    return "forward:/staff/pdmonitor/pdmonitorstart?approve=1&id=" + businessId;
                }
                return "forward:/staff/pdmonitor/pdmonitorstart?approve=0&check&id=" + businessId;
            }
            case 4: {
                if (isApprove) {
                    return "forward:/staff/pdmonitor/pdmonitorreport?approve=1&id=" + businessId + "&approval=1";
                }
                return "forward:/staff/pdmonitor/pdmonitorstart?approve=0&check&id=" + businessId;
            }
            case 5: {
                if (isApprove) {
                    return "forward:/staff/pdmonitor/pdmonitorarchive?approve=1&id=" + businessId + "&approval=1";
                }
                return "forward:/staff/pdmonitor/pdmonitorstart?approve=0&check&id=" + businessId;
            }
            case 0: {
                if (isApprove) {
                    return "forward:/staff/pdmonitor/goPdmonitorBlda?approve=1&id=" + businessId + "&approval=1";
                }
                return "forward:/staff/pdmonitor/pdmonitorstart?approve=0&check&id=" + businessId;
            }
        }
        return "/commons/404";
    }

    @Override
    public String doApproveTask(Integer businessId) {
        return null;
    }

    @Override
    public int terminateTask(Integer businessId) {
        return 0;
    }

    @Override
    public String addWorkUrl() {
        return "staff/pdmonitor/pdmonitorplan?redoarchival=0&menuid=431";
    }

    @Override
    public String workflowInform(WorkFlowParam param, Integer orderId) {
        PdMonitor record = new PdMonitor();
        record.setId(param.getBusinessId());
        record.setPhrase(3);
        this.updatePdMonitor(record);
        if (!param.getEnd().booleanValue()) {
            String approver = param.getReceiver();
            if (approver != null && approver.length() > 0) {
                String[] approvers;
                String[] stringArray = approvers = approver.split(",");
                int n = approvers.length;
                int n2 = 0;
                while (n2 < n) {
                    String appr = stringArray[n2];
                    PdMonitorNoticeFeedback feedBack = new PdMonitorNoticeFeedback();
                    feedBack.setCreateby(ShiroUtils.getUserId());
                    feedBack.setIsfeedback(0);
                    feedBack.setMonitorId(param.getBusinessId());
                    feedBack.setWho(Integer.valueOf(appr));
                    this.pdMonitorNoticeFeedBackMapper.insertSelective(feedBack);
                    ++n2;
                }
            }
        } else {
            PdMonitorNoticeFeedback feedback = new PdMonitorNoticeFeedback();
            PdMonitorNoticeFeedbackExample feedbackExample = new PdMonitorNoticeFeedbackExample();
            feedback.setFeedbackcontent(param.getRemark());
            feedback.setFeedbacktime(new Date());
            feedback.setFeedbackcontent(param.getNoAgreeInfo());
            feedback.setFeedbackcontentother(param.getNoAgreeOtherInfo());
            if (param.getApproved().booleanValue()) {
                feedback.setIsfeedback(1);
            } else {
                feedback.setIsfeedback(-1);
            }
            feedback.setUpdateby(ShiroUtils.getUserId());
            feedbackExample.createCriteria().andMonitorIdEqualTo(param.getBusinessId()).andWhoEqualTo(ShiroUtils.getUserId());
            this.pdMonitorNoticeFeedBackMapper.updateByExampleSelective(feedback, feedbackExample);
        }
        return "/staff/pdmonitorfeedback/pdmonitorfeedback?menuid=431&id=" + param.getBusinessId();
    }
}

