/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic.harmfactor;

import cn.smarthse.core.dao.basic.DeclaredetailsMapper;
import cn.smarthse.core.dao.basic.WorkareaharmfactorMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.Declaredetails;
import cn.smarthse.core.model.basic.DeclaredetailsExample;
import cn.smarthse.core.model.basic.Workareaharmfactor;
import cn.smarthse.core.model.basic.WorkareaharmfactorExample;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.workflow.IWorkflowService;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class WorkAreaHarmFactorService
implements IWorkflowService {
    @Autowired
    private WorkareaharmfactorMapper mapper;
    @Autowired
    private DeclaredetailsMapper declaredetailsMapper;

    public Workareaharmfactor get(Integer id) {
        return this.mapper.selectByPrimaryKey(id);
    }

    @Transactional
    public int create(Workareaharmfactor record) {
        record.setIsvalid(Constant.ACTIVE_YES);
        int count = this.mapper.insertSelective(record);
        return count;
    }

    @Transactional
    public int delete(Integer id) {
        Workareaharmfactor record = new Workareaharmfactor();
        record.setId(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        int count = this.mapper.updateByPrimaryKeySelective(record);
        DeclaredetailsExample e = new DeclaredetailsExample();
        e.createCriteria().andDeclareidEqualTo(id);
        Declaredetails d = new Declaredetails();
        d.setIsvalid(Constant.ACTIVE_NO);
        return count += this.declaredetailsMapper.updateByExampleSelective(d, e);
    }

    @Transactional
    public int batchDelete(List<Workareaharmfactor> list) {
        int count = 0;
        int i = 0;
        while (i < list.size()) {
            count += this.delete(list.get(i).getId());
            ++i;
        }
        return count;
    }

    @Transactional
    public int update(Workareaharmfactor record) {
        int count = this.mapper.updateByPrimaryKeySelective(record);
        return count;
    }

    public List<Workareaharmfactor> getAll(Integer cid, Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        WorkareaharmfactorExample e = new WorkareaharmfactorExample();
        e.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES).andWorkidIsNotNull().andAreaidIsNull();
        e.setOrderByClause(" workid");
        List<Workareaharmfactor> list = this.mapper.selectByExample(e);
        return list;
    }

    public List<Workareaharmfactor> getareaAll(Integer cid, Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        WorkareaharmfactorExample e = new WorkareaharmfactorExample();
        e.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES).andAreaidIsNotNull().andWorkidIsNull();
        e.setOrderByClause(" areaid");
        List<Workareaharmfactor> list = this.mapper.selectByExample(e);
        return list;
    }

    public List<Workareaharmfactor> getListByWorkId(Integer workid) {
        WorkareaharmfactorExample e = new WorkareaharmfactorExample();
        e.createCriteria().andIsvalidEqualTo(Constant.ACTIVE_YES).andWorkidEqualTo(workid);
        e.setOrderByClause(" workid");
        List<Workareaharmfactor> list = this.mapper.selectByExample(e);
        return list;
    }

    public List<Workareaharmfactor> getListByAreaId(Integer areaid) {
        WorkareaharmfactorExample e = new WorkareaharmfactorExample();
        e.createCriteria().andIsvalidEqualTo(Constant.ACTIVE_YES).andAreaidEqualTo(areaid);
        e.setOrderByClause(" areaid");
        List<Workareaharmfactor> list = this.mapper.selectByExample(e);
        return list;
    }

    public List<Workareaharmfactor> findarea(String parameterName) {
        List<Workareaharmfactor> list = this.mapper.selectareaByParameter(parameterName);
        return list;
    }

    public List<Workareaharmfactor> findwork(String parameterName) {
        List<Workareaharmfactor> list = this.mapper.selectworkByParameter(parameterName);
        return list;
    }

    public List<Workareaharmfactor> list(Workareaharmfactor data) {
        WorkareaharmfactorExample example = new WorkareaharmfactorExample();
        return this.mapper.selectByExample(example);
    }

    @Override
    public String doApproveTask(Integer businessId) {
        return null;
    }

    @Override
    public int terminateTask(Integer businessId) {
        return 0;
    }

    @Override
    public void workflow(WorkFlowParam param, Integer orderId) {
    }

    @Override
    public String doTask(Integer businessId, String taskName) {
        return null;
    }

    @Override
    public String addWorkUrl() {
        return null;
    }

    @Override
    public String workflowInform(WorkFlowParam param, Integer orderId) {
        return null;
    }
}

