/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic.harmfactor;

import cn.smarthse.core.dao.basic.DeclaredetailsMapper;
import cn.smarthse.core.dao.basic.HarmfactordeclareMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.Declaredetails;
import cn.smarthse.core.model.basic.DeclaredetailsExample;
import cn.smarthse.core.model.basic.Harmfactordeclare;
import cn.smarthse.core.model.basic.HarmfactordeclareExample;
import cn.smarthse.core.model.vo.QueryStaffParam;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.workflow.IWorkflowService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class HarmFactorDeclareService
implements IWorkflowService {
    @Autowired
    private HarmfactordeclareMapper mapper;
    @Autowired
    private DeclaredetailsMapper declaredetailsMapper;

    public Harmfactordeclare get(Integer id) {
        return this.mapper.selectByPrimaryKey(id);
    }

    @Transactional
    public int create(Harmfactordeclare record) {
        record.setIsvalid(Constant.ACTIVE_YES);
        record.setUpdatetime(new Date());
        int count = this.mapper.insertSelective(record);
        List<Declaredetails> list = record.getDetailsList();
        if (list != null && list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                Declaredetails details = list.get(i);
                details.setDeclareid(record.getId());
                details.setIsvalid(Constant.ACTIVE_YES);
                details.setWorkplace(list.get(0).getWorkplace());
                details.setTotalnum(list.get(0).getTotalnum());
                count += this.create(details);
                ++i;
            }
        }
        return count;
    }

    @Transactional
    public int delete(Integer id) {
        Harmfactordeclare record = new Harmfactordeclare();
        record.setId(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        int count = this.mapper.updateByPrimaryKeySelective(record);
        DeclaredetailsExample e = new DeclaredetailsExample();
        e.createCriteria().andDeclareidEqualTo(id);
        Declaredetails d = new Declaredetails();
        d.setIsvalid(Constant.ACTIVE_NO);
        return count += this.declaredetailsMapper.updateByExampleSelective(d, e);
    }

    @Transactional
    public int batchDelete(List<Integer> list) {
        int count = 0;
        int i = 0;
        while (i < list.size()) {
            count += this.delete(list.get(i));
            ++i;
        }
        return count;
    }

    @Transactional
    public int deletePlace(Integer id, String place) {
        int count = 0;
        DeclaredetailsExample e = new DeclaredetailsExample();
        e.createCriteria().andDeclareidEqualTo(id).andWorkplaceEqualTo(place);
        Declaredetails d = new Declaredetails();
        d.setIsvalid(Constant.ACTIVE_NO);
        return count += this.declaredetailsMapper.updateByExampleSelective(d, e);
    }

    @Transactional
    public int update(Harmfactordeclare record) {
        record.setUpdatetime(new Date());
        int count = this.mapper.updateByPrimaryKeySelective(record);
        List<Declaredetails> list = record.getDetailsList();
        if (list != null && list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                Declaredetails details = list.get(i);
                details.setDeclareid(record.getId());
                details.setIsvalid(Constant.ACTIVE_YES);
                details.setWorkplace(list.get(0).getWorkplace());
                details.setTotalnum(list.get(0).getTotalnum());
                count = details.getId() == null ? (count += this.create(details)) : (count += this.update(details));
                ++i;
            }
        }
        return count;
    }

    public int updateSimple(Harmfactordeclare record) {
        record.setUpdatetime(new Date());
        int count = this.mapper.updateByPrimaryKeySelective(record);
        return count;
    }

    public List<Harmfactordeclare> getAll(Boolean isFinish, Integer cid, Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        HarmfactordeclareExample e = new HarmfactordeclareExample();
        HarmfactordeclareExample.Criteria c = e.createCriteria();
        c.andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        if (isFinish != null && isFinish.booleanValue()) {
            c.andStatusEqualTo(Constant.STATUS_FINISH);
        }
        if (isFinish != null && !isFinish.booleanValue()) {
            c.andStatusNotEqualTo(Constant.STATUS_FINISH);
        }
        return this.mapper.selectByExample(e);
    }

    public Declaredetails getDetails(Integer id) {
        return this.declaredetailsMapper.selectByPrimaryKey(id);
    }

    public int create(Declaredetails record) {
        return this.declaredetailsMapper.insertSelective(record);
    }

    public int deleteDetails(Integer id) {
        Declaredetails record = new Declaredetails();
        record.setId(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        return this.declaredetailsMapper.updateByPrimaryKeySelective(record);
    }

    public int update(Declaredetails record) {
        return this.declaredetailsMapper.updateByPrimaryKeySelective(record);
    }

    public List<Declaredetails> getDetailsList(Integer id) {
        DeclaredetailsExample e = new DeclaredetailsExample();
        e.createCriteria().andDeclareidEqualTo(id).andIsvalidEqualTo(Constant.ACTIVE_YES);
        return this.declaredetailsMapper.selectByExample(e);
    }

    public Map<String, List<Declaredetails>> getDetailsMap(Integer id) {
        HashMap<String, List<Declaredetails>> map = new HashMap<String, List<Declaredetails>>();
        List<Declaredetails> list = this.getDetailsList(id);
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < list.size()) {
            set.add(list.get(i).getWorkplace());
            ++i;
        }
        for (String str : set) {
            ArrayList<Declaredetails> innerList = new ArrayList<Declaredetails>();
            int i2 = 0;
            while (i2 < list.size()) {
                Declaredetails detail = list.get(i2);
                if (detail.getWorkplace().equals(str)) {
                    innerList.add(detail);
                }
                ++i2;
            }
            map.put(str, innerList);
        }
        return map;
    }

    public List<Harmfactordeclare> comboQuery(QueryStaffParam param, Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        HarmfactordeclareExample e = new HarmfactordeclareExample();
        HarmfactordeclareExample.Criteria c = e.createCriteria();
        c.andCidEqualTo(param.getCid()).andIsvalidEqualTo(Constant.ACTIVE_YES);
        if (param.getIsFinish() != null && param.getIsFinish().booleanValue()) {
            c.andStatusEqualTo(Constant.STATUS_FINISH);
        }
        if (param.getIsFinish() != null && !param.getIsFinish().booleanValue()) {
            c.andStatusNotEqualTo(Constant.STATUS_FINISH);
        }
        if (StringUtils.isNotEmpty((String)param.getName())) {
            c.andWorknameLike("%" + param.getName() + "%");
        }
        if (StringUtils.isNotEmpty((String)param.getWorkStatus())) {
            Integer phase = Integer.valueOf(param.getWorkStatus());
            c.andPhraseEqualTo(phase.byteValue());
        }
        if (param.getDeclareBegin() != null) {
            c.andDeclaretimeGreaterThanOrEqualTo(param.getDeclareBegin());
        }
        if (param.getDeclareEnd() != null) {
            c.andDeclaretimeLessThanOrEqualTo(param.getDeclareEnd());
        }
        if (param.getReplyBegin() != null) {
            c.andReplytimeGreaterThanOrEqualTo(param.getReplyBegin());
        }
        if (param.getReplyEnd() != null) {
            c.andReplytimeLessThanOrEqualTo(param.getReplyEnd());
        }
        if (param.getUpdateBegin() != null) {
            c.andUpdatetimeGreaterThanOrEqualTo(param.getUpdateBegin());
        }
        if (param.getUpdateEnd() != null) {
            c.andUpdatetimeLessThanOrEqualTo(param.getUpdateEnd());
        }
        return this.mapper.selectByExample(e);
    }

    public String getBusinessPath(Integer businessId, Boolean isApprove) {
        Harmfactordeclare record = this.get(businessId);
        switch (record.getPhrase().intValue()) {
            case 1: {
                return "/commons/404";
            }
            case 2: {
                if (isApprove.booleanValue()) {
                    return "forward:/harmfactor/init?approve=1&id=" + businessId;
                }
                return "forward:/harmfactor/init?approve=0&id=" + businessId;
            }
            case 3: {
                return "/commons/404";
            }
            case 4: {
                if (isApprove.booleanValue()) {
                    return "forward:/harmfactor/reply?approve=1&id=" + businessId;
                }
                return "forward:/harmfactor/reply?approve=0&id=" + businessId;
            }
            case 5: {
                if (isApprove.booleanValue()) {
                    return "forward:/harmfactor/finish?approve=1&id=" + businessId;
                }
                return "forward:/harmfactor/finish?approve=0&id=" + businessId;
            }
            case -2: {
                if (isApprove.booleanValue()) {
                    return "forward:/harmfactor/edit?approve=1&id=" + businessId;
                }
                return "forward:/harmfactor/edit?approve=0&id=" + businessId;
            }
        }
        return "/commons/404";
    }

    public String getInformPath(Integer businessId) {
        return "forward:/harmfactor/inform?id=" + businessId;
    }

    @Override
    public void workflow(WorkFlowParam param, Integer orderId) {
        Harmfactordeclare record = this.get(param.getBusinessId());
        record.setWorkflowid(orderId);
        if (!param.getApproved().booleanValue() && !param.isApplyBranch()) {
            record.setStatus(Constant.STATUS_EDIT);
        }
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            switch (record.getPhrase()) {
                case 2: {
                    record.setPhrase((byte)4);
                    record.setStatus(Constant.STATUS_EDIT);
                    break;
                }
                case 4: {
                    record.setPhrase((byte)5);
                    record.setStatus(Constant.STATUS_EDIT);
                    break;
                }
                case 5: {
                    record.setStatus(Constant.STATUS_FINISH);
                    break;
                }
                case -2: {
                    record.setStatus(Constant.STATUS_FINISH);
                    break;
                }
            }
        }
        this.updateSimple(record);
    }

    @Override
    public String doTask(Integer businessId, String taskName) {
        if ("inform".equals(taskName)) {
            return this.getInformPath(businessId);
        }
        if ("read".equals(taskName)) {
            return this.getInformPath(businessId);
        }
        if ("apply".equals(taskName)) {
            return this.getBusinessPath(businessId, false);
        }
        if ("approve".equals(taskName)) {
            return this.getBusinessPath(businessId, true);
        }
        return this.getViewPath(businessId);
    }

    public String getViewPath(Integer businessId) {
        Harmfactordeclare record = this.get(businessId);
        switch (record.getPhrase().intValue()) {
            case 1: {
                return "/commons/404";
            }
            case 2: {
                return "forward:/harmfactor/init?approve=2&id=" + businessId;
            }
            case 3: {
                return "/commons/404";
            }
            case 4: {
                return "forward:/harmfactor/reply?approve=2&id=" + businessId;
            }
            case 5: {
                return "forward:/harmfactor/finish?approve=2&id=" + businessId;
            }
            case -2: {
                return "forward:/harmfactor/edit?approve=2&id=" + businessId;
            }
        }
        return "/commons/404";
    }

    @Override
    public String doApproveTask(Integer businessId) {
        return null;
    }

    @Override
    public int terminateTask(Integer businessId) {
        return 0;
    }

    @Override
    public String addWorkUrl() {
        return "/harmfactor/edit";
    }

    @Override
    public String workflowInform(WorkFlowParam param, Integer orderId) {
        return null;
    }
}

