/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic;

import cn.smarthse.core.dao.sys.SysparamMapper;
import cn.smarthse.core.dao.sys.SysparamtypeMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.sys.Sysparam;
import cn.smarthse.core.model.sys.SysparamExample;
import cn.smarthse.core.model.sys.Sysparamtype;
import cn.smarthse.core.model.sys.SysparamtypeExample;
import com.github.pagehelper.PageHelper;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysParamService {
    @Autowired
    private SysparamMapper mapper;
    @Autowired
    private SysparamtypeMapper sysparamtypeMapper;

    @Cacheable(value={"sys"}, key="'Sysparamtype-key-'+#id")
    public Sysparamtype getParamType(int id) {
        return this.sysparamtypeMapper.selectByPrimaryKey(id);
    }

    @Transactional
    public int createParamType(Sysparamtype record) {
        int count = 0;
        record.setCreatetime(new Date());
        record.setEffecttime(record.getCreatetime());
        record.setIsvalid(Constant.ACTIVE_YES);
        count += this.sysparamtypeMapper.insertSelective(record);
        List<Sysparam> list = record.getParamList();
        int i = 0;
        while (i < list.size()) {
            Sysparam param = list.get(i);
            param.setParamtype(record.getId());
            param.setCreatetime(record.getCreatetime());
            param.setEffecttime(record.getCreatetime());
            param.setIsactive(Constant.ACTIVE_YES);
            count += this.mapper.insertSelective(param);
            ++i;
        }
        return count;
    }

    @CacheEvict(value={"sys"}, key="'Sysparamtype-key-'+#id")
    public int deleteParamType(Integer id) {
        Sysparamtype record = new Sysparamtype();
        record.setId(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        record.setEffecttime(new Date());
        return this.sysparamtypeMapper.updateByPrimaryKeySelective(record);
    }

    @CacheEvict(value={"sys"}, key="'Sysparamtype-key-'+#record.id")
    @Transactional
    public int updateParamType(Sysparamtype record) {
        int count = 0;
        record.setEffecttime(new Date());
        count += this.sysparamtypeMapper.updateByPrimaryKeySelective(record);
        List<Sysparam> list = record.getParamList();
        int i = 0;
        while (i < list.size()) {
            Sysparam param = list.get(i);
            param.setEffecttime(record.getEffecttime());
            if (param.getId() != null) {
                count += this.mapper.updateByPrimaryKeySelective(param);
            } else {
                param.setParamtype(record.getId());
                count += this.mapper.insertSelective(param);
            }
            ++i;
        }
        return count;
    }

    @Cacheable(value={"sys"}, key="'Sysparam-key-'+#id")
    public Sysparam getSysparamById(int id) {
        return this.mapper.selectByPrimaryKey(id);
    }

    public int create(Sysparam record) {
        return this.mapper.insertSelective(record);
    }

    @CacheEvict(value={"sys"}, key="'Sysparam-key-'+#id")
    public int delete(Integer id) {
        Sysparam record = new Sysparam();
        record.setId(id);
        record.setIsactive(Constant.ACTIVE_NO);
        record.setEffecttime(new Date());
        return this.mapper.updateByPrimaryKeySelective(record);
    }

    @CacheEvict(value={"sys"}, key="'Sysparam-key-'+#record.id")
    public int update(Sysparam record) {
        return this.mapper.updateByPrimaryKeySelective(record);
    }

    public List<Sysparam> getAllParam() {
        SysparamExample e = new SysparamExample();
        e.createCriteria().andIsactiveEqualTo(Constant.ACTIVE_YES);
        return this.mapper.selectByExample(e);
    }

    public List<Sysparamtype> getAllParamType() {
        SysparamtypeExample e = new SysparamtypeExample();
        e.createCriteria().andIsvalidEqualTo(Constant.ACTIVE_YES).andPidIsNull();
        return this.sysparamtypeMapper.selectByExample(e);
    }

    public List<Sysparamtype> getParamTypeByPage(Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        return this.getAllParamType();
    }

    public List<Sysparam> getParamByType(int typeid) {
        SysparamExample e = new SysparamExample();
        e.createCriteria().andParamtypeEqualTo(typeid).andIsactiveEqualTo(Constant.ACTIVE_YES);
        return this.mapper.selectByExample(e);
    }

    public Map<String, List<Sysparamtype>> initSysParamType() {
        HashMap<String, List<Sysparamtype>> paramTypeMap = new HashMap<String, List<Sysparamtype>>();
        List<Sysparamtype> typeList = this.getAllParamType();
        int i = 0;
        while (i < typeList.size()) {
            Sysparamtype type = typeList.get(i);
            List<Sysparamtype> list = this.getParamTypeByGroup(type.getTypecode());
            paramTypeMap.put(type.getTypecode(), list);
            ++i;
        }
        return paramTypeMap;
    }

    public void clearinitSysParamTypeCache() {
    }

    @Cacheable(value={"sys"}, key="'SysparamtypeList-init'")
    public Map<String, List<Sysparam>> initSysParam() {
        HashMap<String, List<Sysparam>> paramMap = new HashMap<String, List<Sysparam>>();
        List<Sysparamtype> typeList = this.getAllParamType();
        int i = 0;
        while (i < typeList.size()) {
            Sysparamtype type = typeList.get(i);
            List<Sysparam> list = this.getParamByType(type.getId());
            paramMap.put(type.getTypecode(), list);
            ++i;
        }
        return paramMap;
    }

    @CacheEvict(value={"sys"}, key="'SysparamtypeList-init'")
    public void clearinitSysParamCache() {
    }

    public List<Sysparamtype> getParamTypeByTypeCode(String typecode) {
        if (StringUtils.isEmpty((String)typecode)) {
            return Collections.emptyList();
        }
        SysparamtypeExample e = new SysparamtypeExample();
        e.or().andIsvalidEqualTo(Constant.ACTIVE_YES).andTypecodeEqualTo(typecode);
        List<Sysparamtype> list = this.sysparamtypeMapper.selectByExample(e);
        for (Sysparamtype atype : list) {
            atype.setParamList(this.getParamByType(atype.getId()));
        }
        return list;
    }

    public List<Sysparam> getByParamTypeCode(String typecode) {
        if (StringUtils.isEmpty((String)typecode)) {
            Collections.emptyList();
        }
        return this.mapper.selectByParamTypeCode(typecode);
    }

    public List<Sysparamtype> getParamTypeByGroup(String typecode) {
        if (StringUtils.isEmpty((String)typecode)) {
            return Collections.emptyList();
        }
        SysparamtypeExample e1 = new SysparamtypeExample();
        e1.createCriteria().andIsvalidEqualTo(Constant.ACTIVE_YES).andTypecodeEqualTo(typecode);
        List<Sysparamtype> list1 = this.sysparamtypeMapper.selectByExample(e1);
        if (list1.isEmpty()) {
            return Collections.emptyList();
        }
        Integer groupId = list1.get(0).getTypegroup();
        SysparamtypeExample e = new SysparamtypeExample();
        e.createCriteria().andIsvalidEqualTo(Constant.ACTIVE_YES).andTypegroupEqualTo(groupId);
        List<Sysparamtype> list = this.sysparamtypeMapper.selectByExample(e);
        return list;
    }

    public List<Sysparam> getManagSysCountByCid(Integer cid) {
        if (cid == null || cid == 0) {
            Collections.emptyList();
        }
        return this.mapper.selectManagSysCountByCid(cid);
    }

    public List<Sysparam> selectByQuery(Map<String, Object> query) {
        return this.mapper.selectByQuery(query);
    }
}

