/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic;

import cn.smarthse.core.dao.basic.FileMapper;
import cn.smarthse.core.dao.basic.ProductflowMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.utils.file.UploadFileParameter;
import cn.smarthse.core.framework.utils.file.UploadFilePathEnum;
import cn.smarthse.core.model.basic.File;
import cn.smarthse.core.model.basic.Productflow;
import cn.smarthse.core.model.basic.ProductflowExample;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductFlowService {
    @Autowired
    private ProductflowMapper productFlowMapper;
    @Autowired
    private FileMapper fileMapper;

    public List<Productflow> getAll(Integer cid) {
        ProductflowExample e = new ProductflowExample();
        e.createCriteria().andCidEqualTo(cid);
        return this.productFlowMapper.selectByExample(e);
    }

    public List<Productflow> getAll(Integer cid, Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        return this.getAll(cid);
    }

    public int create(Productflow record) {
        return this.productFlowMapper.insertSelective(record);
    }

    public int update(Productflow record) {
        return this.productFlowMapper.updateByPrimaryKeySelective(record);
    }

    public int delete(Integer id) {
        return this.productFlowMapper.deleteByPrimaryKey(id);
    }

    public Productflow get(int id) {
        return this.productFlowMapper.selectByPrimaryKey(id);
    }

    public int createProductflow(Productflow record) {
        return this.productFlowMapper.insertSelective(record);
    }

    public File createProductflowFile(UploadFileParameter up) {
        File file = new File();
        file.setCreatetime(new Date());
        file.setFilename(up.getOriginalFilename());
        file.setCreator(up.getUserId());
        file.setDescription("\u5de5\u827a\u6d41\u7a0b\u56fe");
        file.setFilesize(String.valueOf(up.getMultipartFile().getSize()));
        file.setFiletype(Constant.FILETYPE_PIC);
        file.setIsvalid((byte)1);
        file.setOssurl(String.valueOf(UploadFilePathEnum.ProductFlow.getPath()) + "/" + up.getFileName());
        this.fileMapper.insertSelective(file);
        return file;
    }
}

