/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic;

import cn.smarthse.core.dao.basic.OrganizationMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.Organization;
import cn.smarthse.core.model.basic.OrganizationExample;
import cn.smarthse.core.model.vo.TreeNodeVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrganizationService {
    @Autowired
    private OrganizationMapper organizationMapper;

    public Organization get(int id) {
        return this.organizationMapper.selectByPrimaryKey(id);
    }

    public int insert(Organization record) {
        return this.organizationMapper.insertSelective(record);
    }

    public int update(Organization record) {
        return this.organizationMapper.updateByPrimaryKeySelective(record);
    }

    public int delete(int id) {
        return this.organizationMapper.deleteByPrimaryKey(id);
    }

    public int deleteAll(Integer cid) {
        OrganizationExample e = new OrganizationExample();
        e.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        Organization record = new Organization();
        record.setIsvalid(Constant.ACTIVE_NO);
        record.setDeletetime(new Date());
        return this.organizationMapper.updateByExampleSelective(record, e);
    }

    public List<Organization> getAll(Integer cid) {
        OrganizationExample e = new OrganizationExample();
        e.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        e.setOrderByClause("pid");
        List<Organization> list = this.organizationMapper.selectByExample(e);
        return list;
    }

    public String generateTree(List<Organization> list) {
        StringBuffer tree = new StringBuffer();
        HashMap map = new HashMap();
        for (Organization a : list) {
            this.haveChild(a.getId(), list).booleanValue();
            if (a.getPid() == 0 && map.get(a) == null) {
                map.put(a, new ArrayList());
            }
            if (a.getPid() <= 0) continue;
            Organization p = this.getOrgFromList(a.getPid(), list);
            List list2 = (List)map.get(p);
        }
        return tree.toString();
    }

    private Organization getOrgFromList(int id, List<Organization> list) {
        for (Organization a : list) {
            if (a.getId() != id) continue;
            return a;
        }
        return null;
    }

    private Boolean haveChild(int id, List<Organization> list) {
        for (Organization a : list) {
            if (a.getPid() != id) continue;
            return true;
        }
        return false;
    }

    public List<TreeNodeVO> getOrganizationTreeWithUsers(Integer cid) {
        if (cid == null || cid == 0) {
            return Collections.emptyList();
        }
        return this.organizationMapper.selectOrganizationTreeWithUsers(cid);
    }

    public List<TreeNodeVO> getOrganizationTreeWithStaff(Integer cid) {
        if (cid == null || cid == 0) {
            return Collections.emptyList();
        }
        return this.organizationMapper.selectOrganizationTreeWithStaff(cid);
    }

    public Organization getByName(Integer cid, String name) {
        OrganizationExample e = new OrganizationExample();
        e.createCriteria().andCidEqualTo(cid).andfullnameEqualTo(name).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<Organization> list = this.organizationMapper.selectByExample(e);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}

