/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic;

import cn.smarthse.core.dao.basic.FunctiondeptMapper;
import cn.smarthse.core.dao.basic.FunctiondeptmemberMapper;
import cn.smarthse.core.dao.basic.UsercertificateMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.Functiondept;
import cn.smarthse.core.model.basic.FunctiondeptExample;
import cn.smarthse.core.model.basic.Functiondeptmember;
import cn.smarthse.core.model.basic.FunctiondeptmemberExample;
import cn.smarthse.core.model.basic.Staff;
import cn.smarthse.core.model.basic.Usercertificate;
import cn.smarthse.core.model.basic.UsercertificateExample;
import cn.smarthse.core.service.basic.staff.StaffService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FunctionalDeptService {
    @Autowired
    private FunctiondeptMapper functiondeptMapper;
    @Autowired
    private FunctiondeptmemberMapper functiondeptmemberMapper;
    @Autowired
    private UsercertificateMapper usercertificateMapper;
    @Autowired
    private StaffService staffService;

    public Functiondept getByType(Integer companyId, Byte type) {
        FunctiondeptExample e = new FunctiondeptExample();
        e.createCriteria().andCidEqualTo(companyId).andDepttypeEqualTo(type).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<Functiondept> list = this.functiondeptMapper.selectByExample(e);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<Functiondept> getList(Integer companyId) {
        FunctiondeptExample e = new FunctiondeptExample();
        e.createCriteria().andCidEqualTo(companyId).andDepttypeGreaterThan((byte)3).andIsvalidEqualTo(Constant.ACTIVE_YES);
        return this.functiondeptMapper.selectByExample(e);
    }

    public Functiondept get(int id) {
        return this.functiondeptMapper.selectByPrimaryKey(id);
    }

    public List<Usercertificate> get1(int id, Byte filetype) {
        UsercertificateExample e = new UsercertificateExample();
        e.createCriteria().andStaffidEqualTo(id).andFiletypeEqualTo(filetype);
        return this.usercertificateMapper.selectByExample(e);
    }

    public int create(Functiondept record) {
        record.setEdittime(new Date());
        return this.functiondeptMapper.insertSelective(record);
    }

    public int delete(Integer id) {
        Functiondept record = this.functiondeptMapper.selectByPrimaryKey(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        record.setEdittime(new Date());
        return this.functiondeptMapper.updateByPrimaryKeySelective(record);
    }

    public int update(Functiondept record) {
        return this.functiondeptMapper.updateByPrimaryKeySelective(record);
    }

    public List<Functiondeptmember> getDeptMembers(Integer id) {
        FunctiondeptmemberExample e = new FunctiondeptmemberExample();
        e.createCriteria().andDeptidEqualTo(id).andIsvalidEqualTo(Constant.ACTIVE_YES);
        return this.functiondeptmemberMapper.selectByExample(e);
    }

    public Functiondeptmember getMember(Integer id) {
        return this.functiondeptmemberMapper.selectByPrimaryKey(id);
    }

    public int createMember(Integer pid, List<Integer> staffIdList) {
        int count = 0;
        Functiondeptmember manager = this.functiondeptmemberMapper.selectByPrimaryKey(pid);
        int i = 0;
        while (i < staffIdList.size()) {
            Integer id = staffIdList.get(i);
            Staff staff = this.staffService.get(id);
            Functiondeptmember record = new Functiondeptmember();
            record.setName(staff.getBasic().getRealname());
            record.setPid(pid);
            record.setStaffid(id);
            record.setDeptid(manager.getDeptid());
            record.setIsvalid(Constant.ACTIVE_YES);
            count += this.functiondeptmemberMapper.insertSelective(record);
            ++i;
        }
        return count;
    }

    @Transactional
    public int editOrg(Functiondeptmember m, Integer file1, Integer id1, Integer file2, Integer id2) {
        if (m.getId() == null) {
            return this.functiondeptmemberMapper.insertSelective(m);
        }
        if (file1 == null && file2 == null) {
            return this.functiondeptmemberMapper.updateByPrimaryKeySelective(m);
        }
        Functiondeptmember member = this.functiondeptmemberMapper.selectByPrimaryKey(m.getId());
        Usercertificate cer1 = null;
        Usercertificate cer2 = null;
        if (file1 != null) {
            if (id1 != null) {
                cer1 = this.usercertificateMapper.selectByPrimaryKey(id1);
                cer1.setStaffid(member.getStaffid());
                cer1.setOssid(Integer.toString(file1));
                cer1.setFiletype(Constant.certificate_funcdept);
                this.usercertificateMapper.updateByPrimaryKey(cer1);
            } else {
                cer1 = new Usercertificate();
                cer1.setStaffid(member.getStaffid());
                cer1.setOssid(Integer.toString(file1));
                cer1.setFiletype(Constant.certificate_funcdept);
                this.usercertificateMapper.insertSelective(cer1);
            }
        }
        if (file2 != null) {
            if (id2 != null) {
                cer2 = this.usercertificateMapper.selectByPrimaryKey(id2);
                cer2.setStaffid(member.getStaffid());
                cer2.setOssid(Integer.toString(file2));
                cer2.setFiletype(Constant.certificate_train);
                this.usercertificateMapper.updateByPrimaryKey(cer2);
            } else {
                cer2 = new Usercertificate();
                cer2.setStaffid(member.getStaffid());
                cer2.setOssid(Integer.toString(file2));
                cer2.setFiletype(Constant.certificate_train);
                this.usercertificateMapper.insertSelective(cer2);
            }
        }
        return this.functiondeptmemberMapper.updateByPrimaryKeySelective(m);
    }

    public int updateMember(Functiondeptmember record) {
        return this.functiondeptmemberMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteMember(Integer id) {
        Functiondeptmember record = this.functiondeptmemberMapper.selectByPrimaryKey(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        return this.functiondeptmemberMapper.updateByPrimaryKeySelective(record);
    }
}

