/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic;

import cn.smarthse.core.annotation.SYSLOG;
import cn.smarthse.core.dao.basic.CompanyparamMapper;
import cn.smarthse.core.dao.basic.CompanyparamtypeMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.Companyparam;
import cn.smarthse.core.model.basic.CompanyparamExample;
import cn.smarthse.core.model.basic.Companyparamtype;
import cn.smarthse.core.model.basic.CompanyparamtypeExample;
import com.github.pagehelper.PageHelper;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@SYSLOG(desc="\u4f01\u4e1a\u81ea\u5b9a\u4e49\u53c2\u6570")
@Service
public class CompanyparamService {
    @Autowired
    private CompanyparamMapper companyparamMapper;
    @Autowired
    private CompanyparamtypeMapper CompanyparamtypeMapper;
    @Autowired
    CompanyparamtypeMapper companyparamtypeMapper;

    public List<Companyparamtype> getCompanyParamType(Integer cid) {
        CompanyparamtypeExample e = new CompanyparamtypeExample();
        e.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES).andPidIsNull();
        return this.CompanyparamtypeMapper.selectByExample(e);
    }

    public List<Companyparamtype> getCompanyParamTypeByPage(Integer cid, Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        return this.getCompanyParamType(cid);
    }

    public void editParam(Companyparam record) {
        if (record.getId() == null) {
            this.companyparamMapper.insertSelective(record);
        } else {
            this.companyparamMapper.updateByPrimaryKeySelective(record);
        }
    }

    @Transactional
    public void editParamType(Companyparamtype record) {
        record.setCreatetime(new Date());
        if (record.getId() == null) {
            record.setIsvalid(Constant.ACTIVE_YES);
            this.CompanyparamtypeMapper.insertSelective(record);
        } else {
            this.CompanyparamtypeMapper.updateByPrimaryKeySelective(record);
        }
        List<Companyparam> list = record.getParamList();
        if (list != null && list.size() > 0) {
            for (Companyparam param : list) {
                param.setCid(record.getCid());
                param.setParamtype(record.getId());
                param.setCreatetime(new Date());
                param.setEffecttime(new Date());
                param.setIsactive(Constant.ACTIVE_YES);
                this.editParam(param);
            }
        }
    }

    @CacheEvict(value={"default"}, key="'Companyparamlist-byC-' + #record.cid + '-PT'  + #record.paramType")
    public Companyparam addCompanyparam(Companyparam record) {
        this.companyparamMapper.insertSelective(record);
        return record;
    }

    public Companyparam getCompanyparamById(int id) {
        return this.companyparamMapper.selectByPrimaryKey(id);
    }

    @CacheEvict(value={"default"}, key="'Companyparamlist-byC-' + #record.cid + '-PT'  + #record.paramType")
    public int updateCompanyparam(Companyparam record) {
        return this.companyparamMapper.updateByPrimaryKeySelective(record);
    }

    @CacheEvict(value={"default"}, key="'Companyparamlist-byC-' + #record.cid + '-PT'  + #record.paramType")
    public int deleteCompanyparam(Companyparam record) {
        return this.companyparamMapper.deleteByPrimaryKey(record.getId());
    }

    public List<Companyparam> getCompanyparamListByExample(CompanyparamExample example) {
        return this.companyparamMapper.selectByExample(example);
    }

    @Cacheable(value={"default"}, key="'Companyparamlist-byC-' + #cid + '-PT'  + #paramType")
    public List<Companyparam> getCompanyparamListByparamType(int paramType, int cid) {
        if (cid == 0) {
            return Collections.emptyList();
        }
        return this.companyparamMapper.selectCompanyparamListByparamType(paramType, cid);
    }

    @CacheEvict(value={"default"}, key="'Companyparamlist-byC-' + #cid + '-PT'  + #paramType")
    public void clearCompanyparamListByparamTypeCache(int paramType, int cid) {
    }

    public Companyparamtype addCompanyparamtype(Companyparamtype record) {
        this.companyparamtypeMapper.insertSelective(record);
        return record;
    }

    public Companyparamtype getCompanyparamtypeById(int id) {
        return this.companyparamtypeMapper.selectByPrimaryKey(id);
    }

    public int updateCompanyparamtype(Companyparamtype record) {
        return this.companyparamtypeMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteCompanyparamtype(Companyparamtype record) {
        return this.companyparamtypeMapper.deleteByPrimaryKey(record.getId());
    }

    public List<Companyparamtype> getCompanyparamtypeListByExample(CompanyparamtypeExample example) {
        return this.companyparamtypeMapper.selectByExample(example);
    }
}

