/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic;

import cn.smarthse.core.dao.basic.CertificateMapper;
import cn.smarthse.core.dao.basic.CompanyMapper;
import cn.smarthse.core.dao.basic.FileMapper;
import cn.smarthse.core.dao.basic.UserMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.Certificate;
import cn.smarthse.core.model.basic.CertificateExample;
import cn.smarthse.core.model.basic.Company;
import cn.smarthse.core.model.basic.File;
import cn.smarthse.core.model.basic.FileExample;
import cn.smarthse.core.model.basic.Staff;
import cn.smarthse.core.model.basic.User;
import cn.smarthse.core.model.security.SecUserrole;
import cn.smarthse.core.service.basic.BuildingService;
import cn.smarthse.core.service.basic.OrganizationService;
import cn.smarthse.core.service.basic.staff.StaffService;
import cn.smarthse.core.service.basic.staff.WorkRoleInfoService;
import cn.smarthse.core.service.device.DeviceService;
import cn.smarthse.core.service.matter.MatterService;
import cn.smarthse.core.service.security.RoleManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class CompanyService {
    @Autowired
    BuildingService buildService;
    @Autowired
    DeviceService deviceService;
    @Autowired
    MatterService matterService;
    @Autowired
    private OrganizationService OrganizationService;
    @Autowired
    private WorkRoleInfoService WorkRoleInfoService;
    @Autowired
    private StaffService StaffService;
    @Autowired
    private BuildingService BuildingService;
    @Autowired
    private CompanyMapper mapper;
    @Autowired
    private FileMapper fileMapper;
    @Autowired
    private CertificateMapper certificateMapper;
    @Autowired
    UserMapper userMapper;
    @Autowired
    RoleManager roleManager;

    public Certificate getCertificate(int id) {
        return this.certificateMapper.selectByPrimaryKey(id);
    }

    public Map<String, Object> getCompanyCertificate(int id) {
        CertificateExample e = new CertificateExample();
        e.createCriteria().andCidEqualTo(id);
        List<Certificate> list = this.certificateMapper.selectByExample(e);
        ArrayList<Integer> fileIdList = new ArrayList<Integer>();
        int i = 0;
        while (i < list.size()) {
            fileIdList.add(list.get(i).getFileid());
            ++i;
        }
        List<File> fileList = null;
        if (fileIdList.size() > 0) {
            FileExample e1 = new FileExample();
            e1.or().andIdIn(fileIdList);
            fileList = this.fileMapper.selectByExample(e1);
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("list", list);
        m.put("fileList", fileList);
        return m;
    }

    public int createCertificate(Certificate record) {
        return this.certificateMapper.insertSelective(record);
    }

    public int deleteCertificate(Integer id) {
        return this.certificateMapper.deleteByPrimaryKey(id);
    }

    public int updateCertificate(Certificate record) {
        return this.certificateMapper.updateByPrimaryKeySelective(record);
    }

    public Company getCompanyByID(int id) {
        return this.mapper.selectByIDWithEntity(id);
    }

    public int createCompany(Company record) {
        return this.mapper.insertSelective(record);
    }

    public int deleteCompany(Integer id) {
        return this.mapper.deleteByPrimaryKey(id);
    }

    public int updateCompany(Company record) {
        return this.mapper.updateByPrimaryKeySelective(record);
    }

    @Transactional
    public int executeCompanyAuth(Company record, int userId) {
        int count = 0;
        count += this.mapper.insertSelective(record);
        User user = this.userMapper.selectByPrimaryKey(userId);
        Staff cp = new Staff();
        cp.setCid(record.getId());
        cp.setUid(user.getId());
        cp.setUserbasicid(user.getUserbaseid());
        count += this.StaffService.create(cp);
        SecUserrole userrole = new SecUserrole();
        userrole.setCreatetime(new Date());
        userrole.setIsactive(Constant.ACTIVE_YES);
        userrole.setRid(52);
        userrole.setUid(user.getId());
        userrole.setUpdatetime(userrole.getCreatetime());
        this.roleManager.addSecUserRole(userrole);
        ++count;
        if (user.getUserbaseid() == null) {
            user.setUserbaseid(cp.getUserbasicid());
        }
        user.setCid(record.getId());
        this.userMapper.updateByPrimaryKey(user);
        return count;
    }

    @Transactional
    public void restartInit(Integer cid, Integer exceptionalStaffId) {
        this.OrganizationService.deleteAll(cid);
        this.WorkRoleInfoService.deleteAll(cid);
        this.StaffService.deleteAll(cid, exceptionalStaffId);
        this.buildService.deleteBycid(cid);
        this.deviceService.deleteBycid(cid);
        this.matterService.deleteBycid(cid);
    }

    public boolean isInitiated(Integer cid) {
        List<Staff> staffList = this.StaffService.getAll(cid);
        return staffList.size() > 1;
    }
}

