/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic;

import cn.smarthse.core.dao.basic.AreaMapper;
import cn.smarthse.core.dao.basic.BuildingMapper;
import cn.smarthse.core.dao.basic.BuildingassistroomMapper;
import cn.smarthse.core.dao.basic.BuildingfacilityMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.Area;
import cn.smarthse.core.model.basic.AreaExample;
import cn.smarthse.core.model.basic.Building;
import cn.smarthse.core.model.basic.BuildingExample;
import cn.smarthse.core.model.basic.BuildingInit;
import cn.smarthse.core.model.basic.Buildingassistroom;
import cn.smarthse.core.model.basic.Buildingfacility;
import cn.smarthse.core.model.common.ResponseData;
import cn.smarthse.core.service.basic.AreaService;
import com.github.pagehelper.PageHelper;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BuildingService {
    @Autowired
    private AreaService AreaService;
    @Autowired
    private BuildingMapper buildingMapper;
    @Autowired
    private BuildingassistroomMapper buildingassistroomMapper;
    @Autowired
    private BuildingfacilityMapper buildingfacilityMapper;
    @Autowired
    private AreaMapper areaMapper;

    public Building get(int id) {
        return this.buildingMapper.selectByPrimaryKey(id);
    }

    public int create(Building record) {
        record.setIsvalid(Constant.ACTIVE_YES);
        record.setUpdatetime(new Date());
        this.buildingMapper.insertSelective(record);
        return record.getId();
    }

    public int delete(Integer id) {
        Building a = new Building();
        a.setId(id);
        a.setIsvalid(Constant.ACTIVE_NO);
        return this.buildingMapper.updateByPrimaryKeySelective(a);
    }

    public int update(Building record) {
        record.setUpdatetime(new Date());
        return this.buildingMapper.updateByPrimaryKeySelective(record);
    }

    public Buildingassistroom getAssistroom(int id) {
        return this.buildingassistroomMapper.selectByPrimaryKey(id);
    }

    public int createAssistroom(Buildingassistroom record) {
        return this.buildingassistroomMapper.insertSelective(record);
    }

    public int deleteAssistroom(Integer id) {
        Buildingassistroom a = new Buildingassistroom();
        a.setId(id);
        a.setIsvalid(Constant.ACTIVE_NO);
        return this.buildingassistroomMapper.updateByPrimaryKeySelective(a);
    }

    public int updateAssistroom(Buildingassistroom record) {
        return this.buildingassistroomMapper.updateByPrimaryKeySelective(record);
    }

    public List<Building> getAll(int companyId) {
        List<Area> areaList = this.AreaService.getAllArea(companyId);
        ArrayList<Integer> areaIdList = new ArrayList<Integer>();
        int i = 0;
        while (i < areaList.size()) {
            areaIdList.add(areaList.get(i).getId());
            ++i;
        }
        if (areaIdList.size() == 0) {
            return null;
        }
        BuildingExample e = new BuildingExample();
        e.createCriteria().andAreaidIn(areaIdList).andIsvalidEqualTo(Constant.ACTIVE_YES);
        return this.buildingMapper.selectByExample(e);
    }

    public int deleteBatch(List<Integer> list) {
        BuildingExample e = new BuildingExample();
        e.createCriteria().andIdIn((List)list);
        Building record = new Building();
        record.setIsvalid(Constant.ACTIVE_NO);
        return this.buildingMapper.updateByExampleSelective(record, e);
    }

    public List<Building> query(Building build, Integer cid, Integer pageNumber, Integer pageSize) {
        Integer buildType;
        Integer areaId;
        List<Area> areaList = this.AreaService.getAllArea(cid);
        ArrayList<Integer> areaIdList = new ArrayList<Integer>();
        int i = 0;
        while (i < areaList.size()) {
            areaIdList.add(areaList.get(i).getId());
            ++i;
        }
        if (areaIdList.size() == 0) {
            return null;
        }
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        BuildingExample e = new BuildingExample();
        BuildingExample.Criteria c = e.createCriteria();
        c.andAreaidIn(areaIdList).andIsvalidEqualTo(Constant.ACTIVE_YES);
        String name = build.getName();
        if (StringUtils.isNotEmpty((String)name)) {
            c.andNameLike("%" + name + "%");
        }
        if ((areaId = build.getAreaid()) != null) {
            c.andAreaidEqualTo(areaId);
        }
        if ((buildType = build.getBuildingtype()) != null) {
            c.andBuildingtypeEqualTo(buildType);
        }
        return this.buildingMapper.selectByExample(e);
    }

    @Transactional
    public int create(Buildingassistroom record) {
        int count = 0;
        record.setIsvalid(Constant.ACTIVE_YES);
        count += this.buildingassistroomMapper.insertSelective(record);
        List<Buildingfacility> facilityList = record.getFacilityList();
        if (facilityList == null) {
            return count;
        }
        for (Buildingfacility fa : facilityList) {
            fa.setRoomid(record.getId());
            fa.setIsvalid(Constant.ACTIVE_YES);
            fa.setEffecttime(new Date());
            this.buildingfacilityMapper.insertSelective(fa);
        }
        return count;
    }

    public int update(Buildingassistroom record) {
        return this.buildingassistroomMapper.updateByPrimaryKeySelective(record);
    }

    @Transactional
    public int createAssistRoom(Buildingassistroom record) {
        int count = 0;
        count += this.buildingassistroomMapper.insertSelective(record);
        List<Buildingfacility> list = record.getFacilityList();
        int i = 0;
        while (i < list.size()) {
            Buildingfacility facility = list.get(i);
            facility.setRoomid(record.getId());
            count += this.buildingfacilityMapper.insertSelective(facility);
            ++i;
        }
        return count;
    }

    public ResponseData<BuildingInit> getBuildingInitInfoFromExcel(String fileName, Map<String, Object> paramMap) throws Exception {
        ResponseData<BuildingInit> data = new ResponseData<BuildingInit>();
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)new FileInputStream(fileName));
        HSSFSheet sheet = wb.getSheetAt(0);
        BuildingInit init = new BuildingInit();
        Map<String, String> areaMap = init.getAreaMap();
        boolean areaId = true;
        boolean buidingId = true;
        int rowIndex = 0;
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1 || row.getCell(1) == null || row.getCell(1).getCellType() == 3) continue;
            Building building = new Building();
            Area area = new Area();
            int cellCount = 9;
            int colIndex = 0;
            int i = 0;
            while (i < cellCount) {
                Cell cell = row.getCell(i);
                ++colIndex;
                if (cell != null && cell.getCellType() != 3) {
                    switch (i) {
                        case 0: {
                            building.setName(cell.getStringCellValue().trim());
                            break;
                        }
                        case 1: {
                            String sarea = cell.getStringCellValue().trim();
                            building.setAreaName(sarea);
                            area.setAreaname(sarea);
                            if (areaMap.get(sarea) != null) break;
                            areaMap.put(sarea, sarea);
                            break;
                        }
                        case 2: {
                            try {
                                building.setLayercount((int)cell.getNumericCellValue());
                                break;
                            }
                            catch (Exception e) {
                                data.setCode(-1);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5de5\u53f7\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                        }
                        case 3: {
                            String buildtype = cell.getStringCellValue().trim();
                            List objList = (List)paramMap.get("building_type");
                            int j = 0;
                            while (j < objList.size()) {
                                String s = objList.get(j).toString();
                                String idS = s.substring(s.indexOf("id=") + 3, s.indexOf(","));
                                Integer id = new Integer(idS);
                                int m = s.indexOf("paramvalue=");
                                String buildName = (s = s.substring(m)).substring(s.indexOf("paramvalue") + 11, s.indexOf(","));
                                if (buildtype.equals(buildName)) {
                                    building.setBuildingtype(id);
                                }
                                ++j;
                            }
                            break;
                        }
                        case 4: {
                            String fangxiang = cell.getStringCellValue().trim();
                            List objList = (List)paramMap.get("building_long_direction");
                            int j = 0;
                            while (j < objList.size()) {
                                String s = objList.get(j).toString();
                                String idS = s.substring(s.indexOf("id=") + 3, s.indexOf(","));
                                Integer id = new Integer(idS);
                                int m = s.indexOf("paramvalue=");
                                String direName = (s = s.substring(m)).substring(s.indexOf("paramvalue") + 11, s.indexOf(","));
                                if (fangxiang.equals(direName)) {
                                    building.setDirection(id);
                                }
                                ++j;
                            }
                            break;
                        }
                        case 5: {
                            float acreage = (float)cell.getNumericCellValue();
                            building.setAcreage(Float.valueOf(acreage));
                            break;
                        }
                        case 6: {
                            float length = (float)cell.getNumericCellValue();
                            building.setLength(Float.valueOf(length));
                            break;
                        }
                        case 7: {
                            float width = (float)cell.getNumericCellValue();
                            building.setWidth(Float.valueOf(width));
                            break;
                        }
                        case 8: {
                            float height = (float)cell.getNumericCellValue();
                            building.setHeight(Float.valueOf(height));
                        }
                    }
                }
                ++i;
            }
            init.getAreaList().add(area);
            init.getBuildingList().add(building);
        }
        wb.close();
        data.setResult(init);
        return data;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf(String.valueOf((char)(65 + a - 1))) + String.valueOf((char)(65 + b - 1));
    }

    @Transactional
    public ResponseData<String> initImport(BuildingInit init) {
        int cid = init.getCompanyId();
        ResponseData<String> data = new ResponseData<String>();
        Map<String, String> areaMap = init.getAreaMap();
        List<Area> areaList = init.getAreaList();
        List<Building> buidlingList = init.getBuildingList();
        for (Map.Entry<String, String> entry : areaMap.entrySet()) {
            Area r = new Area();
            r.setPid(null);
            r.setAreaname(entry.getKey());
            r.setCreatetime(new Date());
            r.setIsvalid(Constant.ACTIVE_YES);
            r.setCid(cid);
            this.areaMapper.insert(r);
            int j = 0;
            while (j < buidlingList.size()) {
                Building b = buidlingList.get(j);
                b.setAreaid(r.getId());
                b.setIsvalid(Constant.ACTIVE_YES);
                if (b.getAreaName() == entry.getKey()) {
                    this.buildingMapper.insertSelective(b);
                }
                ++j;
            }
        }
        return data;
    }

    public void deleteBycid(Integer cid) {
        AreaExample example = new AreaExample();
        example.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<Area> list = this.areaMapper.selectByExample(example);
        for (Area area : list) {
            BuildingExample e = new BuildingExample();
            e.createCriteria().andAreaidEqualTo(area.getId()).andIsvalidEqualTo(Constant.ACTIVE_YES);
            List<Building> buildings = this.buildingMapper.selectByExample(e);
            for (Building b : buildings) {
                b.setIsvalid(Constant.ACTIVE_NO);
                this.buildingMapper.updateByPrimaryKeySelective(b);
            }
            area.setIsvalid(Constant.ACTIVE_NO);
            this.areaMapper.updateByPrimaryKeySelective(area);
        }
    }
}

