/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.basic;

import cn.smarthse.core.dao.basic.AreaMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.Area;
import cn.smarthse.core.model.basic.AreaExample;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AreaService {
    @Autowired
    private AreaMapper areaMapper;

    public Area getArea(int id) {
        return this.areaMapper.selectByPrimaryKey(id);
    }

    public int createArea(Area record) {
        record.setCreatetime(new Date());
        record.setIsvalid(Constant.ACTIVE_YES);
        Integer level = null;
        Area parent = this.areaMapper.selectByPrimaryKey(record.getPid());
        level = parent == null ? Integer.valueOf(1) : Integer.valueOf(parent.getLevel() + 1);
        record.setLevel(level);
        return this.areaMapper.insertSelective(record);
    }

    public int deleteArea(Integer id) {
        Area area = new Area();
        area.setId(id);
        area.setIsvalid(Constant.ACTIVE_NO);
        return this.areaMapper.updateByPrimaryKeySelective(area);
    }

    public int updateArea(Area record) {
        return this.areaMapper.updateByPrimaryKeySelective(record);
    }

    public List<Area> queryAreaWorkRole(Integer cid, String name) {
        AreaExample e = new AreaExample();
        AreaExample.Criteria c = e.createCriteria();
        c.andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        if (StringUtils.isNotEmpty((String)name)) {
            c.andAreanameLike("%" + name + "%");
        }
        return this.areaMapper.selectByExampleWithWorkRole(e);
    }

    public List<Area> queryAreaWorkRole(Integer cid, String name, Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        return this.queryAreaWorkRole(cid, name);
    }

    public List<Area> getChildArea(Integer areaId) {
        AreaExample e = new AreaExample();
        e.or().andPidEqualTo(areaId);
        List<Area> list = this.areaMapper.selectByExample(e);
        return list;
    }

    public List<Area> queryArea(Integer cid, String name, Integer level) {
        AreaExample e = new AreaExample();
        AreaExample.Criteria c = e.createCriteria();
        c.andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        if (level != null) {
            c.andLevelEqualTo(level);
        }
        if (StringUtils.isNotEmpty((String)name)) {
            c.andAreanameLike("%" + name + "%");
        }
        return this.areaMapper.selectByExample(e);
    }

    public List<Area> getAllArea(Integer cid) {
        return this.queryArea(cid, null, null);
    }

    public List<Area> getChildArea(Integer cid, Integer id) {
        List<Area> list = this.queryArea(cid, null, null);
        ArrayList<Area> result = new ArrayList<Area>();
        int i = 0;
        while (i < list.size()) {
            Area a = list.get(i);
            if (a.getId().equals(id)) {
                result.add(a);
            }
            if (a.getPid() != null && a.getPid().equals(id)) {
                result.addAll(this.getChildArea(cid, a.getId()));
            }
            ++i;
        }
        return result;
    }
}

