/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service;

import cn.smarthse.core.dao.basic.UserMapper;
import cn.smarthse.core.dao.basic.UserbasicinfoMapper;
import cn.smarthse.core.framework.utils.Digests;
import cn.smarthse.core.framework.utils.EncodeUtils;
import cn.smarthse.core.model.basic.User;
import cn.smarthse.core.model.basic.UserExample;
import cn.smarthse.core.model.basic.Userbasicinfo;
import cn.smarthse.core.model.basic.UserbasicinfoExample;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserService {
    @Autowired
    UserMapper userMapper;
    @Autowired
    UserbasicinfoMapper userBasicInfoMapper;

    public User addUser(User record) {
        this.userMapper.insertSelective(record);
        return record;
    }

    public User getUserById(int id) {
        UserExample example = new UserExample();
        example.createCriteria().andIdEqualTo(id);
        List<User> list = this.userMapper.selectByExampleWithEntity(example);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Transactional
    public int updateUser(User record) {
        if (record.getUserbaseid() != null && record.getUserbaseid() > 0 && record.getBasicinfo() != null) {
            Userbasicinfo savebasicInfo = this.getUserBasicInfoById(record.getUserbaseid());
            savebasicInfo.setRealname(record.getBasicinfo().getRealname());
            savebasicInfo.setGender(record.getBasicinfo().getGender());
            savebasicInfo.setBirthday(record.getBasicinfo().getBirthday());
            savebasicInfo.setAreaid(record.getBasicinfo().getAreaid());
            this.updateUserBasicInfo(savebasicInfo);
            record.setFullname(record.getBasicinfo().getRealname());
            record.setGender(record.getBasicinfo().getGender());
            record.setNickname(record.getBasicinfo().getRealname());
        } else if ((record.getUserbaseid() == null || record.getUserbaseid() == 0) && record.getBasicinfo() != null) {
            this.userBasicInfoMapper.insertSelective(record.getBasicinfo());
            record.setUserbaseid(record.getBasicinfo().getId());
            record.setFullname(record.getBasicinfo().getRealname());
            record.setGender(record.getBasicinfo().getGender());
            record.setNickname(record.getBasicinfo().getRealname());
        }
        return this.userMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteUser(User record) {
        return this.userMapper.deleteByPrimaryKey(record.getId());
    }

    public List<User> getUserListByExample(UserExample example) {
        return this.userMapper.selectByExample(example);
    }

    @Transactional
    public void entryptPassword(User user) {
        byte[] salt = Digests.generateSalt(8);
        user.setSalt(EncodeUtils.hexEncode(salt));
        byte[] hashPassword = Digests.sha1(user.getPlainpassword().getBytes(), salt, 1024);
        user.setPassword(EncodeUtils.hexEncode(hashPassword));
    }

    public Userbasicinfo addUserBasicInfo(Userbasicinfo record) {
        this.userBasicInfoMapper.insertSelective(record);
        return record;
    }

    public Userbasicinfo getUserBasicInfoById(int id) {
        return this.userBasicInfoMapper.selectByPrimaryKey(id);
    }

    public int updateUserBasicInfo(Userbasicinfo record) {
        return this.userBasicInfoMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteUserBasicInfoByID(int id) {
        return this.userBasicInfoMapper.deleteByPrimaryKey(id);
    }

    public List<Userbasicinfo> getUserBasicInfoListByExample(UserbasicinfoExample example) {
        return this.userBasicInfoMapper.selectByExample(example);
    }
}

