/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service;

import cn.smarthse.core.dao.sys.SysPushmessageMapper;
import cn.smarthse.core.dao.sys.SysPushmessageResultMapper;
import cn.smarthse.core.dao.sys.SysUsermessagesMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.enums.Modulars;
import cn.smarthse.core.model.sys.SysPushmessage;
import cn.smarthse.core.model.sys.SysPushmessageExample;
import cn.smarthse.core.model.sys.SysPushmessageResult;
import cn.smarthse.core.model.sys.SysPushmessageResultExample;
import cn.smarthse.core.model.sys.SysUsermessages;
import cn.smarthse.core.model.sys.SysUsermessagesExample;
import cn.smarthse.core.model.vo.WorkFlowParam;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class SysPushmessageService {
    @Autowired
    Scheduler scheduler;
    @Autowired
    SysPushmessageMapper sysPushmessageMapper;
    @Autowired
    SysPushmessageResultMapper sysPushmessageResultMapper;
    @Autowired
    SysUsermessagesMapper sysUsermessagesMapper;

    @Transactional
    public int executeAddPushmessage(int cid, WorkFlowParam wfparam) {
        Modulars m = Modulars.getModularsByCode(wfparam.getBusinessType());
        int count = 0;
        if (!StringUtils.isEmpty((String)wfparam.getMessageTitle())) {
            String approver = wfparam.getApprover();
            String applyer = wfparam.getApplyer();
            Integer senderId = 0;
            if (!StringUtils.isEmpty((String)applyer)) {
                senderId = Integer.valueOf(applyer);
            }
            SysPushmessage pushmessage = new SysPushmessage();
            pushmessage.setCid(cid);
            pushmessage.setIsactive(Constant.ACTIVE_YES);
            pushmessage.setMessagetype(2);
            pushmessage.setProcessname(m != null ? m.getName() : "\u672a\u77e5");
            if (StringUtils.isEmpty((String)wfparam.getProcessurl())) {
                pushmessage.setProcessurl(String.format("/flow/doTaskstarted?orderId=%s&_wfid=%s", wfparam.getOrderId(), wfparam.getWfid()));
            } else {
                pushmessage.setProcessurl(wfparam.getProcessurl());
            }
            pushmessage.setSenderdatetime(new Date());
            pushmessage.setSenderuserid(senderId);
            pushmessage.setMessageno(wfparam.getMessageno());
            pushmessage.setTitle(wfparam.getMessageTitle());
            pushmessage.setTostaffids(approver);
            if (StringUtils.isNotEmpty((String)wfparam.getNextApprover())) {
                pushmessage.setSenderuserid(Integer.valueOf(approver));
                pushmessage.setTostaffids(wfparam.getNextApprover());
            }
            count += this.addSysPushmessage(pushmessage);
            String ccOperator = wfparam.getCcOperator();
            if (StringUtils.isNotEmpty((String)ccOperator) && ccOperator.split(",").length > 0) {
                SysPushmessage cc_message = new SysPushmessage();
                cc_message.setCid(cid);
                cc_message.setIsactive(Constant.ACTIVE_YES);
                cc_message.setMessagetype(2);
                cc_message.setProcessname(m != null ? m.getName() : "\u672a\u77e5");
                if (StringUtils.isEmpty((String)wfparam.getProcessurl())) {
                    cc_message.setProcessurl(String.format("/flow/doTaskstarted?orderId=%s&_wfid=%s", wfparam.getOrderId(), wfparam.getWfid()));
                } else {
                    cc_message.setProcessurl(wfparam.getProcessurl());
                }
                cc_message.setSenderdatetime(new Date());
                cc_message.setSenderuserid(senderId);
                cc_message.setMessageno(wfparam.getMessageno());
                cc_message.setTitle("\u6284\u9001\uff1a" + wfparam.getBusinessName());
                cc_message.setTostaffids(ccOperator);
                count += this.addSysPushmessage(cc_message);
            }
        }
        return count;
    }

    public int addSysPushmessage(SysPushmessage record) {
        int count = 0;
        count += this.sysPushmessageMapper.insertSelective(record);
        if (!StringUtils.isEmpty((String)record.getPushchannels())) {
            String[] list = record.getPushchannels().split("");
            if (list.length == 6) {
                if ("1".equals(list[1])) {
                    this.bathAddSysUsermessages(record);
                }
                if ("1".equals(list[2])) {
                    this.addSysPushmessageResult((byte)2, record.getId());
                }
                if ("1".equals(list[3])) {
                    this.addSysPushmessageResult((byte)3, record.getId());
                }
                if ("1".equals(list[4])) {
                    this.addSysPushmessageResult((byte)4, record.getId());
                }
                if ("1".equals(list[5])) {
                    this.addSysPushmessageResult((byte)5, record.getId());
                }
            }
        } else {
            count += this.bathAddSysUsermessages(record);
        }
        return count;
    }

    public SysPushmessage getSysPushmessageById(int id) {
        return this.sysPushmessageMapper.selectByPrimaryKey(id);
    }

    public int updateSysPushmessage(SysPushmessage record) {
        return this.sysPushmessageMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteSysPushmessageByID(int id) {
        return this.sysPushmessageMapper.deleteByPrimaryKey(id);
    }

    public List<SysPushmessage> getSysPushmessageListByExample(SysPushmessageExample example) {
        return this.sysPushmessageMapper.selectByExample(example);
    }

    public SysPushmessageResult addSysPushmessageResult(SysPushmessageResult record) {
        this.sysPushmessageResultMapper.insertSelective(record);
        return record;
    }

    public SysPushmessageResult addSysPushmessageResult(Byte channeltype, Integer messageid) {
        SysPushmessageResult record = new SysPushmessageResult();
        record.setChanneltype(channeltype);
        record.setMessageid(messageid);
        record.setProcessstate(Constant.ACTIVE_NO);
        record.setProcesscount(0);
        this.sysPushmessageResultMapper.insertSelective(record);
        return record;
    }

    public SysPushmessageResult getSysPushmessageResultById(int id) {
        return this.sysPushmessageResultMapper.selectByPrimaryKey(id);
    }

    public int updateSysPushmessageResult(SysPushmessageResult record) {
        return this.sysPushmessageResultMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteSysPushmessageResultByID(int id) {
        return this.sysPushmessageResultMapper.deleteByPrimaryKey(id);
    }

    public List<SysPushmessageResult> getSysPushmessageResultListByExample(SysPushmessageResultExample example) {
        return this.sysPushmessageResultMapper.selectByExample(example);
    }

    public SysUsermessages addSysUsermessages(SysUsermessages record) {
        this.sysUsermessagesMapper.insertSelective(record);
        return record;
    }

    public int bathAddSysUsermessages(SysPushmessage record) {
        int count = 0;
        if (!StringUtils.isEmpty((String)record.getTouserids()) && !StringUtils.isEmpty((String)record.getTostaffids())) {
            count += this.sysUsermessagesMapper.insertintoSelect(record.getCid(), record.getId(), 1, record.getTouserids(), record.getTostaffids());
        } else if (!StringUtils.isEmpty((String)record.getTouserids())) {
            count += this.sysUsermessagesMapper.insertintoUserSelect(record.getCid(), record.getId(), 1, record.getTouserids());
        } else if (!StringUtils.isEmpty((String)record.getTostaffids())) {
            count += this.sysUsermessagesMapper.insertintoStaffSelect(record.getCid(), record.getId(), 1, record.getTostaffids());
        }
        return count;
    }

    public SysUsermessages getSysUsermessagesById(int id) {
        return this.sysUsermessagesMapper.selectByPrimaryKey(id);
    }

    public SysUsermessages getUsermessagesDetail(int id) {
        SysUsermessagesExample example = new SysUsermessagesExample();
        example.createCriteria().andIdEqualTo(id);
        List<SysUsermessages> list = this.sysUsermessagesMapper.selectByExampleWithEntity(example);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public int updateSysUsermessages(SysUsermessages record) {
        return this.sysUsermessagesMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteSysUsermessagesByID(int id) {
        return this.sysUsermessagesMapper.deleteByPrimaryKey(id);
    }

    public List<SysUsermessages> getSysUsermessagesListByExample(SysUsermessagesExample example) {
        return this.sysUsermessagesMapper.selectByExample(example);
    }

    public List<SysUsermessages> getSysUsermessagesListByUid(int userId, int cid) {
        SysUsermessagesExample example = new SysUsermessagesExample();
        example.createCriteria().andTouseridEqualTo(userId).andCidEqualTo(cid).andProcessstateEqualTo(Constant.ACTIVE_NO).andIsactiveEqualTo(Constant.ACTIVE_YES);
        example.setOrderByClause("  id desc");
        return this.sysUsermessagesMapper.selectByExampleWithEntity(example);
    }

    public List<SysUsermessages> getSysUsermessagesListByStaffid(int staffid, int cid, Byte isread) {
        SysUsermessagesExample example = new SysUsermessagesExample();
        SysUsermessagesExample.Criteria criteria = example.createCriteria().andTostaffidEqualTo(staffid).andCidEqualTo(cid).andIsactiveEqualTo(Constant.ACTIVE_YES);
        if (isread != null) {
            criteria.andProcessstateEqualTo(isread);
        }
        example.setOrderByClause("  id desc");
        return this.sysUsermessagesMapper.selectByExampleWithEntity(example);
    }

    public int countUserMessageUnread2(int userId, int cid) {
        SysUsermessagesExample example = new SysUsermessagesExample();
        example.createCriteria().andTouseridEqualTo(userId).andCidEqualTo(cid).andProcessstateEqualTo(Constant.ACTIVE_NO).andIsactiveEqualTo(Constant.ACTIVE_YES);
        return this.sysUsermessagesMapper.countByExample(example);
    }

    public int countStaffMessageUnread(int staffId, int cid) {
        SysUsermessagesExample example = new SysUsermessagesExample();
        example.createCriteria().andTostaffidEqualTo(staffId).andCidEqualTo(cid).andProcessstateEqualTo(Constant.ACTIVE_NO).andIsactiveEqualTo(Constant.ACTIVE_YES);
        return this.sysUsermessagesMapper.countByExample(example);
    }
}

