/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.access.ScriptRunner;
import org.snaker.engine.access.jdbc.JdbcHelper;

public class ScriptsExecutor {
    private static final Logger log = LoggerFactory.getLogger(ScriptsExecutor.class);
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void run() {
        log.info("scripts running......");
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            if (JdbcHelper.isExec((Connection)conn)) {
                log.info("script has completed execution.skip this step");
                return;
            }
            try {
                String databaseType = JdbcHelper.getDatabaseType((Connection)conn);
                String[] schemas = new String[]{"db/schema-" + databaseType + ".sql", "db/init-data.sql"};
                ScriptRunner runner = new ScriptRunner(conn, true);
                String[] stringArray = schemas;
                int n = schemas.length;
                int n2 = 0;
                while (n2 < n) {
                    String schema = stringArray[n2];
                    runner.runScript(schema);
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                JdbcHelper.close((Connection)conn);
            }
            catch (SQLException sQLException) {}
        }
    }
}

