/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service;

import cn.smarthse.core.dao.sys.SysQuartzSchedulejobMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.sys.SysQuartzSchedulejob;
import cn.smarthse.core.model.sys.SysQuartzSchedulejobExample;
import cn.smarthse.core.quartz.QuartzManager;
import cn.smarthse.core.quartz.QuartzScheduleJob;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class ScheduleJobService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Scheduler scheduler;
    @Autowired
    SysQuartzSchedulejobMapper scheduleJobMapper;

    public void initScheduleJob() {
        List<SysQuartzSchedulejob> scheduleJobList = this.getSysQuartzSchedulejobAllList();
        if (CollectionUtils.isEmpty(scheduleJobList)) {
            return;
        }
        try {
            for (SysQuartzSchedulejob scheduleJob : scheduleJobList) {
                CronTrigger cronTrigger = QuartzManager.getCronTrigger(this.scheduler, scheduleJob.getJobname(), scheduleJob.getJobgroup());
                QuartzScheduleJob job = this.transformJob2QJob(scheduleJob);
                if (cronTrigger == null) {
                    QuartzManager.createScheduleJob(this.scheduler, job);
                } else {
                    QuartzManager.updateScheduleJob(this.scheduler, job);
                }
                this.logger.info("\u521d\u59cb\u5316\u4efb\u52a1[" + job.getJobName() + "].....\u5b8c\u6210!");
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int addSysQuartzSchedulejob(SysQuartzSchedulejob scheduleJob) {
        return 0;
    }

    public int updateSysQuartzSchedulejob(SysQuartzSchedulejob scheduleJob) {
        return 0;
    }

    public int delUpdateSysQuartzSchedulejob(SysQuartzSchedulejob scheduleJob) {
        return 0;
    }

    public int deleteSysQuartzSchedulejobById(Integer id) {
        return 0;
    }

    public void runOnce(int scheduleJobId) {
    }

    public void pauseJob(int scheduleJobId) {
    }

    public void resumeJob(Long scheduleJobId) {
    }

    public SysQuartzSchedulejob getSysQuartzSchedulejobByID(int id) {
        return this.scheduleJobMapper.selectByPrimaryKey(id);
    }

    public List<SysQuartzSchedulejob> getSysQuartzSchedulejobList(SysQuartzSchedulejobExample example) {
        return this.scheduleJobMapper.selectByExample(example);
    }

    public List<SysQuartzSchedulejob> getSysQuartzSchedulejobAllList() {
        SysQuartzSchedulejobExample example = new SysQuartzSchedulejobExample();
        return this.scheduleJobMapper.selectByExample(example);
    }

    public List<SysQuartzSchedulejob> getExecutingJobList() {
        try {
            List executingJobs = this.scheduler.getCurrentlyExecutingJobs();
            ArrayList<SysQuartzSchedulejob> jobList = new ArrayList<SysQuartzSchedulejob>(executingJobs.size());
            for (JobExecutionContext executingJob : executingJobs) {
                SysQuartzSchedulejob job = new SysQuartzSchedulejob();
                JobDetail jobDetail = executingJob.getJobDetail();
                JobKey jobKey = jobDetail.getKey();
                Trigger trigger = executingJob.getTrigger();
                job.setJobname(jobKey.getName());
                job.setJobgroup(jobKey.getGroup());
                job.setJobtrigger(trigger.getKey().getName());
                Trigger.TriggerState triggerState = this.scheduler.getTriggerState(trigger.getKey());
                job.setStatus(triggerState.name());
                if (trigger instanceof CronTrigger) {
                    CronTrigger cronTrigger = (CronTrigger)trigger;
                    String cronExpression = cronTrigger.getCronExpression();
                    job.setCronexpression(cronExpression);
                }
                jobList.add(job);
            }
            return jobList;
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return null;
        }
    }

    private QuartzScheduleJob transformJob2QJob(SysQuartzSchedulejob scheduleJob) {
        if (scheduleJob == null) {
            return null;
        }
        QuartzScheduleJob job = new QuartzScheduleJob();
        job.setAliasName(scheduleJob.getAliasname());
        job.setCronExpression(scheduleJob.getCronexpression());
        job.setDescription(scheduleJob.getDescription());
        job.setGmtCreate(scheduleJob.getGmtcreate());
        job.setGmtModify(scheduleJob.getGmtmodify());
        job.setIsSync(scheduleJob.getIssync() == Constant.ACTIVE_YES);
        job.setJobGroup(scheduleJob.getJobgroup());
        job.setJobName(scheduleJob.getJobname());
        job.setJobTrigger(scheduleJob.getJobtrigger());
        job.setScheduleJobId(scheduleJob.getId());
        job.setStatus(scheduleJob.getStatus());
        job.setBeanid(scheduleJob.getBeanid());
        job.setBeanClass(scheduleJob.getBeanclass());
        return job;
    }
}

