/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service;

import cn.smarthse.core.dao.sys.SysNoticeMapper;
import cn.smarthse.core.dao.sys.SysNoticeattafilesMapper;
import cn.smarthse.core.dao.sys.SysNoticeusersMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.basic.File;
import cn.smarthse.core.model.sys.SysNotice;
import cn.smarthse.core.model.sys.SysNoticeExample;
import cn.smarthse.core.model.sys.SysNoticeattafiles;
import cn.smarthse.core.model.sys.SysNoticeattafilesExample;
import cn.smarthse.core.model.sys.SysNoticeusers;
import cn.smarthse.core.model.sys.SysNoticeusersExample;
import cn.smarthse.core.model.sys.SysPushmessage;
import cn.smarthse.core.service.SysPushmessageService;
import cn.smarthse.core.util.DateUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class NoticeService {
    @Autowired
    SysNoticeMapper sysNoticeMapper;
    @Autowired
    SysNoticeattafilesMapper sysNoticeattafilesMapper;
    @Autowired
    SysNoticeusersMapper sysNoticeusersMapper;
    @Autowired
    SysPushmessageService pushmessageService;

    public int countUnreadNoticeByUser(int userId) {
        SysNoticeusersExample example = new SysNoticeusersExample();
        example.or().andTouseridEqualTo(userId).andIsreadEqualTo((byte)0);
        return this.sysNoticeusersMapper.countByExample(example);
    }

    @CacheEvict(value={"default"}, key="'Notice-unread-byUser-' + #userId")
    public void clearUnreadNoticeByUserCache(int userId) {
    }

    public List<SysNotice> getNoticeListToUser(Integer staffid, Integer cid, String keyword) {
        if (cid == null || cid == 0) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty((String)keyword)) {
            keyword = null;
        }
        return this.sysNoticeMapper.selectByMapWithEntity(cid, null, keyword, staffid);
    }

    public List<SysNotice> getNoticeListByUser(Integer staffid, Integer cid, String keyword) {
        if (cid == null || cid == 0) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty((String)keyword)) {
            keyword = null;
        }
        return this.sysNoticeMapper.selectByMapWithEntity(cid, staffid, keyword, null);
    }

    public List<SysNotice> getNoSendNoticeListByJob() {
        SysNoticeExample e = new SysNoticeExample();
        e.createCriteria().andIssendEqualTo(Constant.ACTIVE_NO).andIsactiveEqualTo(Constant.ACTIVE_YES).andCreatedatetimeBetween(DateUtil.addMinutes((Date)new Date(), (int)-5), DateUtil.addMinutes((Date)new Date(), (int)1));
        e.setOrderByClause(" createdatetime asc");
        return this.sysNoticeMapper.selectByExample(e);
    }

    public SysNotice addSysNotice(SysNotice sysNotice) {
        this.sysNoticeMapper.insertSelective(sysNotice);
        if (sysNotice.getAttafiles() != null) {
            for (File f : sysNotice.getAttafiles()) {
                SysNoticeattafiles af = new SysNoticeattafiles();
                af.setFileid(f.getId());
                af.setIsactive(Constant.ACTIVE_YES);
                af.setNoticeid(sysNotice.getId());
                this.sysNoticeattafilesMapper.insertSelective(af);
            }
        }
        if (sysNotice.getIssend() == Constant.ACTIVE_YES) {
            this.sendNotice(sysNotice);
        }
        return sysNotice;
    }

    public int sendNotice(SysNotice notice) {
        if (notice == null) {
            return 0;
        }
        this.sysNoticeusersMapper.insertintoSelect(notice.getCid(), notice.getId(), notice.getTouserids());
        SysPushmessage pushmessage = new SysPushmessage();
        pushmessage.setCid(notice.getCid());
        pushmessage.setIsactive(Constant.ACTIVE_YES);
        pushmessage.setMessageno(notice.getNoticeno());
        pushmessage.setMessagetype(1);
        pushmessage.setProcessname(notice.getNoticesource());
        pushmessage.setProcessurl("/mywork/notice/view/" + notice.getId());
        pushmessage.setSenderdatetime(new Date());
        pushmessage.setSenderuserid(notice.getCreateoruserid());
        pushmessage.setTitle(notice.getTitle());
        pushmessage.setTostaffids(notice.getTouserids());
        this.pushmessageService.addSysPushmessage(pushmessage);
        notice.setCreatedatetime(new Date());
        notice.setIssend(Constant.ACTIVE_YES);
        this.sysNoticeMapper.updateByPrimaryKey(notice);
        return 1;
    }

    public SysNotice getSysNoticeByID(int id) {
        return this.sysNoticeMapper.selectByPrimaryKey(id);
    }

    public SysNotice getSysNoticeByID(int id, int touserId) {
        return this.sysNoticeMapper.selectByExampleWithEntity(id, touserId);
    }

    public int deleteSysNoticeByID(int id) {
        SysNotice notice = this.sysNoticeMapper.selectByPrimaryKey(id);
        notice.setIsactive(Constant.ACTIVE_NO);
        return this.sysNoticeMapper.updateByPrimaryKey(notice);
    }

    public void batchDeleteNotice(int uid, List<Integer> ids) {
        if (ids != null && ids.size() > 0) {
            SysNoticeExample example = new SysNoticeExample();
            SysNoticeExample.Criteria criteria = example.createCriteria();
            criteria.andCreateoruseridEqualTo(uid);
            criteria.andIdIn((List)ids);
            SysNotice record = new SysNotice();
            record.setIsactive(Constant.ACTIVE_NO);
            this.sysNoticeMapper.updateByExampleSelective(record, example);
        }
    }

    public SysNoticeattafiles addNoticeattafiles(SysNoticeattafiles noticeattafiles) {
        noticeattafiles.setIsactive(Constant.ACTIVE_YES);
        this.sysNoticeattafilesMapper.insertSelective(noticeattafiles);
        return noticeattafiles;
    }

    public int delNoticeattafilesById(Integer id) {
        SysNoticeattafiles noticeattafiles = this.sysNoticeattafilesMapper.selectByPrimaryKey(id);
        noticeattafiles.setIsactive(Constant.ACTIVE_NO);
        return this.sysNoticeattafilesMapper.updateByPrimaryKey(noticeattafiles);
    }

    public SysNoticeattafiles getSysNoticeattafilesByID(Integer id) {
        return this.sysNoticeattafilesMapper.selectByPrimaryKey(id);
    }

    public List<SysNoticeattafiles> getNoticeattafilesByNoticeid(int noticeid) {
        SysNoticeattafilesExample e = new SysNoticeattafilesExample();
        e.createCriteria().andNoticeidEqualTo(noticeid).andIsactiveEqualTo(Constant.ACTIVE_YES);
        return this.sysNoticeattafilesMapper.selectByExample(e);
    }

    public List<SysNoticeusers> getNoticeusersByNotice(Integer noticeId) {
        SysNoticeusersExample e = new SysNoticeusersExample();
        e.createCriteria().andNoticeidEqualTo(noticeId);
        return this.sysNoticeusersMapper.selectByExample(e);
    }

    public SysNoticeusers getNoticeUsersById(int id) {
        return this.sysNoticeusersMapper.selectByIdWithEntity(id);
    }

    public SysNoticeusers getNoticeUsersByKey(int id) {
        return this.sysNoticeusersMapper.selectByPrimaryKey(id);
    }

    public int updateSysnoticeUsers(SysNoticeusers record) {
        return this.sysNoticeusersMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteSysnoticeUsersByID(int id) {
        SysNoticeusers unotice = this.sysNoticeusersMapper.selectByPrimaryKey(id);
        unotice.setIsactive(Constant.ACTIVE_NO);
        return this.sysNoticeusersMapper.updateByPrimaryKeySelective(unotice);
    }

    public void batchDelete(int uid, List<Integer> ids) {
        if (ids != null && ids.size() > 0) {
            SysNoticeusersExample example = new SysNoticeusersExample();
            SysNoticeusersExample.Criteria criteria = example.createCriteria();
            criteria.andTouseridEqualTo(uid);
            criteria.andIdIn((List)ids);
            SysNoticeusers record = new SysNoticeusers();
            record.setIsactive(Constant.ACTIVE_NO);
            this.sysNoticeusersMapper.updateByExampleSelective(record, example);
        }
    }
}

