/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service;

import cn.smarthse.core.dao.NationstandardMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.common.util.HtmlUtil;
import cn.smarthse.core.model.Nationstandard;
import cn.smarthse.core.model.NationstandardExample;
import cn.smarthse.core.model.NationstandardWithBLOBs;
import com.github.pagehelper.PageHelper;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NationstandardService
implements Runnable {
    private String url;
    private static Logger loggerinfo = Logger.getLogger(NationstandardService.class);
    @Autowired
    private NationstandardMapper nationstandardMapper;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public NationstandardWithBLOBs getNationstandard(String url) {
        NationstandardWithBLOBs standard = new NationstandardWithBLOBs();
        Document doc = null;
        try {
            doc = Jsoup.connect((String)url).get();
        }
        catch (Exception e) {
            loggerinfo.error((Object)("\u8fde\u63a5\u51fa\u9519\u6216\u8d85\u65f6\uff0curl\uff1a" + url));
            return null;
        }
        String standardno = null;
        String nameCh = null;
        String nameEn = null;
        try {
            standardno = ((Element)doc.select("h3").get(0)).html();
            standardno = HtmlUtil.delHTMLTag(standardno).replaceAll("\u73b0\u884c", "");
            standard.setStandardno(standardno);
            nameCh = ((Element)doc.select(".dl-horizontal-more").select("dd").get(0)).html();
            nameEn = ((Element)doc.select(".dl-horizontal-more").select("dd").get(1)).html();
            standard.setNameCh(nameCh);
            standard.setNameEn(nameEn);
        }
        catch (Exception e) {
            loggerinfo.info((Object)("\u6807\u51c6\u53f7\uff1a" + standardno + " \u7684\u4e2d\u6587\u9898\u540d\uff0c \u82f1\u6587\u9898\u540d\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e"));
            standard.setNameCh(nameCh);
            standard.setNameEn(nameEn);
        }
        String publishDate = null;
        String effectDate = null;
        try {
            publishDate = ((Element)doc.select(".detailBox:has(.icon_info)").select("dd").get(0)).html().replaceAll("\u53d1\u5e03\u65e5\u671f\uff1a", "");
            effectDate = ((Element)doc.select(".detailBox:has(.icon_info)").select("dd").get(1)).html().replaceAll("\u5b9e\u65bd\u65e5\u671f\uff1a", "");
            standard.setPublishDate(Constant.formatDate.parse(publishDate));
            standard.setEffectDate(Constant.formatDate.parse(effectDate));
        }
        catch (Exception e) {
            loggerinfo.info((Object)("\u6807\u51c6\u53f7\uff1a" + standardno + " \u7684\u53d1\u5e03\u65e5\u671f\uff0c\u5b9e\u65bd\u65e5\u671f\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e"));
            standard.setPublishDate(null);
            standard.setEffectDate(null);
        }
        try {
            String validRange = ((Element)doc.select(".detailBox:has(.icon_scope)").select("dd").get(0)).html();
            validRange = HtmlUtil.delHTMLTag(validRange);
            standard.setValidRange(validRange);
            Elements replace = doc.select(".detailBox:has(.icon_assoc)").select("dd");
            if (!replace.isEmpty()) {
                String standardnoReplace = ((Element)doc.select(".detailBox:has(.icon_assoc)").select("dd").get(0)).select("dd").select("a").html();
                standardnoReplace = HtmlUtil.delHTMLTag(standardnoReplace);
                standard.setStandardnoReplace(standardnoReplace);
            }
            String typeCh = ((Element)doc.select("#getCcsCn").get(0)).html();
            String typeIso = ((Element)doc.select("#getIcsCn").get(0)).html();
            standard.setTypeCh(typeCh);
            standard.setTypeIso(typeIso);
        }
        catch (Exception e) {
            loggerinfo.info((Object)("\u6807\u51c6\u53f7\uff1a" + standardno + " \u7684\u9002\u7528\u8303\u56f4\uff0c\u4ee3\u66ff\u6807\u51c6\u53f7\uff0c\u4e2d\u56fd\u6807\u51c6\u5206\u7c7b, \u56fd\u9645\u6807\u51c6\u5206\u7c7b \u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        return standard;
    }

    public Nationstandard selectByPrimaryKey(int id) {
        return this.nationstandardMapper.selectByPrimaryKey(id);
    }

    public List<NationstandardWithBLOBs> selectAll(int pageNumber, int pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        return this.nationstandardMapper.selectByExampleWithBLOBs(new NationstandardExample());
    }

    public int insertNationstandardISO() throws IOException, ParseException {
        int count = 0;
        Document doc = null;
        File f = new File("D:/ICS_all.html");
        doc = Jsoup.parse((File)f, (String)"UTF-8");
        Elements ListRow = doc.select("table").select("tr");
        int i = 0;
        while (i < ListRow.size()) {
            if (i != 0) {
                Element row = (Element)ListRow.get(i);
                String href = row.select("a").first().attr("href");
                System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(10000));
                System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(10000));
                String url = "http://www.cssn.net.cn/pagesnew/search/" + href;
                NationstandardService service = new NationstandardService();
                service.setUrl(url);
                Thread t = new Thread(service);
                try {
                    Thread.sleep(1000L);
                    t.start();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                NationstandardWithBLOBs standard = this.getNationstandard(url);
                if (standard != null) {
                    loggerinfo.info((Object)("\u5e8f\u53f7:" + (count += this.nationstandardMapper.insertSelective(standard)) + ", \u6807\u51c6\u53f7:" + standard.getStandardno()));
                }
            }
            ++i;
        }
        if (count > 0) {
            return count;
        }
        return -1;
    }

    public int insertNationstandardCH() throws IOException, ParseException {
        int count = 0;
        Document doc = null;
        String type_all = "C51,C52,C57,C60,C62,C65,C66,C67,C68,C69,C70,C71,C72,C73,C75,C77,C78,C80,C83,C85,B09,D09,E09,F09,G09,H09,J09,K09,L09,M09,N09,P09,Q09,R09,S09,T09,U09,V09,W09,X09,Y09";
        String[] typeArray = type_all.split(",");
        int k = 0;
        while (k < typeArray.length) {
            File f = new File("D:/CCS_" + typeArray[k] + ".html");
            doc = Jsoup.parse((File)f, (String)"UTF-8");
            loggerinfo.info((Object)("\u6807\u51c6\u7c7b\u522b\uff1a" + typeArray[k]));
            Elements ListRow = doc.select("table").select("tr");
            int i = 0;
            while (i < ListRow.size()) {
                if (i != 0) {
                    Element row = (Element)ListRow.get(i);
                    String href = row.select("a").first().attr("href");
                    System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(10000));
                    System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(10000));
                    String url = "http://www.cssn.net.cn/pagesnew/search/" + href;
                    NationstandardService service = new NationstandardService();
                    service.setUrl(url);
                    Thread t = new Thread(service);
                    try {
                        Thread.sleep(1000L);
                        t.start();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    NationstandardWithBLOBs standard = this.getNationstandard(url);
                    if (standard != null) {
                        loggerinfo.info((Object)("\u5e8f\u53f7:" + (count += this.nationstandardMapper.insertSelective(standard)) + ", \u6807\u51c6\u53f7:" + standard.getStandardno()));
                    }
                }
                ++i;
            }
            ++k;
        }
        if (count > 0) {
            return count;
        }
        return -1;
    }

    @Override
    public void run() {
        this.getNationstandard(this.url);
    }
}

