/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service;

import cn.smarthse.core.annotation.SYSLOG;
import cn.smarthse.core.dao.legal.LawApplyorgMapper;
import cn.smarthse.core.dao.legal.LawInfoMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.legal.LawApplyorg;
import cn.smarthse.core.model.legal.LawApplyorgExample;
import cn.smarthse.core.model.legal.LawInfo;
import cn.smarthse.core.model.legal.LawInfoExample;
import cn.smarthse.core.model.legal.vo.LegalItemVO;
import cn.smarthse.core.model.sys.SysLegal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@SYSLOG(desc="\u6cd5\u5f8b\u6cd5\u89c4\u6a21\u5757")
@Service
public class LegalService {
    @Autowired
    LawInfoMapper lawinfoMapper;
    @Autowired
    LawApplyorgMapper lawapplyOrgMapper;

    public LawInfo addLawinfo(LawInfo record) {
        this.lawinfoMapper.insertSelective(record);
        if (record.getLaworgs() != null && record.getLaworgs().size() > 0) {
            for (LawApplyorg org : record.getLaworgs()) {
                org.setCid(record.getCid());
                org.setIsvalid(Constant.ACTIVE_YES);
                org.setLawid(record.getId());
                org.setUpdatedate(new Date());
                this.addLawapplyOrg(org);
            }
        }
        return record;
    }

    public LawInfo getLawInfoById(int id) {
        return this.lawinfoMapper.selectByPrimaryKey(id);
    }

    public int updateLawinfo(LawInfo record) {
        return this.lawinfoMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteLawinfo(LawInfo record) {
        return this.lawinfoMapper.deleteByPrimaryKey(record.getId());
    }

    public List<LawInfo> getLawinfoListByExample(LawInfoExample example) {
        return this.lawinfoMapper.selectByExample(example);
    }

    public int countLawInfo(int cid) {
        LawInfoExample example = new LawInfoExample();
        example.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo((byte)1);
        return this.lawinfoMapper.countByExample(example);
    }

    public List<LegalItemVO> getLegalList(Integer cid, int type) {
        if (cid == null || cid == 0) {
            return Collections.emptyList();
        }
        return this.lawinfoMapper.selectLawInfoItemList(cid, type);
    }

    public int batchImportLawInfoFromSys(Integer cid, List<Integer> list) {
        SysLegal record = new SysLegal();
        record.setRecommsoftid(1);
        record.setState(5942);
        record.setIdslist(list);
        return this.lawinfoMapper.importFromSys(record, cid);
    }

    public LawApplyorg addLawapplyOrg(LawApplyorg record) {
        this.lawapplyOrgMapper.insertSelective(record);
        return record;
    }

    public LawApplyorg getLawApplyorgById(int id) {
        return this.lawapplyOrgMapper.selectByPrimaryKey(id);
    }

    public int updateLawapplyOrg(LawApplyorg record) {
        return this.lawapplyOrgMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteLawapplyOrg(Integer id) {
        return this.lawapplyOrgMapper.deleteByPrimaryKey(id);
    }

    public List<LawApplyorg> getLawapplyOrgListByExample(LawApplyorgExample example) {
        return this.lawapplyOrgMapper.selectByExample(example);
    }

    public List<LawApplyorg> getLawOrgList(Integer cid, Integer lawid) {
        LawApplyorgExample example = new LawApplyorgExample();
        LawApplyorgExample.Criteria c = example.createCriteria();
        c.andCidEqualTo(cid);
        c.andLawidEqualTo(lawid);
        c.andIsvalidEqualTo(Constant.ACTIVE_YES);
        return this.lawapplyOrgMapper.selectByExampleWithEntity(example);
    }

    public List<LawApplyorg> getLawapplyOrgByLawid(Integer lawid) {
        return this.lawapplyOrgMapper.selectLawapplyOrgByLawid(lawid);
    }

    public int deleteLawApplyorg(Integer id) {
        return this.lawapplyOrgMapper.deleteByPrimaryKey(id);
    }
}

