/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service;

import cn.smarthse.core.dao.basic.FileMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.utils.file.FileUpload;
import cn.smarthse.core.framework.utils.file.UploadFileParameter;
import cn.smarthse.core.framework.utils.file.UploadFilePathEnum;
import cn.smarthse.core.model.basic.File;
import cn.smarthse.core.model.basic.FileExample;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class FileService {
    @Autowired
    FileMapper fileMapper;

    public File addFile(File record) {
        this.fileMapper.insertSelective(record);
        return record;
    }

    @Cacheable(value={"default"}, key="'File-byID-' + #id")
    public File getById(Integer id) {
        if (id != null && id > 0) {
            return this.fileMapper.selectByPrimaryKey(id);
        }
        return null;
    }

    @CacheEvict(value={"default"}, key="'File-byID-' + #record.id")
    public int updateFile(File record) {
        return this.fileMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteFile(File record) {
        return this.fileMapper.deleteByPrimaryKey(record.getId());
    }

    public List<File> getFileListByExample(FileExample example) {
        return this.fileMapper.selectByExample(example);
    }

    public File uploadFile(UploadFileParameter up, Byte fileType) {
        try {
            FileUpload.upload(up);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        File file = new File();
        file.setCreatetime(new Date());
        file.setFilename(up.getOriginalFilename());
        file.setCreator(up.getUserId());
        file.setFilesize(String.valueOf(up.getMultipartFile().getSize()));
        file.setIsvalid((byte)1);
        UploadFilePathEnum thispath = UploadFilePathEnum.getCode(up.getPathType());
        file.setOssurl(String.valueOf(thispath.getPath()) + "/" + up.getFileName());
        file.setDescription(thispath.getDesc());
        file.setFiletype(fileType);
        this.fileMapper.insertSelective(file);
        return file;
    }

    public File createFile(UploadFileParameter up) {
        File file = new File();
        file.setCreatetime(new Date());
        file.setFilename(up.getOriginalFilename());
        file.setCreator(up.getUserId());
        file.setFilesize(String.valueOf(up.getMultipartFile().getSize()));
        file.setIsvalid((byte)1);
        Byte fileType = Constant.FILETYPE_PIC;
        UploadFilePathEnum thispath = UploadFilePathEnum.getCode(up.getPathType());
        file.setOssurl(String.valueOf(thispath.getPath()) + "/" + up.getFileName());
        file.setDescription(thispath.getDesc());
        file.setFiletype(fileType);
        this.fileMapper.insertSelective(file);
        return file;
    }
}

