/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.utils.file;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImgThumbUtil {
    private static final String BMP = "bmp";
    private static final String PNG = "png";
    private static final String GIF = "gif";
    private static final String JPEG = "jpeg";
    private static final String JPG = "jpg";

    public static void getThumbnail(String source, String output, int width, int height) {
        boolean adjustSize = true;
        if (source == null || source.equals("") || width < 1 || height < 1) {
            return;
        }
        if (output == null || output.equals("")) {
            return;
        }
        if ((source = source.toLowerCase()).endsWith(BMP)) {
            ImgThumbUtil.BMPThumbnailHandler(source, output, width, height, adjustSize);
        } else if (source.endsWith(PNG) || source.endsWith(GIF) || source.endsWith(JPEG) || source.endsWith(JPG)) {
            ImgThumbUtil.thumbnailHandler(source, output, width, height, adjustSize);
        }
    }

    private static void thumbnailHandler(String source, String output, int width, int height, boolean adjustSize) {
        try {
            File sourceFile = new File(source);
            if (sourceFile.exists()) {
                BufferedImage image = ImageIO.read(sourceFile);
                int theImgWidth = ((Image)image).getWidth(null);
                int theImgHeight = ((Image)image).getHeight(null);
                int[] size = new int[]{theImgWidth, theImgHeight};
                if (adjustSize) {
                    size = ImgThumbUtil.adjustImageSize(theImgWidth, theImgHeight, width, height);
                }
                StringBuffer thumbnailFile = new StringBuffer();
                thumbnailFile.append(output);
                ImgThumbUtil.writeFile(image, size[0], size[1], thumbnailFile.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static void BMPThumbnailHandler(String source, String output, int width, int height, boolean adjustSize) {
        try {
            File sourceFile = new File(source);
            if (sourceFile.exists()) {
                Image image = ImgThumbUtil.getBMPImage(source);
                int theImgWidth = image.getWidth(null);
                int theImgHeight = image.getHeight(null);
                int[] size = new int[]{theImgWidth, theImgHeight};
                if (adjustSize) {
                    size = ImgThumbUtil.adjustImageSize(theImgWidth, theImgHeight, width, height);
                }
                StringBuffer thumbnailFile = new StringBuffer();
                thumbnailFile.append(output);
                ImgThumbUtil.writeFile(image, size[0], size[1], thumbnailFile.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static Image getBMPImage(String source) throws Exception {
        Image image = null;
        try (FileInputStream fs = null;){
            try {
                fs = new FileInputStream(source);
                int bfLen = 14;
                byte[] bf = new byte[bfLen];
                fs.read(bf, 0, bfLen);
                int biLen = 40;
                byte[] bi = new byte[biLen];
                fs.read(bi, 0, biLen);
                int nWidth = (bi[7] & 0xFF) << 24 | (bi[6] & 0xFF) << 16 | (bi[5] & 0xFF) << 8 | bi[4] & 0xFF;
                int nHeight = (bi[11] & 0xFF) << 24 | (bi[10] & 0xFF) << 16 | (bi[9] & 0xFF) << 8 | bi[8] & 0xFF;
                int nBitCount = (bi[15] & 0xFF) << 8 | bi[14] & 0xFF;
                int nSizeImage = (bi[23] & 0xFF) << 24 | (bi[22] & 0xFF) << 16 | (bi[21] & 0xFF) << 8 | bi[20] & 0xFF;
                if (nBitCount == 24) {
                    int nPad = nSizeImage / nHeight - nWidth * 3;
                    int[] nData = new int[nHeight * nWidth];
                    byte[] bRGB = new byte[(nWidth + nPad) * 3 * nHeight];
                    fs.read(bRGB, 0, (nWidth + nPad) * 3 * nHeight);
                    int nIndex = 0;
                    int j = 0;
                    while (j < nHeight) {
                        int i = 0;
                        while (i < nWidth) {
                            nData[nWidth * (nHeight - j - 1) + i] = 0xFF000000 | (bRGB[nIndex + 2] & 0xFF) << 16 | (bRGB[nIndex + 1] & 0xFF) << 8 | bRGB[nIndex] & 0xFF;
                            nIndex += 3;
                            ++i;
                        }
                        nIndex += nPad;
                        ++j;
                    }
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    image = kit.createImage(new MemoryImageSource(nWidth, nHeight, nData, 0, nWidth));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
        return image;
    }

    private static void writeFile(Image image, int width, int height, String thumbnailFile) throws Exception {
        if (image == null) {
            return;
        }
        BufferedImage tag = new BufferedImage(width, height, 1);
        tag.getGraphics().drawImage(image, 0, 0, width, height, null);
        try (FileOutputStream out = null;){
            try {
                out = new FileOutputStream(thumbnailFile);
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                encoder.encode(tag);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
    }

    private static int[] adjustImageSize(int theImgWidth, int theImgHeight, int defWidth, int defHeight) {
        int[] size = new int[2];
        float theImgHeightFloat = Float.parseFloat(String.valueOf(theImgHeight));
        float theImgWidthFloat = Float.parseFloat(String.valueOf(theImgWidth));
        if (theImgWidth < theImgHeight) {
            float scale = theImgHeightFloat / theImgWidthFloat;
            size[0] = Math.round((float)defHeight / scale);
            size[1] = defHeight;
        } else {
            float scale = theImgWidthFloat / theImgHeightFloat;
            size[0] = defWidth;
            size[1] = Math.round((float)defWidth / scale);
        }
        return size;
    }

    public static void main(String[] agrs) {
        ImgThumbUtil.getThumbnail("E:\\1.jpg", "E:\\test.jpg", 320, 320);
    }
}

