/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.utils.file;

import cn.smarthse.core.framework.common.util.EnumsUtil;
import cn.smarthse.core.framework.utils.file.UploadFileParameter;
import cn.smarthse.core.framework.utils.file.UploadFilePathEnum;
import cn.smarthse.core.framework.utils.file.UploadState;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.FileUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class FileUpload {
    public static String[] filePostfixs = new String[]{"*"};
    public static String[] typeImages = new String[]{"gif", "jpeg", "png", "jpg", "tif", "bmp"};
    public static String[] typeOthers = new String[]{"html", "htm", "doc", "xls", "txt", "zip", "rar", "pdf", "cll"};
    public static long maxFileSize = 0x200000L;
    public static int bufferSize = 8192;

    private static final void init() {
        if (bufferSize > Integer.MAX_VALUE) {
            bufferSize = 8192;
        } else if (bufferSize < 8) {
            bufferSize = 8;
        }
        if (maxFileSize < 1L) {
            maxFileSize = 0x80000000L;
        } else if (maxFileSize > Long.MAX_VALUE) {
            maxFileSize = 0x80000000L;
        }
    }

    public static UploadState upload4Stream(String fileName, String path, InputStream is) throws Exception {
        FileUpload.init();
        UploadState state = UploadState.UPLOAD_FAILURE;
        OutputStream fos = null;
        try {
            try {
                FileUpload.mkDir(path);
                fos = new FileOutputStream(String.valueOf(path) + fileName);
                byte[] buffer = new byte[bufferSize];
                int len = 0;
                while ((len = is.read(buffer)) > 0) {
                    ((FileOutputStream)fos).write(buffer, 0, len);
                }
                state = UploadState.UPLOAD_SUCCSSS;
            }
            catch (FileNotFoundException e) {
                state = UploadState.UPLOAD_NOTFOUND;
                throw e;
            }
            catch (IOException e) {
                state = UploadState.UPLOAD_FAILURE;
                throw e;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fos != null) {
                fos.flush();
                ((FileOutputStream)fos).close();
            }
        }
        return state;
    }

    public static UploadState upload4Stream(String fileName, String path, File file) throws Exception {
        FileUpload.init();
        UploadState state = UploadState.UPLOAD_FAILURE;
        try (FileInputStream fis = null;){
            try {
                long size = file.length();
                if (size <= 0L) {
                    state = UploadState.UPLOAD_ZEROSIZE;
                } else if (size <= maxFileSize) {
                    fis = new FileInputStream(file);
                    state = FileUpload.upload4Stream(fileName, path, fis);
                } else {
                    state = UploadState.UPLOAD_OVERSIZE;
                }
            }
            catch (FileNotFoundException e) {
                state = UploadState.UPLOAD_NOTFOUND;
                throw e;
            }
            catch (IOException e) {
                state = UploadState.UPLOAD_FAILURE;
                throw e;
            }
        }
        return state;
    }

    public static UploadState upload4Stream(String fileName, String path, File file, String[] allowTypes) throws Exception {
        UploadState state = UploadState.UPLOAD_FAILURE;
        state = FileUpload.validTypeByName(fileName, allowTypes) ? FileUpload.upload4Stream(fileName, path, file) : UploadState.UPLOAD_TYPE_ERROR;
        return state;
    }

    public static UploadState upload4Stream(String fileName, String path, InputStream fs, String[] allowTypes) throws Exception {
        UploadState state = UploadState.UPLOAD_FAILURE;
        state = FileUpload.validTypeByName(fileName, allowTypes) ? FileUpload.upload4Stream(fileName, path, fs) : UploadState.UPLOAD_TYPE_ERROR;
        return state;
    }

    public static boolean upload4CopyFile(String fileName, String path, File file) throws Exception {
        FileUpload.init();
        boolean success = false;
        if (file.length() <= maxFileSize) {
            FileUpload.mkDir(path);
            File destFile = new File(path, fileName);
            FileUtils.copyFile((File)file, (File)destFile);
            success = true;
        }
        return success;
    }

    public static boolean upload4CopyFile(String fileName, String path, File file, String[] allowTypes) throws Exception {
        boolean success = false;
        if (FileUpload.validTypeByName(fileName, allowTypes)) {
            success = FileUpload.upload4CopyFile(fileName, path, file);
        }
        return success;
    }

    public static boolean validTypeByName(String fileName, String[] allowTypes, boolean flag) {
        String suffix = FileUpload.getType(fileName);
        boolean valid = false;
        if (allowTypes.length > 0 && "*".equals(allowTypes[0])) {
            valid = true;
        } else {
            String[] stringArray = allowTypes;
            int n = allowTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (flag) {
                    if (suffix != null && suffix.equalsIgnoreCase(type)) {
                        valid = true;
                        break;
                    }
                } else if (suffix != null && suffix.equals(type)) {
                    valid = true;
                    break;
                }
                ++n2;
            }
        }
        return valid;
    }

    public static boolean validTypeByName(String fileName, String[] allowTypes) {
        return FileUpload.validTypeByName(fileName, allowTypes, true);
    }

    public static boolean validTypeByPostfix(String suffix, String[] allowTypes, boolean flag) {
        boolean valid = false;
        if (allowTypes.length > 0 && "*".equals(allowTypes[0])) {
            valid = true;
        } else {
            String[] stringArray = allowTypes;
            int n = allowTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (flag) {
                    if (suffix != null && suffix.equalsIgnoreCase(type)) {
                        valid = true;
                        break;
                    }
                } else if (suffix != null && suffix.equals(type)) {
                    valid = true;
                    break;
                }
                ++n2;
            }
        }
        return valid;
    }

    public static boolean validTypeByPostfix(String suffix, String[] allowTypes) {
        return FileUpload.validTypeByPostfix(suffix, allowTypes, true);
    }

    public static boolean validTypeByPostfix4Images(String suffix) {
        return FileUpload.validTypeByPostfix(suffix, typeImages);
    }

    public static boolean validTypeByPostfix4Others(String suffix) {
        return FileUpload.validTypeByPostfix(suffix, typeOthers);
    }

    public static boolean validTypeByName4Images(String fileName) {
        return FileUpload.validTypeByName(fileName, typeImages);
    }

    public static boolean validTypeByName4Others(String fileName) {
        return FileUpload.validTypeByName(fileName, typeOthers);
    }

    public static boolean removeFile(String fileName, String path) {
        boolean flag = false;
        if (FileUpload.isFileExist(fileName, path)) {
            File file = new File(String.valueOf(path) + fileName);
            flag = file.delete();
        }
        return flag;
    }

    public static boolean removeFile(File file) {
        boolean flag = false;
        if (file != null && file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    public static boolean removeFile(String path) {
        return FileUpload.removeFile(new File(path));
    }

    public static boolean removeFile4Dir(File file) {
        boolean flag = false;
        if (file != null && file.exists() && file.isDirectory()) {
            File[] allFile;
            File[] fileArray = allFile = file.listFiles();
            int n = allFile.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                flag = f.delete();
                if (!flag) {
                    System.err.println("\u5220\u9664\u6587\u4ef6" + f.getAbsolutePath() + "\u51fa\u9519\u4e86\uff01");
                    break;
                }
                ++n2;
            }
        }
        return flag;
    }

    public static boolean removeFile4Dir(String path) {
        return FileUpload.removeFile4Dir(new File(path));
    }

    public static boolean removeAllFile4Dir(File file) {
        boolean flag = false;
        if (file != null && file.exists() && file.isDirectory()) {
            File[] allFile;
            File[] fileArray = allFile = file.listFiles();
            int n = allFile.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                flag = !f.isDirectory() ? f.delete() : FileUpload.removeAllFile4Dir(f);
                if (!flag) {
                    System.err.println("\u5220\u9664\u6587\u4ef6" + f.getAbsolutePath() + "\u51fa\u9519\u4e86\uff01");
                    break;
                }
                ++n2;
            }
        }
        return flag;
    }

    public static boolean removeAllFile4Dir(String path) {
        return FileUpload.removeAllFile4Dir(new File(path));
    }

    public static String getSuffix(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            String suffix = fileName.substring(index);
            return suffix;
        }
        return null;
    }

    public static String getType(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            String suffix = fileName.substring(index + 1);
            return suffix;
        }
        return null;
    }

    public static String getNewFileName(String fileName, String newName, String nullSuffix) {
        String suffix = FileUpload.getSuffix(fileName);
        newName = suffix != null ? String.valueOf(newName) + suffix : newName.concat(".").concat(nullSuffix);
        return newName;
    }

    public static String getRandomName(String fileName) {
        String randomName = UUID.randomUUID().toString();
        return FileUpload.getNewFileName(fileName, randomName, "txt");
    }

    public static String getNumberName(String fileName) {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddhhmmss");
        int rand = new Random().nextInt(1000);
        String numberName = String.valueOf(format.format(new Date())) + rand;
        return FileUpload.getNewFileName(fileName, numberName, "txt");
    }

    public static boolean isFileExist(String fileName, String path) {
        File file = new File(String.valueOf(path) + fileName);
        return file.exists();
    }

    public static String getBracketFileName(String fileName, String path) {
        return FileUpload.getBracketFileName(fileName, fileName, path, 1);
    }

    public static String getBracketFileName(String fileName, String bracketName, String path, int num) {
        boolean exist = FileUpload.isFileExist(bracketName, path);
        if (exist) {
            int index = fileName.lastIndexOf(".");
            String suffix = "";
            bracketName = fileName;
            if (index != -1) {
                suffix = fileName.substring(index);
                bracketName = fileName.substring(0, index);
            }
            bracketName = String.valueOf(bracketName) + "(" + num + ")" + suffix;
            bracketName = FileUpload.getBracketFileName(fileName, bracketName, path, ++num);
        }
        return bracketName;
    }

    public static String getDoPath(String path) {
        path = path.replace("\\", "/");
        return path;
    }

    public static boolean mkDir(String path) throws Exception {
        File file = null;
        try {
            file = new File(path);
            if (!file.exists()) {
                boolean bl = file.mkdirs();
                return bl;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            file = null;
        }
        return true;
    }

    public static void writeBrevityPic(File file, float width, float height) throws IOException {
        BufferedImage src = ImageIO.read(file);
        int old_w = ((Image)src).getWidth(null);
        int old_h = ((Image)src).getHeight(null);
        int new_w = 0;
        int new_h = 0;
        float tempdouble = old_w >= old_h ? (float)old_w / width : (float)old_h / height;
        if ((float)old_w >= width || (float)old_h >= height) {
            new_w = Math.round((float)old_w / tempdouble);
            new_h = Math.round((float)old_h / tempdouble);
            while ((float)new_w > width && (float)new_h > height) {
                if ((float)new_w > width) {
                    tempdouble = (float)new_w / width;
                    new_w = Math.round((float)new_w / tempdouble);
                    new_h = Math.round((float)new_h / tempdouble);
                }
                if (!((float)new_h > height)) continue;
                tempdouble = (float)new_h / height;
                new_w = Math.round((float)new_w / tempdouble);
                new_h = Math.round((float)new_h / tempdouble);
            }
            BufferedImage tag = new BufferedImage(new_w, new_h, 1);
            tag.getGraphics().drawImage(src, 0, 0, new_w, new_h, null);
            FileOutputStream newimage = new FileOutputStream(file);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)newimage);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(tag);
            param.setQuality(1.0f, true);
            encoder.encode(tag, param);
            encoder.encode(tag);
            newimage.close();
        }
    }

    public static UploadFileParameter upload(UploadFileParameter up) throws Exception {
        UploadFileParameter ufile = new UploadFileParameter();
        try {
            MultipartHttpServletRequest multipartRequest;
            MultipartFile file;
            if ((up.getMultipartFile() == null || up.getMultipartFile().getSize() == 0L) && (file = (multipartRequest = (MultipartHttpServletRequest)up.getRequest()).getFile("Filedata")) != null && file.getSize() > 0L) {
                up.setMultipartFile(file);
            }
            if (up.getMultipartFile() == null || up.getMultipartFile().getSize() == 0L) {
                ufile.setUploadState(UploadState.UPLOAD_ZEROSIZE);
                return ufile;
            }
            CommonsMultipartFile cf = (CommonsMultipartFile)up.getMultipartFile();
            DiskFileItem fi = (DiskFileItem)cf.getFileItem();
            File f = fi.getStoreLocation();
            String path = String.valueOf(up.getRequest().getSession().getServletContext().getRealPath("/")) + UploadFileParameter.FILE_PATH;
            UploadFilePathEnum thispath = UploadFilePathEnum.getCode(up.getPathType());
            path = String.valueOf(path) + thispath.getPath() + UploadFileParameter.FILE_PATH_SEP;
            up.setSavePath(path);
            up.setOriginalFilename(up.getMultipartFile().getOriginalFilename());
            up.setFileName(FileUpload.getRandomName(up.getOriginalFilename()));
            up.setFile(f);
            UploadState state = FileUpload.upload4Stream(up.getFileName(), up.getSavePath(), up.getFile());
            ufile.setUploadState(state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ufile;
    }

    public static File getFile(String fileName, HttpServletRequest request, String cusPath) {
        String source;
        UploadFilePathEnum orderState = EnumsUtil.valueOf(UploadFilePathEnum.class, (byte)5);
        String tpath = source = UploadFileParameter.getUploadFilePath(orderState);
        if (cusPath != null) {
            tpath = cusPath;
        }
        String path = request.getSession().getServletContext().getRealPath(tpath);
        File file = new File(path, fileName);
        return file;
    }

    public static void main(String[] args) throws Exception {
        String path = "D:/";
        UploadFileParameter up = new UploadFileParameter();
        up.setPathType(2);
        up.setFileName(FileUpload.getRandomName("2015\\2\\5\\afews.jpg"));
        System.out.println("\u539f\u56fe\u8def\u5f84\uff1a" + up.getPathSource());
        System.out.println("\u6c34\u5370\u56fe\u8def\u5f84\uff1a" + up.getPathWater());
        System.out.println("\u7f29\u7565\u56fe\u8def\u5f84\uff1a" + up.getPathThumb());
        System.out.println("\u65f6\u95f4\u8def\u5f84\uff1a" + up.getPathDate());
        System.out.println("\u65f6\u95f4\u8def\u5f84\u5e26\u6587\u4ef6\u540d\uff1a" + up.getPathDateFileName());
        System.out.println("\u65f6\u95f4\u8def\u5f84\u5e26\u6587\u4ef6\u540d\u8f93\u51fa\uff1a" + up.getUrlDateFileName());
        System.out.println("\u539f\u56fe\u8def\u5f84\u5e26\u65f6\u95f4\u8def\u5f84\u548c\u6587\u4ef6\u540d\uff1a" + FileUpload.getDoPath(String.valueOf(up.getPathSource()) + up.getPathDateFileName()));
        System.out.println("\u6c34\u5370\u56fe\u8def\u5f84\u5e26\u65f6\u95f4\u8def\u5f84\u548c\u6587\u4ef6\u540d\uff1a" + FileUpload.getDoPath(String.valueOf(up.getPathWater()) + up.getPathDateFileName()));
    }
}

